// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if (spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return false;
  }

  return true;
}

// main code block

var err;
var gVersion = "0.1";
var srDest = 37;

var err = initInstall("xHermes 0.3.1", "xhermes", gVersion);
logComment("initInstall: " + err);

var fProgram = getFolder("Program");
var fChrome = getFolder("Chrome");

if (verifyDiskSpace(fProgram, srDest))
{
  err = addDirectory("", gVersion, "xhermes", fChrome, "xhermes", true);
  logComment("addDirectory: " + err);

  registerChrome(CONTENT | DELAYED_CHROME, getFolder(fChrome, "xhermes"), "content/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(fChrome, "xhermes"), "locale/en-US/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(fChrome, "xhermes"), "locale/pl-PL/");

// pbartecki - 02.08 If you localized Hermes to your language remove comment tags /* ...  */  
// from line below and change ab-CD to your locale name. Comment out any locales from 
// above list if you do not want to register them. 

/* registerChrome(LOCALE | DELAYED_CHROME, getFolder(fChrome, "hermes"), "locale/ab-CD/"); */
/*  registerChrome(SKIN | DELAYED_CHROME, getFolder(fChrome, "hermes"), "skin/"); */

  if (getLastError() == SUCCESS)
  {
    err = performInstall(); 
    logComment("performInstall: " + err);
    alert("xHermes was successfuly installed on your system. \nRestart Mozilla and go to Tasks > xHermes.");
  }
  else
  {
    cancelInstall(err);
  }
}

// end main
