/* XULTech firelog is released under the Mozilla Public License:

   http://www.mozilla.org/MPL/MPL-1.1.html

   Copyright (C) 2006 Akeni Technologies
   http://www.akeni.com
   http://www.xultech.com
*/

var logViewerCgiCommandPath;

// var logViewerSeparator = null;
var logViewerPathName = null;
var logViewerFileOffset = null;
var logViewerFileChunkSize = 5000;
var logViewerFileSize = null;
var logViewerSliderMaxPos = null;
var logViewerSliderCurrentPos = null;
var logViewerSliderTimer = null;

var logViewerCurrentXMLHttpRequest = null;
var logViewerCurrentXMLHttpRequestPostData = null;

// This can be change by the user to suit their needs.
// on a slow dial up connect it makes sense to use a smaller value
// to get a faster response
var logViewerChunkSize = 64 * 1024;



function handleLogViewerLoad(cgiPath) {
    var startOffset = 0;
    debug("logviewer.js handleLogViewerLoad()");
    // The path is part of the URL, this make it possible to
    // bookmark it and use the viewer on the same file in the future.
    //
    // The file size is requested later.
    logViewerCgiCommandPath = "firelog.php?chunk=";
    const locationHref = window.location.href;
    const index0 = locationHref.indexOf('?');
    if (index0 == -1) {
        debug("firelog.js: there is no query string");
        return;
    }

    const index1 = locationHref.indexOf("path=", index0 + 1);
    assert(index0 > 0);
    assert(index1 > index0);
    logViewerPathName = decodeURIComponent(locationHref.slice(index1 + 5));
    // The path separator is always '/', even if the server is a
    // windows server.  This makes it easier to pass the path
    // on the URL withouth encodePathForUri() turning it into a mess.
    assert(logViewerPathName.indexOf('/') >= 0);
    if (index0 + 1 < index1) {
        const index2 = locationHref.indexOf("chunk=", index0);
        startOffset = locationHref.slice(index2 + 6, index1 - 1);
        debug("logviewer.js startOffset: " + startOffset);
        const index4 = startOffset.indexOf('/');
        if (index4 < 0) {
            startOffset = Number(startOffset);
        }
        else {
            debug("logviewer.js chunk: " + startOffset.slice(index4 + 1));
            logViewerChunkSize = Number(startOffset.slice(index4 + 1));
            startOffset = Number(startOffset.slice(0, index4));
        }
    }
    requestLogViewerContent(startOffset, logViewerChunkSize);
}



function getLogViewerPathTextbox() {
    const textbox = document.getElementById("log-viewer-path-textbox");
    assert(textbox);
    return textbox;
}



function getLogViewerContentTextbox() {
   const textbox=document.getElementById("log-viewer-content-textbox");
   assert(textbox);
   return textbox;
}



function getLogViewerUrlParameters(offset, length, pathName) {
    assert(offset >= 0);
    assert(length >= 0);
    return offset + '/' + length + '&path=' + encodePathForUri(pathName);
}



function requestLogViewerContent(offset, length) {
    // must use the sign of length rather than offset because offset can be 0
    assert(offset >= 0);
    assert(length >= 0);
    const url = logViewerCgiCommandPath +
        getLogViewerUrlParameters(offset, length, logViewerPathName)
    logViewerGetAsynchronousXMLHttpRequest
        (url, handleServerFilePartialContentResponse);
}



function getLogViewerThrobber() {
    const throbber = document.getElementById("log-viewer-throbber");
    assert(throbber);
    return throbber;
}



function getLogViewerSlider() {
    const slider = document.getElementById("log-viewer-offset-slider");
    assert(slider);
    return slider;
}



function getLogViewerOffsetTextbox() {
    const spinbox = document.getElementById("log-viewer-offset-textbox");
    assert(spinbox);
    return spinbox;
}



function logViewerPostAsynchronousXMLHttpRequest(url, data,responseHandler,
                                                      isSkipResponse) {
    var stopButton = null;
    const throbber = getLogViewerThrobber();
    logViewerCurrentXMLHttpRequestPostData = data;
    logViewerCurrentXMLHttpRequest = postAsynchronousXMLHttpRequest
        (url, data, responseHandler, throbber, stopButton, isSkipResponse);
    assert(logViewerCurrentXMLHttpRequest);
}



function logViewerGetAsynchronousXMLHttpRequest(url, responseHandler,
                                                     isSkipResponse) {
    var stopButton = null;
    const throbber = getLogViewerThrobber();
    logViewerCurrentXMLHttpRequestPostData = null;
    logViewerCurrentXMLHttpRequest = getAsynchronousXMLHttpRequest
        (url, responseHandler, throbber, stopButton, isSkipResponse);
    assert(logViewerCurrentXMLHttpRequest);
}



function handleServerFilePartialContentResponse(httpRequest, url, data) {
    var content, fileSize, pathName;
    pathName = logViewerPathName;
    const textbox = getLogViewerPathTextbox();
    if (data == logViewerCurrentXMLHttpRequestPostData) {
        assert(logViewerCurrentXMLHttpRequestPostData === null);
        logViewerCurrentXMLHttpRequestPostData = null;
        // The data has three parts
        // separator offset/filesize/Content...
        const response = httpRequest.responseText;
        debug("logviewer.js response: " +  response.slice(0, 80));
        if (response.indexOf("OK:") === 0) {
            const separator = response.charAt(3);
            if (separator == '\\') {
                pathName = pathName.replace(/\//g, '\\');
            }
            const index0 = response.indexOf('/', 4);
            const fileOffset = Number(response.slice(4, index0));
            const index1 = response.indexOf('/', index0 + 1);
            assert(index1 > index0);
            assert(response.charAt(index0) == '/');
            const contentLength = Number(response.slice(index0 + 1, index1));
            assert(response.charAt(index1) == '/');
            const index2 = response.indexOf('/', index1 + 1);
            assert(index2 > index1);
            fileSize = Number(response.slice(index1 + 1, index2));
            assert(response.charAt(index2) == '/');
            content = response.slice(index2 + 1);
            debug("content.length:" + content.length);
            assert(content.length == contentLength);
            getLogViewerContentTextbox().value = content;
            setupLogViewerSlider(fileOffset, contentLength, fileSize)
        }
        else {
            alert("Error: " + response);
            
        }
        if (!textbox.value) {
            textbox.value = pathName;
        }
    }
    else {
        debug("fileviewer.js throw away stale/cancelled request: " + url);
    }
}



function logViewerSliderPositionUpdate() {
    if (logViewerSliderTimer) {
        clearTimeout(logViewerSliderTimer);
    }
    // Use a timer so that as the user moves the cursor around on the
    // slider the application will not make unnecessary requests to the server
    logViewerSliderTimer =
        setTimeout("requestLogViewerContentFromSlider()", 500);
}



function requestLogViewerContentFromSlider() {
    var curpos;
    if (logViewerSliderMaxPos) {
        const slider = getLogViewerSlider();
        curpos = slider.getAttribute("curpos");
        curpos = Number(curpos);
        if (curpos != logViewerSliderCurrentPos) {
            // because we trap mouseover, there can be many spurious event
            // so use logViewerSliderCurrentPos to filter them out
            // const offset = (curpos / logViewerSliderMaxPos) *
            //     logViewerFileSize;
            const pageIncrement =  Number(slider.getAttribute("pageincrement"));
            if (curpos == logViewerFileSize) {
                curpos = logViewerFileSize - pageIncrement;
                assert(pageIncrement < logViewerChunkSize);
                if (curpos < 0) {
                    curpos = 0;
                }
            }
            else if (curpos < 500 &&
                     curpos == (logViewerFileOffset - pageIncrement)){
                curpos = 0;
            }
            requestLogViewerContent(curpos, logViewerChunkSize);
        }
    }
}



function logViewerLoadPath() {
    var url;
    const textbox = getLogViewerPathTextbox();
    const pathName = textbox.value.replace(/\\/g, '/');
    debug("logviewer.js logViewerLoadPath(" + pathName + ")");
    if (pathName != logViewerPathName) {
        const locationHref = window.location.href;
        const index = locationHref.indexOf("path=");
        if (index >= 0) {
            url = locationHref.slice(0, index + 5) + pathName;
        }
        else {
            url = locationHref + "?chunk=0/" + logViewerFileChunkSize +
                "&path=" + pathName;
        }
        debug("firelog.js url(" + url + ")");
        window.location.href = url;
    }
}



function setupLogViewerSlider(fileOffset, chunkSize, fileSize) {
    var curpos, maxpos, pageIncrement;
    assert(fileOffset >= 0);
    assert(fileSize >= 0);
    assert(fileOffset <= fileSize);
    logViewerFileOffset = fileOffset;
    logViewerFileSize = fileSize;
    logViewerFileChunkSize = chunkSize;

    const slider  = getLogViewerSlider();
    const spinbox = getLogViewerOffsetTextbox();

    spinbox.value = fileOffset;
    document.getElementById("log-viewer-filesize-label").value =
        ": " + (fileOffset + chunkSize) +  " / " + fileSize;

    if (fileSize <= chunkSize) {
        assert(fileSize == chunkSize);
        // There is no chunking
        slider.setAttribute("disabled", true);
        spinbox.setAttribute("disabled", true);
        logViewerSliderMaxPos = null;
        return;
    }
    
    slider.removeAttribute("disabled");
    spinbox.removeAttribute("disabled");
    curpos = fileOffset;
    // Make it a little bit less than the chunk size so that when
    // use scroll one page up or down, there is some overlapp
    pageIncrement = chunkSize - 200;
    if (pageIncrement < 100) {
        pageIncrement = 100;
    }
    maxpos = fileSize;
    debug("logviewer.js:" + curpos + " " + pageIncrement + " " + maxpos);
    logViewerSliderMaxPos = maxpos;
    logViewerSliderCurrentPos = curpos;
    slider.setAttribute("curpos", curpos);
    slider.setAttribute("maxpos", maxpos);
    slider.setAttribute("increment", 80);
    slider.setAttribute("pageincrement", pageIncrement);
}



function logViewerPathEditKeypress(event) {
    debug("logviewer.js logViewerPathEditKeypress:" + event.keyCode);
    if (event.keyCode == 13) {
        logViewerLoadPath();
    }
}



function logViewerFileOffsetEditKeypress(spinbox, event) {
    var curpos;
    const keyCode = event.keyCode;
    if (keyCode == 13) {
        logViewerUpdateSliderWithOffsetInputInternal(spinbox)
    }
}



function logViewerUpdateSliderWithOffsetInput() {
    logViewerUpdateSliderWithOffsetInputInternal(getLogViewerOffsetTextbox());
}



function logViewerUpdateSliderWithOffsetInputInternal(spinbox) {
    const slider  = getLogViewerSlider();
    curpos = Number(spinbox.value);
    if (curpos < 0) {
        curpos = 0;
    }
    else if (curpos > logViewerSliderMaxPos) {
        curpos = logViewerSliderMaxPos;
    }
    slider.setAttribute("curpos", curpos);
    requestLogViewerContentFromSlider();
}




var debug, debugAlert;

function debugOrAlert(text, isDebug) {
    if (isDebug) {
        debug(text);
    }
    else {
        alert(text);
    }
}


try {
    if (document) {
        if (document.createEvent) {
            function printfire() {
                printfire.args = arguments;
                dump(arguments);
                var event = document.createEvent("Events");
                event.initEvent("printfire", false, true);
                dispatchEvent(event);
            }
            debug = function(text) { printfire(text); };
        }
        else {
            debug = function(text) {
                dump(text);     
                // throw new Error(text);
                // setTimeout('"' + text, 0);
            };
        }
        debugAlert = function(text, isAlert) {
            if (isAlert === false) {
                debug(text);
            }
            else {
                alert(text);
            }
        };
    }
}
catch (ex) {
    debug = function (text) {
            // Don't use if (__debug__) because text could still take time to
            // generate. If you don't want to see it, comment it out.
            print(text);
        };
    debugAlert = function (text) {
        // See comment about __debug__ in debug.
        print(text);
    };
}


function assert2(value, text, isAlert) {
    var failure;
    if (text === undefined) {
        failure = "Assertion text is not defined:" + getStackTrace(new Error());
    }
    if (!value) {
        failure = "Assertion failure: " + text +"\n"+getStackTrace(new Error());
    }
    if (failure) {
    }
}


function assert(value, isAlert) {
    if (!value) {
        debugAlert("Assertion failure", isAlert);
    }
}


function encodePathForUri(path) {
    debug("firelog.js encodePathForUri(" + path + ")");
    return encodeURIComponent(path.replace(/\\/g, "/"));
}


function setupThrobberAndStopButton(throbber, stopButton, state) {
    assert2(state === true || state === false, state);
    if (throbber) {
        throbber.setAttribute("stopped", !state);
    }
    if (stopButton) {
        stopButton.setAttribute("disabled", !state);
    }
}



function abortXMLHttpRequest(request, throbber, stopButton) {
    assert(request);
    debug("xulutil.js abortXMLHttpRequest");
    request.abort();
    setupThrobberAndStopButton(throbber, stopButton, false);
}



function postAsynchronousXMLHttpRequest(url, data, handleReponse,
                                        throbber, stopButton, isSkipResponse) {
    return asynchronousXMLHttpRequestInternal(url, data, handleReponse,throbber,
                                              stopButton, isSkipResponse);
}



function getAsynchronousXMLHttpRequest(url, handleReponse,
                                       throbber, stopButton, isSkipResponse) {
    return asynchronousXMLHttpRequestInternal(url, null, handleReponse,throbber,
                                              stopButton, isSkipResponse);
}



function asynchronousXMLHttpRequestInternal(url, data, handleReponse, throbber,
                                            stopButton, isSkipResponse) {
    // debug("xulutil.js asynchronousXMLHttpRequestInternal(" + url + ")");
    var status;
    const http = new XMLHttpRequest();
    assert(http);
    assert(!(handleReponse && isSkipResponse));
    setupThrobberAndStopButton(throbber, stopButton, true);
    http.onreadystatechange = function() {
        if (http.readyState == 4) {
            try {
                status = http.status;
            }
            catch (ex) {
                // This seems to happen if the request was aborted by user ...
                // because the page could be in the process of being
                // unloaded, debug() may not bbe defined at this point...
                if (typeof debug != 'undefined') {
                    debug("xulutil.js http.status: " + ex);
                }
            }
            if (status == 200) {
                // debug("xulutil.js http.responseText("+http.responseText+")")
                if (!isSkipResponse) {
                    // isSkipResponse is usually used when the window is being
                    // closed and we want to send out a final "logout" message
                    // to the server.  By the time the reply come back the
                    // window is already gone, so we can not call handleReponse
                    // debug("xulutil.js handleReponse(" + url + ")");
                    handleReponse(http, url, data);
                }
            }
            else if (status) {
                alert("xulutil: There was a problem retrieving data from " +
                      url + ":\n" + http.statusText);
            }
            if (!isSkipResponse) {
                // See comment above about isSkipResponse
                setupThrobberAndStopButton(throbber, stopButton, false);
            }
        }
    };
    if (data) {
        http.open("POST", url, true);
        http.setRequestHeader('Content-Type',
                              'application/x-www-form-urlencoded');
        http.send(data);
    }
    else {
        http.open("GET", url, true);
        http.send(null);
    }
    return http;
}



function showPopupCenterOnWindowByBoxId(popupBoxId, width, height) {
    const element = document.getElementById("log-viewer-main-box");
    assert(element);
    const elementBoxObject = element.boxObject;
    const box = document.getElementById(popupBoxId);
    const windowWidth = window.innerWidth;
    const windowHeight = window.innerHeight;
    assert(width > 0);
    assert(height > 0);
    assert(windowWidth > 0);
    assert(windowHeight > 0);
    const x = elementBoxObject.screenX + (windowWidth - width) / 2;
    const y = elementBoxObject.screenY + (windowHeight - height) / 2;
    box.parentNode.showPopup(element, x, y, "popup");
}



function helpUsersGuide() {
    window.open("firelogusersguide.html");
}



function helpProductWebsite() {
    window.open("http://www.xultech.com/en/home");
}



function helpCheckProductUpdate() {
    window.open("http://firelog.mozdev.org/installation.html");
}



function displayAboutProduct() {
    debug("firelog.js displayAboutProduct()");
    showPopupCenterOnWindowByBoxId("log-viewer-about-box", 400, 300);
}



function displayProductLicenseInfo() {
    alert("Firelog is licensed under the MPL.\n\n" +
          "Copyright© 2006 Akeni Technologies");
}



function hideAboutPopup() {
    document.getElementById("log-viewer-about-box").parentNode.hidePopup();
}


