/****************************************************************************
**  DerTandemBrowser - Synchronized browsing add-on for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of DerTandemBrowser.
**
**  DerTandemBrowser is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  DerTandemBrowser is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 

const gDTBversion = "version 0.6";

const DTB_CAPTAIN = 0;

const PT_BOOL         = 0;  // preference types
const PT_INT          = 1;
const PT_STR          = 2;
const PT_UNICHAR      = 3;
const PT_UNICHARLOCAL = 4;
const PT_FILE         = 5;

const CS_DISCONNECTED        = 0;  // connection state
const CS_CONNECTED           = 1;
const CS_WAITINGFORHANDSHAKE = 2;

const gStatusIconPaths =
{ 
  "READY"     : "chrome://dertandembrowser/content/statusReady.gif",
  "LOADING"   : "chrome://dertandembrowser/content/statusLoading.gif",
  "OUTOFSYNC" : "chrome://dertandembrowser/content/statusOutofsync.gif",
  "SOLO"      : "chrome://dertandembrowser/content/statusSolo.gif"
};


var   gEventsReceived = 0;
var   gChatInitialized = false;
var   gDTBBrowserStatusFilter;

var gDTBPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefService);

dtbUserPreferenceInfo = 
{
  verbose_msgs:      {defvalue: false, prefname: "verbosemsgs", preftype: PT_BOOL},
  tone_on_connect:   {defvalue: false, prefname: "toneonconnect", preftype: PT_BOOL},
  show_emoticons:    {defvalue: true, prefname: "showemoticons", preftype: PT_BOOL},
  play_sonicons:     {defvalue: true, prefname: "playsonicons", preftype: PT_BOOL},
  max_host_connects: {defvalue: 4, prefname: "maxhostconnects", preftype: PT_INT},
  nickname:          {defvalue: "dtb_partner", prefname: "nickname", preftype: PT_STR},
  info:              {defvalue: "", prefname: "info", preftype: PT_STR},
  chat_font_size:    {defvalue: "medium", prefname: "chatfontsize", preftype: PT_STR},
  prefNode:          gDTBPrefService.getBranch("extensions.dtb.")
}

gDTBController =
{
  connectState:      CS_DISCONNECTED,
  isHost:            false,
  tandem_browse:     false,
  tandem_position:   0,
  tandem_status:     "READY",
  last_tandem_url:   ""
}


function DTBRider(nick, info, status)
{
  this.nick = nick;
  this.info = info;
  this.status = status;
  this.address = "";
  this.connection = 0;      // index into connections array
}

gDTBRiders = new Array(); 
CommSock = null;


var gDTBCmdBuffer = "";

gCommHandlerIn =
{
  onMsgReceived:   function(msg_data)
  {
    if (getDTBUserPreferenceValue("verbose_msgs") == true)
      appendToChatDisplayRaw(msg_data + " " + msg_data.length);

    gDTBCmdBuffer += msg_data;

    var end_idx;
    while ((end_idx = gDTBCmdBuffer.search(/\n/)) >= 0)
     {
       var msg = gDTBCmdBuffer.substring(0, end_idx);
       gDTBCmdBuffer = gDTBCmdBuffer.substring(end_idx+1);

    if (msg[0] == 'c')           // chat message
     {
       chatMsg = msg.substring(1);
       appendToChatDisplay(chatMsg);

       // if host, echo msg back to other partners
       if (gDTBController.isHost)  
         CommSock.sendData(msg);
     }
    else if (msg[0] == 'w')      // whisper
     {
       chatMsg = msg.substring(1);
       appendToChatDisplay(chatMsg);
     }
    else if (msg[0] == 'u')      // url
     {
       if ( (gDTBController.tandem_browse == true) &&
            (gDTBController.tandem_position != DTB_CAPTAIN) )
        {
          var inURL = msg.substring(1);

          if (!isInternalJump(inURL))      // don't update status for internal
           {                               // jumps - no way to verify finish
             var status = "LOADING";
             gDTBController.tandem_status = "LOADING";
             CommSock.sendData("s" + gDTBController.tandem_position + status);
             if (gDTBController.isHost)
              {
                gDTBRiders[gDTBController.tandem_position].status = status;
                updatePartnerStatus(gDTBController.tandem_position, status);
              }
           }
          else
             gDTBController.last_tandem_url = inURL;

          loadURI(inURL);
        }

       // if host, echo msg back to other partners
       if (gDTBController.isHost)  
         setTimeout(sendCommandMessage, 100, msg);

     }
    else if (msg[0] == 'l')      // login (only received by host)
     {
       if (getDTBUserPreferenceValue("tone_on_connect") == true)
         playSoundFile("chrome://dertandembrowser/content/connectTone.wav");

       var raw_login_info = msg.substring(1);
       var login_arr = raw_login_info.split("|");
       gDTBRiders.push(new DTBRider(login_arr[0], login_arr[1], "READY"));

       CommSock.sendData("h" + (gDTBRiders.length - 1));
       updatePartnersListbox(gDTBRiders);

       appendToChatDisplay("Received connection request from " + login_arr[0]);

       var partners_update_msg = "r";
       for (var i in gDTBRiders)
         partners_update_msg += (gDTBRiders[i].nick + "," +
                                 gDTBRiders[i].info + "," +
                                 gDTBRiders[i].status + ":");

       partners_update_msg = partners_update_msg.substr(0, partners_update_msg.length - 1);
       setTimeout(sendCommandMessage, 500, partners_update_msg);
     }
    else if (msg[0] == 'h')      // handshake
     {
       if (gDTBController.connectState == CS_WAITINGFORHANDSHAKE)  //??? To be removed and replaced with routing scheme
        {
          gDTBController.connectState = CS_CONNECTED;
          document.getElementById("connect-btn").checked = true;
          gDTBController.tandem_position = parseInt(msg.substring(1));
          gDTBController.tandem_browse = true;
          gDTBController.tandem_status = "READY";
          document.getElementById('tandem-mode-btn').setAttribute('disabled', 'false');
          initTandemMode(true);
          appendToChatDisplay("handshake received: your position is " +
                               gDTBController.tandem_position);
        }
     }
    else if (msg[0] == 'g')      // goodbye
     {
       var match_arr = msg.match(/\d+/);
       var rider_idx = parseInt(match_arr[0]);

       appendToChatDisplay(gDTBRiders[rider_idx].nick + " has disconnected");

       if (gDTBController.tandem_position > rider_idx)
         gDTBController.tandem_position--;

       if (gDTBController.isHost)
        {  
          setTimeout(sendCommandMessage, 200, msg);  // allow time for partner to
                                                     // disconnect before echoing msg
          gDTBRiders.splice(rider_idx, 1);
          updatePartnersListbox(gDTBRiders);

          var partners_update_msg = "r";
          for (var i in gDTBRiders)
          partners_update_msg += (gDTBRiders[i].nick + "," +
                                 gDTBRiders[i].info + "," +
                                 gDTBRiders[i].status + ":");

          partners_update_msg = partners_update_msg.substr(0, partners_update_msg.length - 1);

          setTimeout(sendCommandMessage, 600, partners_update_msg);   // allow time for partner
        }                                                             // to disconnect before
     }                                                                // sending message
    else if (msg[0] == 'r')      // partners update
     {
       gDTBRiders.splice(0, gDTBRiders.length);

       var raw_partners_msg = msg.substring(1);
       var partners_arr = raw_partners_msg.split(":");
       for (var i in partners_arr)
        {
          var rider_fields = partners_arr[i].split(",");
          gDTBRiders.push(new DTBRider(rider_fields[0], rider_fields[1], rider_fields[2]));
        }

       updatePartnersListbox(gDTBRiders);

     }
    else if (msg[0] == 's')      // status update
     {
       var match_arr = msg.match(/\d+/);
       var rider_idx = parseInt(match_arr[0]);
       gDTBRiders[rider_idx].status = msg.substring(match_arr.index+match_arr[0].length);

       updatePartnerStatus(rider_idx, gDTBRiders[rider_idx].status);

       if (getDTBUserPreferenceValue("verbose_msgs") == true)
         appendToChatDisplayRaw(gDTBRiders[rider_idx].nick +
                                "'s status updated to " + 
                                gDTBRiders[rider_idx].status);
       
       // if host, echo msg back to other partners
       if (gDTBController.isHost)  
         CommSock.sendData(msg);
     }
    else if (msg[0] == 'i')      // info update
     {
       var match_arr = msg.match(/\d+/);
       var rider_idx = parseInt(match_arr[0]);
       gDTBRiders[rider_idx].info = msg.substring(match_arr.index+match_arr[0].length);
       
       // if host, echo msg back to other partners
       if (gDTBController.isHost)  
         CommSock.sendData(msg);
     }
    else if (msg[0] == 'p')      // promote
     {
       var match_arr = msg.match(/\d+/);
       var rider_idx = parseInt(match_arr[0]);

       var temp_rider = gDTBRiders[DTB_CAPTAIN];
       gDTBRiders[DTB_CAPTAIN] = gDTBRiders[rider_idx];
       gDTBRiders[rider_idx] = temp_rider;

       if (rider_idx == gDTBController.tandem_position)
        {
          gDTBController.tandem_position = DTB_CAPTAIN;
        }
       else if (gDTBController.tandem_position == DTB_CAPTAIN)
         gDTBController.tandem_position = rider_idx;

       updatePartnersListbox(gDTBRiders);
       appendToChatDisplay(gDTBRiders[DTB_CAPTAIN].nick + " has been promoted");

       // if host, echo msg back to other partners
       if (gDTBController.isHost)  
         CommSock.sendData(msg);
     }
    else if (msg[0] == 'f')      // file
     {
     }

     } // end while loop 

    if (gDTBCmdBuffer != "")
     {
      if (getDTBUserPreferenceValue("verbose_msgs") == true)
        appendToChatDisplayRaw("Unterminated command received " + gDTBCmdBuffer);
     }

  },

  onStreamClose:   function(status)
  {
    appendToChatDisplay("In Connection closed");
    onDisconnect();
  }
}


gCommHandlerOut =
{
  onStreamClose:   function(status)
  {
    appendToChatDisplay("Out Connection closed");
    onDisconnect();
  }
}


function connectButtonHandler()
{
  if (gDTBController.connectState == CS_DISCONNECTED)
   {
     connectRequest = new Object();

     connectRequest.asHost = false;
     connectRequest.address = "";
     connectRequest.cancel = false;

     window.openDialog('chrome://dertandembrowser/content/dialogConnect.xul',
                       'dtbConnect','chrome,modal,centerscreen', connectRequest);
        
     if (!connectRequest.cancel)
      {
        if (connectRequest.asHost == true)
          connectRequest.address = "localhost";

        appendToChatDisplay("Requested connection address is: " + connectRequest.address);
        appendToChatDisplay("Connecting as " +
                            (connectRequest.asHost ? "host" : "client") +
                            "...");

        CommSock = new Socket();
        CommSock.open(connectRequest.address, 4444, gCommHandlerIn, gCommHandlerOut);

          
        if ((CommSock) && (CommSock.isConnected))
         {
           gDTBController.isHost = connectRequest.asHost;
           var localnick = getDTBUserPreferenceValue("nickname");
           var localinfo = getDTBUserPreferenceValue("info");

           if (gDTBController.isHost)
            {
              appendToChatDisplay("Connected");
              gDTBController.connectState = CS_CONNECTED;
              document.getElementById("connect-btn").checked = true;
              
              gDTBController.tandem_position = DTB_CAPTAIN;
              gDTBRiders.push(new DTBRider(localnick + "[H]", localinfo, "SOLO"));
              updatePartnersListbox(gDTBRiders);
              appendToChatDisplay("Waiting for partners to connect...");

              document.getElementById('tandem-mode-btn').setAttribute('disabled', 'false');
            }
           else // !host
            try
             { 
               CommSock.sendData("l" + localnick + "|" + localinfo);
               gDTBController.connectState = CS_WAITINGFORHANDSHAKE;
               appendToChatDisplay("Waiting for handshake...");
             }
            catch (e)
             {
               appendToChatDisplay("Unable to request handshake.");
               throw (e);
             }
          
         }

      }

   }  // end if connectState == DISCONNECTED
}


function onDisconnect()
{
  if (gDTBController.connectState != CS_DISCONNECTED)
   {
     CommSock.close();
     gDTBController.connectState = CS_DISCONNECTED;
     document.getElementById("disconnect-btn").checked = true;

     if (gDTBController.tandem_browse == true)
      {
        gDTBController.tandem_browse = false;
        initTandemMode(false);
      }
     document.getElementById("tandem-mode-btn").disabled = true;

     gDTBRiders.splice(0, gDTBRiders.length);
     updatePartnersListbox(gDTBRiders);
   }
}


function disconnectButtonHandler()
{
  if (gDTBController.connectState == CS_CONNECTED)
   {
     if (!gDTBController.isHost)
       CommSock.sendData("g" + gDTBController.tandem_position);

     setTimeout(onDisconnect, 200);  // allow time for goodbye message to
                                     // be sent before closing socket
   }
}


function playSoundFile(sfile_str)
{
  var sample = Components.classes["@mozilla.org/sound;1"].createInstance();
  sample = sample.QueryInterface(Components.interfaces.nsISound);
  const SND_NETWORK_STD_CID = "@mozilla.org/network/standard-url;1";
  const SND_I_URL           = "nsIURL";
  const SND_URL             = new Components.Constructor(SND_NETWORK_STD_CID, SND_I_URL);
  var url                   = new SND_URL();
  url.spec                  = sfile_str;
  sample.play(url);

}


function appendToChatDisplayRaw(append_text_str)
{
  var text_node;
  var chat_display_area = document.getElementById("chat-display-frame");
  var w = chat_display_area.contentWindow;
  var c = chat_display_area.contentDocument;
  var chat_body;

  if (!gChatInitialized)
   {
     c.open( );
     c.write("<html><body id=\"chat-display-body\"></body></html>");
     c.close();
     gChatInitialized = true;

     chat_body = w.document.getElementById("chat-display-body");
     var pref_font_size = getDTBUserPreferenceValue("chat_font_size");
     chat_body.setAttribute("style", "font-size: " + pref_font_size);
   }

  chat_body = w.document.getElementById("chat-display-body");

  text_node = document.createTextNode(append_text_str);
  chat_body.appendChild(text_node);

  var line_break = document.createElementNS("http://www.w3.org/1999/xhtml", "html:br");
  chat_body.appendChild(line_break);

  w.scrollTo(0, w.document.height);
}


function appendToChatDisplay(text_str)
{
  var chat_display_area = document.getElementById("chat-display-frame");
  var w = chat_display_area.contentWindow;
  var c = chat_display_area.contentDocument;
  var chat_body;

  if (!gChatInitialized)
   {
     c.open( );
     c.write("<html><body id=\"chat-display-body\"></body></html>");
     c.close();
     gChatInitialized = true;

     chat_body = w.document.getElementById("chat-display-body");
     var pref_font_size = getDTBUserPreferenceValue("chat_font_size");
     chat_body.setAttribute("style", "font-size: " + pref_font_size);
   }

  chat_body = w.document.getElementById("chat-display-body");

  parseForChatWidgets(text_str, chat_body);

  var line_break = document.createElementNS("http://www.w3.org/1999/xhtml", "html:br");
  chat_body.appendChild(line_break);

  w.scrollTo(0, w.document.height);
}

  
function sendChatText()
{
  var chat_input_box = document.getElementById("chat-enter-tbox");
  var user_nick = getDTBUserPreferenceValue("nickname");

  var chat_msg_txt = chat_input_box.value;

  if (chat_msg_txt.substring(0,3) == "/me")
    chat_msg_txt = "/" + user_nick + ":" + chat_msg_txt.substring(3);
  else
    chat_msg_txt = user_nick + ": " + chat_msg_txt;

  if ((gDTBController.connectState == CS_DISCONNECTED) ||
      (gDTBController.isHost == true) )
   {
     appendToChatDisplay(chat_msg_txt);
   }

  if (gDTBController.connectState == CS_CONNECTED)
     CommSock.sendData("c" + chat_msg_txt);

  chat_input_box.value = "";
}


function onChatInputKeypress(e)
{
  // if 'Enter' key, text input is finished

  if (e.keyCode == 13)
    sendChatText();
}


function insertEmoticon(emoticonText)
{
  var chat_input_tbox = document.getElementById("chat-enter-tbox");
  chat_input_tbox.value += emoticonText;
  chat_input_tbox.focus();
  chat_input_tbox.setSelectionRange(chat_input_tbox.textLength,
                                    chat_input_tbox.textLength);
}


function insertCurrentURL()
{
  var chat_input_tbox = document.getElementById("chat-enter-tbox");
  chat_input_tbox.value += getWebNavigation().currentURI.spec;
  chat_input_tbox.focus();
  chat_input_tbox.setSelectionRange(chat_input_tbox.textLength,
                                    chat_input_tbox.textLength);
}


function onDTBDocumentLoad(event)
{
  if (event.originalTarget == _content.document)
   {
     var currentURI_str = getWebNavigation().currentURI.spec;

     if (getDTBUserPreferenceValue("verbose_msgs") == true)
       appendToChatDisplay("event received " + currentURI_str + " " + gEventsReceived++);

     if (gDTBController.tandem_browse)
      {
        if (gDTBController.tandem_status == "LOADING")
         {
           var status = "READY";
           gDTBController.tandem_status = "READY";
           CommSock.sendData("s" + gDTBController.tandem_position + status);
           if (gDTBController.isHost)
            {
              gDTBRiders[gDTBController.tandem_position].status = status;
              updatePartnerStatus(gDTBController.tandem_position, status);
            }
           gDTBController.last_tandem_url = currentURI_str;
         }
      }
   }
}

 
dtbWebLocationListener =
{
  QueryInterface:  function(aIID)
  {
      if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
          aIID.equals(Components.interfaces.nsISupports))
        return this;
      else
        throw Components.results.NS_NOINTERFACE;
  },

  onLocationChange:   function(webProgressObj, requestObj, aURI)
  {
     if (getDTBUserPreferenceValue("verbose_msgs") == true)
       appendToChatDisplayRaw("location changed to " + aURI.spec);

     if (gDTBController.tandem_browse)
      {
        if (gDTBController.tandem_position == DTB_CAPTAIN)
         {
           if (aURI.spec.search(/file:/) < 0)
            {
              if (!isInternalJump(aURI.spec))  // don't update status for internal
               {                               // jumps - no way to verify finish
                 var status = "LOADING";
                 gDTBController.tandem_status = "LOADING";
                 CommSock.sendData("s" + gDTBController.tandem_position + status);
                 if (gDTBController.isHost)
                  {
                    gDTBRiders[gDTBController.tandem_position].status = status;
                    updatePartnerStatus(gDTBController.tandem_position, status);
                  }
               }
               else
                 gDTBController.last_tandem_url = aURI.spec;

              var url_msg = "u" + aURI.spec;
              setTimeout(sendCommandMessage, 200, url_msg);
            }
           else    
             appendToChatDisplay("File transfer not implemented");
         }
      }
  },

  onStateChange:   function(aWebProgress, aRequest, aStateFlags, aStatus)
  {
     if (getDTBUserPreferenceValue("verbose_msgs") == true)
       appendToChatDisplayRaw("onStateChange received");

     if (aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_STOP)
      {
        // This (thanks to the filter) is a network stop or the last
        // request stop outside of loading the document. If still loading
        // when this is received, load of tandem url was not successful
        // for some reason. Change status to OutOfSync.

        if (gDTBController.tandem_status == "LOADING")
         {
           var status = "OUTOFSYNC";
           gDTBController.tandem_status = "OUTOFSYNC";
           CommSock.sendData("s" + gDTBController.tandem_position + status);
           if (gDTBController.isHost)
            {
              gDTBRiders[gDTBController.tandem_position].status = status;
              updatePartnerStatus(gDTBController.tandem_position, status);
            } 
         }
      }
  },

  onProgressChange:   function(webProgressObj, requestObj, aInt1, aInt2, aInt3, aInt4)
  {
//     if (getDTBUserPreferenceValue("verbose_msgs") == true)
//       appendToChatDisplayRaw("onProgressChange received");
  },

  onStatusChange:   function(webProgressObj, requestObj, aInt1, status_str)
  {
//     if (getDTBUserPreferenceValue("verbose_msgs") == true)
//       appendToChatDisplayRaw("onStatusChange received: " + status_str);
  },

  onSecurityChange:   function(webProgressObj, requestObj, aInt1)
  {
//     if (getDTBUserPreferenceValue("verbose_msgs") == true)
//       appendToChatDisplayRaw("onSecurityChange received");
  }

}


function addDocumentLoadHandlers()
{
  if (getDTBUserPreferenceValue("verbose_msgs") == true)
    appendToChatDisplayRaw("Adding Document Load handlers...");

  var contentArea = document.getElementById('appcontent');

  if (contentArea)
   {
    contentArea.addEventListener('load', onDTBDocumentLoad, true);
   }
  else
    alert("Couldn't get appcontent");

  gDTBBrowserStatusFilter = Components.classes["@mozilla.org/appshell/component/browser-status-filter;1"]
                                       .createInstance(Components.interfaces.nsIWebProgress);


  getBrowser().mCurrentBrowser.webProgress.addProgressListener(gDTBBrowserStatusFilter,
                                   Components.interfaces.nsIWebProgress.NOTIFY_ALL);

  gDTBBrowserStatusFilter.addProgressListener(dtbWebLocationListener,
                             Components.interfaces.nsIWebProgress.NOTIFY_ALL);

}


function removeDocumentLoadHandlers()
{
  if (getDTBUserPreferenceValue("verbose_msgs") == true)
    appendToChatDisplayRaw("Removing Document Load handlers...");

  var contentArea = document.getElementById('appcontent');

  if (contentArea)
   {
    contentArea.removeEventListener('load', onDTBDocumentLoad, true);
   }
  else
    alert("Couldn't get appcontent");

  if (gDTBBrowserStatusFilter)
   {
     getBrowser().mCurrentBrowser.webProgress.removeProgressListener(gDTBBrowserStatusFilter);
     gDTBBrowserStatusFilter.removeProgressListener(dtbWebLocationListener);
   }

}


function initTandemMode(bTandemBrowse)
{
  document.getElementById("tandem-mode-btn").checked = bTandemBrowse;

  if (bTandemBrowse)
    addDocumentLoadHandlers();
  else
    removeDocumentLoadHandlers();
}


function toggleTandemMode()
{
  var status;

  gDTBController.tandem_browse = !gDTBController.tandem_browse;

  initTandemMode(gDTBController.tandem_browse);

  if (gDTBController.tandem_browse)
    status = "READY"
  else
    status = "SOLO"

  CommSock.sendData("s" + gDTBController.tandem_position + status);

  if (gDTBController.isHost)
   {
     gDTBRiders[gDTBController.tandem_position].status = status;
     updatePartnerStatus(gDTBController.tandem_position, status);
   }
}


function displayDerTandemBrowserBar(bChecked_str)  // takes attribute value as argument
{
  if (bChecked_str == "true")
   { 
     document.getElementById('derTandemBrowserBar').setAttribute("collapsed", "false");
     document.getElementById('dtbSplit').setAttribute("hidden", "false");
     document.getElementById('dtbSplit').setAttribute("state", "open");
   }
  else
   { 
     document.getElementById('derTandemBrowserBar').setAttribute("collapsed", "true");
     document.getElementById('dtbSplit').setAttribute("hidden", "true");

     // need to set menu item attribute 'checked' to false to persist it - if not
     // explicitly set false, the attribute is simply removed.
     document.getElementById('DerTandemBrowser-menuitem').setAttribute("checked", "false");
   }

}


function displayAboutInfo()
{
  var version_display = document.getElementById("dtb-version-string");

  version_display.value = "Der Tandem Browser, the browser built for two (tm): " + gDTBversion;
  document.getElementById("dtbViewPane-deck").selectedIndex=2;

} 


function setChatAreaFontSize(size_str)
{
  var chat_display_area = document.getElementById("chat-display-frame");
  var w = chat_display_area.contentWindow;
  var chat_body = chat_display_area.contentDocument.getElementById("chat-display-body");

  chat_body.setAttribute("style", "font-size: " + size_str);
  w.scrollTo(0, w.document.height);


  // remember font size setting
  // need to set menu item 'checked' attribute to persist it properly

  setDTBUserPreferenceValue("chat_font_size", size_str);

  var font0_mitem = document.getElementById("dtb-chatarea-font0-mitem");
  var font1_mitem = document.getElementById("dtb-chatarea-font1-mitem");

  font0_mitem.setAttribute("checked", (size_str == "small" ? "true" : "false"));
  font1_mitem.setAttribute("checked", (size_str == "medium" ? "true" : "false"));

}


function displaySettingsPanel()
{
  var verbose_cb = document.getElementById("verbose-cb");
  verbose_cb.checked = getDTBUserPreferenceValue("verbose_msgs");

  var connect_tone_cb = document.getElementById("connect-tone-cb");
  connect_tone_cb.checked = getDTBUserPreferenceValue("tone_on_connect");

  var emoticons_cb = document.getElementById("emoticons-cb");
  emoticons_cb.checked = getDTBUserPreferenceValue("show_emoticons");

  var sonicons_cb = document.getElementById("sonicons-cb");
  sonicons_cb.checked = getDTBUserPreferenceValue("play_sonicons");

  var max_host_connects_tbox = document.getElementById("max-host-connects-tbox");
  max_host_connects_tbox.value = getDTBUserPreferenceValue("max_host_connects");

  var nickname_tbox = document.getElementById("nickname-tbox");
  nickname_tbox.value = getDTBUserPreferenceValue("nickname");

  var info_tbox = document.getElementById("info-tbox");
  info_tbox.value = getDTBUserPreferenceValue("info");

  document.getElementById("dtbViewPane-deck").selectedIndex=1;

} 


function configureEmoticonMenu()
{
  var sonicon0_mitem = document.getElementById("sonicon0-mitem");
  var sonicon1_mitem = document.getElementById("sonicon1-mitem");

  var bSonicon = getDTBUserPreferenceValue("play_sonicons");

  sonicon0_mitem.setAttribute("hidden", (bSonicon ? "false" : "true"));
  sonicon1_mitem.setAttribute("hidden", (bSonicon ? "false" : "true"));
}


function configurePartnersContextMenu()
{
  var selectedPartnerIndex = document.getElementById("partners-lbox").selectedIndex;

  document.getElementById("dtb-partner-promote-mitem").setAttribute("disabled", "true");
  document.getElementById("dtb-partner-disconnect-mitem").setAttribute("disabled", "true");
  document.getElementById("dtb-partner-deselect-mitem").setAttribute("disabled", "true");

  if (selectedPartnerIndex >= 0)
   { 
     if ( (gDTBController.tandem_position == DTB_CAPTAIN) &&
          (selectedPartnerIndex != DTB_CAPTAIN) )
      {
        document.getElementById("dtb-partner-promote-mitem").setAttribute("disabled", "false");
      }
   
     //document.getElementById("dtb-partner-disconnect-mitem").setAttribute("disabled", "false");

     document.getElementById("dtb-partner-deselect-mitem").setAttribute("disabled", "false");
   }
}


function promoteDTBPartner()
{
  var temp_rider;

  var selected_partner_index = document.getElementById("partners-lbox").selectedIndex;

  CommSock.sendData("p" + selected_partner_index);

  if (gDTBController.isHost)
   { 
     temp_rider = gDTBRiders[DTB_CAPTAIN];
     gDTBRiders[DTB_CAPTAIN] = gDTBRiders[selected_partner_index];
     gDTBRiders[selected_partner_index] = temp_rider;
     gDTBController.tandem_position = selected_partner_index;

     updatePartnersListbox(gDTBRiders);
     appendToChatDisplay(gDTBRiders[DTB_CAPTAIN].nick + " has been promoted");
   }

}


function dtbViewFile()
{
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"]
           .createInstance(nsIFilePicker);

  fp.init(window, "Select a File", nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterHTML);

  var res = fp.show();

  if (res == nsIFilePicker.returnOK)
   {
     loadURI(fp.fileURL.spec);
   }
}


function isInternalJump(url_str)
{
  var rv = false;
  var ubase_spec, lbase_spec;

  var uidx = url_str.search(/#/);
  var lidx = gDTBController.last_tandem_url.search(/#/);

  if ( (uidx >= 0) || (lidx >= 0) )
   {
     if (uidx < 0)
       ubase_spec = url_str;
     else
       ubase_spec = url_str.substring(0, uidx);

     if (lidx < 0)
       lbase_spec = gDTBController.last_tandem_url;
     else
       lbase_spec = gDTBController.last_tandem_url.substring(0, lidx);


     if (ubase_spec == lbase_spec)
      {
        rv = true;
      }
   }

  if (rv == true)
   {
    if (getDTBUserPreferenceValue("verbose_msgs") == true)
      appendToChatDisplayRaw("Jump to internal link");
   }

  return rv;
}


function showPartnerInfoBox(position)
{
  var partner_ttip = document.getElementById("dtb-partner-ttip");
  var partners_lbox = document.getElementById("partners-lbox");

  partner_ttip.setAttribute("nick", gDTBRiders[position].nick);
  partner_ttip.setAttribute("info", gDTBRiders[position].info);

  partner_ttip.showPopup(partners_lbox, -1, -1, "tooltip", "topleft", "bottomleft");
} 


function updatePartnersListbox(partners_arr)
{
  var li, lc, vb, img, ttip, ttip_id;
  var partners_lbox = document.getElementById("partners-lbox");

  var num_partners = partners_lbox.getRowCount();

  // remove old partners, starting at 3rd item
  // ('listhead' and 'listcols' are first two
  // items/elements in listbox)

  for (var pidx = 1; pidx <= num_partners; pidx++)
    partners_lbox.removeItemAt(2);
  
  for (var i in partners_arr)
   {
    li = document.createElement("listitem");

    lc = document.createElement("listcell");
    lc.setAttribute ("label", partners_arr[i].nick);

    vb = document.createElement("vbox");
    vb.setAttribute ("align", "center");

    img = document.createElement("image");
    img.setAttribute ("src", gStatusIconPaths[partners_arr[i].status]);
    vb.appendChild(img);

    li.appendChild(lc);
    li.appendChild(vb);

    var onmouseover_str = "showPartnerInfoBox(" + i + ");"

    li.setAttribute ("onmouseover", onmouseover_str);
    li.setAttribute ("onmouseout", "document.getElementById('dtb-partner-ttip').hidePopup();");

    partners_lbox.appendChild(li);
   }

  if (partners_arr.length > 0)
   {
     var local_nick_item = partners_lbox.getItemAtIndex(gDTBController.tandem_position);
     local_nick_item.setAttribute("style", "font-weight: bold");
   }
   
}


function updatePartnerStatus(position, status)
{
  var li_child_arr, status_icon;
  var partners_lbox = document.getElementById("partners-lbox");

  li_child_arr = partners_lbox.getItemAtIndex(position).childNodes;
  status_icon = li_child_arr[1].firstChild;
  status_icon.setAttribute("src", gStatusIconPaths[status]);
}


function sendCommandMessage(commandMsg_str)
{
  CommSock.sendData(commandMsg_str);
}


function getDTBUserPreferenceValue(prefId_str)
{
  return (getUserPreference(dtbUserPreferenceInfo[prefId_str].prefname,
                            dtbUserPreferenceInfo[prefId_str].defvalue,
                            dtbUserPreferenceInfo[prefId_str].preftype,
                            dtbUserPreferenceInfo.prefNode));
}


function getUserPreference(prefName, defValue, prefType, prefNode)
{
  var e, rv;

  switch(prefType)
   {
     case PT_BOOL:

       try {rv = prefNode.getBoolPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case PT_INT:
       
       try {rv = prefNode.getIntPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case PT_STR:

       try {rv = prefNode.getCharPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case PT_UNICHAR:
     case PT_UNICHARLOCAL:
     case PT_FILE:

     default:
       alert("Preference type not implemented"); // DEBUG
   }

  return rv;
}


function setDTBUserPreferenceValue(prefId_str, value)
{
  setUserPreference(dtbUserPreferenceInfo[prefId_str].prefname, value,
                    dtbUserPreferenceInfo[prefId_str].preftype,
                    dtbUserPreferenceInfo.prefNode);
}


function setUserPreference(prefName, prefValue, prefType, prefNode)
{
  switch(prefType)
   {
     case PT_BOOL:
       prefNode.setBoolPref(prefName, prefValue);
       break;

     case PT_INT:
       prefNode.setIntPref(prefName, prefValue);
       break;

     case PT_STR:
       prefNode.setCharPref(prefName, prefValue);
       break;

     case PT_UNICHAR:
     case PT_UNICHARLOCAL:
     case PT_FILE:

     default:
       alert("Preference type not implemented"); // DEBUG
   }
}


function updateDTBSettings()
{
  if (document.getElementById("nickname-tbox").value.search(/\W/) >= 0)
   {
     alert("Error 01: Please reenter nickname using only characters [A-Za-z0-9_].");
   }
  else
   {
     var verbose_cb = document.getElementById("verbose-cb");
     setDTBUserPreferenceValue("verbose_msgs", verbose_cb.checked);

     var connect_tone_cb = document.getElementById("connect-tone-cb");
     setDTBUserPreferenceValue("tone_on_connect", connect_tone_cb.checked);

     var emoticons_cb = document.getElementById("emoticons-cb");
     setDTBUserPreferenceValue("show_emoticons", emoticons_cb.checked);

     var sonicons_cb = document.getElementById("sonicons-cb");
     setDTBUserPreferenceValue("play_sonicons", sonicons_cb.checked);

     var max_host_connects_tbox = document.getElementById("max-host-connects-tbox");
     setDTBUserPreferenceValue("max_host_connects", max_host_connects_tbox.value);

     var old_nick = getDTBUserPreferenceValue("nickname");
     var nickname_tbox = document.getElementById("nickname-tbox");

     if (gDTBController.connectState == CS_DISCONNECTED)
       setDTBUserPreferenceValue("nickname", nickname_tbox.value);
     else
       if (old_nick != nickname_tbox.value)
         alert("Error 02: Cannot alter nickname while connected - change ignored.");

     var old_info = getDTBUserPreferenceValue("info");
     var info_tbox = document.getElementById("info-tbox");
     setDTBUserPreferenceValue("info", info_tbox.value);

     if ( (gDTBController.connectState == CS_CONNECTED) &&
          (old_info != info_tbox.value) )
      {
        CommSock.sendData("i" + gDTBController.tandem_position + info_tbox.value);

        if (gDTBController.isHost)
          gDTBRiders[gDTBController.tandem_position].info = info_tbox.value;
      }

     //gPrefService.savePrefFile(null);

     document.getElementById("emoticon-menu-btn")
          .setAttribute("hidden", (emoticons_cb.checked ? "false" : "true"));

     document.getElementById("dtbViewPane-deck").selectedIndex = 0;
     document.getElementById("chat-view-btn").checked = true;
   }
}

