// open help viewer to appropriate topic when user presses F1
// called from helpContextOverlay.xul and helpMenuOverlay.xul

const CALENDAR_CONTENT_PACK = "chrome://calendarhelp/locale/help.rdf";

var helpFileURI = CALENDAR_CONTENT_PACK;

var RDF = Components
  .classes['@mozilla.org/rdf/rdf-service;1']
  .getService(Components.interfaces.nsIRDFService);

var RCU = Components
  .classes['@mozilla.org/rdf/container-utils;1']
  .getService(Components.interfaces.nsIRDFContainerUtils);


function openHelp(topic, contentPack) {
	if (!topic) {
	  var elem = document.commandDispatcher.focusedElement;
	  var id = elem.id;
	  while (elem) { 
	    if (id && id != "") break;
	    elem = elem.parentNode;
	    id = elem.id;
	    }
		if (!id) id = "";
		if (id != "") id = ":" + id;

  	var context = RDF.GetDataSourceBlocking("chrome://calendarhelp/content/context.rdf");

	  var res = context.GetSource(
	    RDF.GetResource("http://home.netscape.com/NC-rdf#name"),
	    RDF.GetLiteral(document.documentElement.id + id),
	    true);
	
	  if (res) {
			topic = context.GetTarget(
				res,
				RDF.GetResource("http://home.netscape.com/NC-rdf#topic"),
				true)
				.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
	    }
		}

  helpFileURI = contentPack || helpFileURI;

  var topWindow = locateHelpWindow(helpFileURI);
  if (topWindow) {
		topWindow.focus();
		topWindow.displayTopic(topic);
		}
	else {
    const params = Components.classes["@mozilla.org/embedcomp/dialogparam;1"]
			.createInstance(Components.interfaces.nsIDialogParamBlock);
    params.SetNumberStrings(2);
    params.SetString(0, helpFileURI);
    params.SetString(1, topic);
    const ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
			.getService(Components.interfaces.nsIWindowWatcher);
		topWindow = ww.openWindow(null, "chrome://help/content/help.xul", "_blank",
			"chrome,all,alwaysRaised,dialog=no", params);
		topWindow = locateHelpWindow(helpFileURI);
  }

}


function setHelpFileURI(rdfURI)
{
  helpFileURI = rdfURI;
}

function locateHelpWindow(contentPack) {
    const windowManagerInterface = Components
        .classes['@mozilla.org/appshell/window-mediator;1'].getService()
        .QueryInterface(Components.interfaces.nsIWindowMediator);
    const iterator = windowManagerInterface.getEnumerator("mozilla:help");
    var topWindow = null;
    var aWindow;

    while (iterator.hasMoreElements()) {
        aWindow = iterator.getNext();
        if (aWindow.getHelpFileURI() == contentPack) {
            topWindow = aWindow;
        }
    }
    return topWindow;
}
