/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.awt.Rectangle;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.WindowControl;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;
import org.mozilla.webclient.wrapper_native.NativeEventThread;

public class WindowControlImpl
extends ImplObjectNative
implements WindowControl {
    protected NativeEventThread eventThread = null;

    public WindowControlImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl, false);
    }

    public void delete() {
        Assert.assert_it(null != this.eventThread, "eventThread shouldn't be null at delete time");
        this.eventThread.delete();
        this.eventThread = null;
        this.nativeWebShell = -1;
    }

    NativeEventThread getNativeEventThread() {
        return this.eventThread;
    }

    public void setBounds(Rectangle rectangle) {
        ParameterCheck.nonNull(rectangle);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeSetBounds(this.nativeWebShell, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void createWindow(int n, Rectangle rectangle) {
        ParameterCheck.greaterThan(n, 0);
        ParameterCheck.nonNull(rectangle);
        this.myFactory.throwExceptionIfNotInitialized();
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            WindowControlImpl windowControlImpl = this;
            synchronized (windowControlImpl) {
                this.nativeWebShell = this.nativeCreateInitContext(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.myBrowserControl);
                this.eventThread = new NativeEventThread("EventThread-" + this.nativeWebShell, this.myBrowserControl);
                this.eventThread.start();
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    System.out.println("WindowControlImpl.createWindow: interrupted while waiting\n\t for NativeEventThread to notify(): " + exception + " " + exception.getMessage());
                }
            }
        }
    }

    public int getNativeWebShell() {
        this.myFactory.throwExceptionIfNotInitialized();
        return this.nativeWebShell;
    }

    public void moveWindowTo(int n, int n2) {
        this.myFactory.throwExceptionIfNotInitialized();
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeMoveWindowTo(this.nativeWebShell, n, n2);
        }
    }

    public void removeFocus() {
        this.myFactory.throwExceptionIfNotInitialized();
        throw new UnimplementedException("\nUnimplementedException -----\n API Function WindowControl::removeFocus has not yet been implemented.\n");
    }

    public void repaint(boolean bl) {
        this.myFactory.throwExceptionIfNotInitialized();
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeRepaint(this.nativeWebShell, bl);
        }
    }

    public void setVisible(boolean bl) {
        this.myFactory.throwExceptionIfNotInitialized();
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeSetVisible(this.nativeWebShell, bl);
        }
    }

    public void setFocus() {
        this.myFactory.throwExceptionIfNotInitialized();
        throw new UnimplementedException("\nUnimplementedException -----\n API Function WindowControl::setFocus has not yet been implemented.\n");
    }

    public native void nativeSetBounds(int var1, int var2, int var3, int var4, int var5);

    public native int nativeCreateInitContext(int var1, int var2, int var3, int var4, int var5, BrowserControl var6);

    public native void nativeDestroyInitContext(int var1);

    public native void nativeMoveWindowTo(int var1, int var2, int var3);

    public native void nativeRemoveFocus(int var1);

    public native void nativeRepaint(int var1, boolean var2);

    public native void nativeSetVisible(int var1, boolean var2);

    public native void nativeSetFocus(int var1);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("WindowControlImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: WindowControlImpl.java,v 1.9 2001/05/29 18:36:13 ashuk%eng.sun.com Exp $");
        try {
            BrowserControlFactory.setAppData(stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            WindowControl windowControl = (WindowControl)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(windowControl != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }
}

