/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.util.Hashtable;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BookmarkEntry;
import org.mozilla.webclient.Bookmarks;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.BookmarkEntryImpl;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;

public class BookmarksImpl
extends ImplObjectNative
implements Bookmarks {
    private static final String NC_NS = "http://home.netscape.com/NC-rdf#";
    private TreeModel bookmarksTree = null;

    public BookmarksImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
    }

    public void delete() {
        this.bookmarksTree = null;
    }

    public void addBookmark(BookmarkEntry bookmarkEntry, BookmarkEntry bookmarkEntry2) {
        ParameterCheck.nonNull(bookmarkEntry2);
        this.myFactory.throwExceptionIfNotInitialized();
        if (!(bookmarkEntry2 instanceof BookmarkEntryImpl)) {
            throw new IllegalArgumentException("Can't add bookmark unless BookmarkEntry obtained from Bookmarks.newBookmarkEntry()");
        }
        BookmarkEntry bookmarkEntry3 = null;
        this.getBookmarks();
        if (null == bookmarkEntry) {
            bookmarkEntry3 = (BookmarkEntry)this.bookmarksTree.getRoot();
        } else {
            if (!(bookmarkEntry instanceof BookmarkEntryImpl)) {
                throw new IllegalArgumentException("Can't add bookmark unless BookmarkEntry obtained from Bookmarks.newBookmarkEntry()");
            }
            bookmarkEntry3 = bookmarkEntry;
        }
        if (!bookmarkEntry3.isFolder()) {
            throw new IllegalArgumentException("Can't add bookmark unless parent BookmarkEntry is a folder");
        }
        int n = bookmarkEntry3.getChildCount();
        bookmarkEntry3.insert(bookmarkEntry2, n);
    }

    public TreeModel getBookmarks() throws IllegalStateException {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        if (null == this.bookmarksTree) {
            int n = this.nativeGetBookmarks(this.nativeWebShell);
            if (-1 == n) {
                throw new IllegalStateException("BookmarksImpl.getBookmarks(): Can't get bookmarks from native browser.");
            }
            BookmarkEntryImpl bookmarkEntryImpl = new BookmarkEntryImpl(this.nativeWebShell, n, null);
            if (null == bookmarkEntryImpl || null == (this.bookmarksTree = new DefaultTreeModel(bookmarkEntryImpl))) {
                throw new IllegalStateException("BookmarksImpl.getBookmarks(): Can't create RDFTreeModel.");
            }
        }
        return this.bookmarksTree;
    }

    public void removeBookmark(BookmarkEntry bookmarkEntry) {
        ParameterCheck.nonNull(bookmarkEntry);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        throw new UnimplementedException("\nUnimplementedException -----\n API Function CurrentPage::getPageInfo has not yet been implemented.\n");
    }

    public BookmarkEntry newBookmarkEntry(String string) {
        BookmarkEntryImpl bookmarkEntryImpl = null;
        this.getBookmarks();
        int n = this.nativeNewRDFNode(this.nativeWebShell, string, false);
        if (-1 != n) {
            bookmarkEntryImpl = new BookmarkEntryImpl(this.nativeWebShell, n, null);
            ((Hashtable)bookmarkEntryImpl.getProperties()).put("Name", string);
            ((Hashtable)bookmarkEntryImpl.getProperties()).put("URL", string);
        }
        return bookmarkEntryImpl;
    }

    public BookmarkEntry newBookmarkFolder(String string) {
        ParameterCheck.nonNull(string);
        BookmarkEntryImpl bookmarkEntryImpl = null;
        this.getBookmarks();
        bookmarkEntryImpl = new BookmarkEntryImpl(this.nativeWebShell, -1, null);
        if (null == bookmarkEntryImpl) {
            throw new NullPointerException("Can't create bookmark folder for: " + string);
        }
        ((Hashtable)bookmarkEntryImpl.getProperties()).put("Name", string);
        ((Hashtable)bookmarkEntryImpl.getProperties()).put("URL", "http://home.netscape.com/NC-rdf#$" + string);
        ((Hashtable)bookmarkEntryImpl.getProperties()).put("IsFolder", string);
        return bookmarkEntryImpl;
    }

    private native int nativeGetBookmarks(int var1);

    private native int nativeNewRDFNode(int var1, String var2, boolean var3);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("BookmarksImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: BookmarksImpl.java,v 1.9 2001/05/29 18:36:04 ashuk%eng.sun.com Exp $");
        try {
            BrowserControlFactory.setAppData(stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            Bookmarks bookmarks = (Bookmarks)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(bookmarks != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }
}

