/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.LogStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;
import sun.rmi.transport.tcp.MultiplexInputStream;
import sun.rmi.transport.tcp.MultiplexOutputStream;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.security.action.GetPropertyAction;

final class ConnectionMultiplexer {
    static int logLevel = LogStream.parseLevel(ConnectionMultiplexer.getLogLevel());
    private static final int OPEN = 225;
    private static final int CLOSE = 226;
    private static final int CLOSEACK = 227;
    private static final int REQUEST = 228;
    private static final int TRANSMIT = 229;
    private TCPChannel channel;
    private InputStream in;
    private OutputStream out;
    private boolean orig;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private Hashtable connectionTable = new Hashtable(7);
    private int numConnections = 0;
    private static final int maxConnections = 256;
    private int lastID = 4097;
    private boolean alive = true;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.multiplex.logLevel"));
    }

    public ConnectionMultiplexer(TCPChannel tCPChannel, InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.channel = tCPChannel;
        this.in = inputStream;
        this.out = outputStream;
        this.orig = bl;
        this.dataIn = new DataInputStream(inputStream);
        this.dataOut = new DataOutputStream(outputStream);
    }

    public void run() throws IOException {
        try {
            int n;
            block18: while (true) {
                n = this.dataIn.readUnsignedByte();
                switch (n) {
                    case 225: {
                        Integer n2;
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n3 = this.dataIn.readUnsignedShort();
                        if (logLevel >= 20) {
                            LogStream.log("multiplex").println("ConnectionMultiplexer.run: operation  OPEN " + n3);
                        }
                        if ((multiplexConnectionInfo = (MultiplexConnectionInfo)this.connectionTable.get(n2 = new Integer(n3))) != null) {
                            throw new IOException("OPEN: Connection ID already exists");
                        }
                        multiplexConnectionInfo = new MultiplexConnectionInfo(n3);
                        multiplexConnectionInfo.in = new MultiplexInputStream(this, multiplexConnectionInfo, 2048);
                        multiplexConnectionInfo.out = new MultiplexOutputStream(this, multiplexConnectionInfo, 2048);
                        Hashtable hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.put(n2, multiplexConnectionInfo);
                            ++this.numConnections;
                        }
                        TCPConnection tCPConnection = new TCPConnection(this.channel, multiplexConnectionInfo.in, multiplexConnectionInfo.out);
                        this.channel.acceptMultiplexConnection(tCPConnection);
                        continue block18;
                    }
                    case 226: {
                        Integer n2;
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n3 = this.dataIn.readUnsignedShort();
                        if (logLevel >= 20) {
                            LogStream.log("multiplex").println("ConnectionMultiplexer.run: operation  CLOSE " + n3);
                        }
                        if ((multiplexConnectionInfo = (MultiplexConnectionInfo)this.connectionTable.get(n2 = new Integer(n3))) == null) {
                            throw new IOException("CLOSE: Invalid connection ID");
                        }
                        multiplexConnectionInfo.in.disconnect();
                        multiplexConnectionInfo.out.disconnect();
                        if (!multiplexConnectionInfo.closed) {
                            this.sendCloseAck(multiplexConnectionInfo);
                        }
                        Hashtable hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(n2);
                            --this.numConnections;
                            continue block18;
                        }
                    }
                    case 227: {
                        Integer n2;
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n3 = this.dataIn.readUnsignedShort();
                        if (logLevel >= 20) {
                            LogStream.log("multiplex").println("ConnectionMultiplexer.run: operation  CLOSEACK " + n3);
                        }
                        if ((multiplexConnectionInfo = (MultiplexConnectionInfo)this.connectionTable.get(n2 = new Integer(n3))) == null) {
                            throw new IOException("CLOSEACK: Invalid connection ID");
                        }
                        if (!multiplexConnectionInfo.closed) {
                            throw new IOException("CLOSEACK: Connection not closed");
                        }
                        multiplexConnectionInfo.in.disconnect();
                        multiplexConnectionInfo.out.disconnect();
                        Hashtable hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(n2);
                            --this.numConnections;
                            continue block18;
                        }
                    }
                    case 228: {
                        int n3 = this.dataIn.readUnsignedShort();
                        Integer n2 = new Integer(n3);
                        MultiplexConnectionInfo multiplexConnectionInfo = (MultiplexConnectionInfo)this.connectionTable.get(n2);
                        if (multiplexConnectionInfo == null) {
                            throw new IOException("REQUEST: Invalid connection ID");
                        }
                        int n4 = this.dataIn.readInt();
                        if (logLevel >= 20) {
                            LogStream.log("multiplex").println("ConnectionMultiplexer.run: operation  REQUEST " + n3 + ": " + n4);
                        }
                        multiplexConnectionInfo.out.request(n4);
                        continue block18;
                    }
                    case 229: {
                        int n3 = this.dataIn.readUnsignedShort();
                        Integer n2 = new Integer(n3);
                        MultiplexConnectionInfo multiplexConnectionInfo = (MultiplexConnectionInfo)this.connectionTable.get(n2);
                        if (multiplexConnectionInfo == null) {
                            throw new IOException("SEND: Invalid connection ID");
                        }
                        int n4 = this.dataIn.readInt();
                        if (logLevel >= 20) {
                            LogStream.log("multiplex").println("ConnectionMultiplexer.run: operation  TRANSMIT " + n3 + ": " + n4);
                        }
                        multiplexConnectionInfo.in.receive(n4, this.dataIn);
                        continue block18;
                    }
                }
                break;
            }
            throw new IOException("Invalid operation: " + Integer.toHexString(n));
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.shutDown();
            throw throwable;
        }
    }

    public synchronized TCPConnection openConnection() throws IOException {
        int n;
        Integer n2;
        do {
            ++this.lastID;
            this.lastID &= Short.MAX_VALUE;
            n = this.lastID;
            if (!this.orig) continue;
            n |= 0x8000;
        } while (this.connectionTable.get(n2 = new Integer(n)) != null);
        MultiplexConnectionInfo multiplexConnectionInfo = new MultiplexConnectionInfo(n);
        multiplexConnectionInfo.in = new MultiplexInputStream(this, multiplexConnectionInfo, 2048);
        multiplexConnectionInfo.out = new MultiplexOutputStream(this, multiplexConnectionInfo, 2048);
        Hashtable hashtable = this.connectionTable;
        synchronized (hashtable) {
            if (!this.alive) {
                throw new IOException("Multiplexer connection dead");
            }
            if (this.numConnections >= 256) {
                throw new IOException("Cannot exceed 256 simultaneous multiplexed connections");
            }
            this.connectionTable.put(n2, multiplexConnectionInfo);
            ++this.numConnections;
        }
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            try {
                this.dataOut.writeByte(225);
                this.dataOut.writeShort(n);
                this.dataOut.flush();
            }
            catch (IOException iOException) {
                if (logLevel >= 10) {
                    LogStream logStream;
                    LogStream logStream2 = logStream = LogStream.log("multiplex");
                    synchronized (logStream2) {
                        logStream.println("ConnectionMultiplexer.openConnection: exception: ");
                        iOException.printStackTrace(logStream);
                    }
                }
                this.shutDown();
                throw iOException;
            }
        }
        return new TCPConnection(this.channel, multiplexConnectionInfo.in, multiplexConnectionInfo.out);
    }

    public void shutDown() {
        Hashtable hashtable = this.connectionTable;
        synchronized (hashtable) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            Enumeration enumeration = this.connectionTable.elements();
            while (enumeration.hasMoreElements()) {
                MultiplexConnectionInfo multiplexConnectionInfo = (MultiplexConnectionInfo)enumeration.nextElement();
                multiplexConnectionInfo.in.disconnect();
                multiplexConnectionInfo.out.disconnect();
            }
            this.connectionTable.clear();
            this.numConnections = 0;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void sendRequest(MultiplexConnectionInfo multiplexConnectionInfo, int n) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(228);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.writeInt(n);
                    this.dataOut.flush();
                }
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream;
                        LogStream logStream2 = logStream = LogStream.log("multiplex");
                        synchronized (logStream2) {
                            logStream.println("ConnectionMultiplexer.sendRequest: exception: ");
                            iOException.printStackTrace(logStream);
                        }
                    }
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    void sendTransmit(MultiplexConnectionInfo multiplexConnectionInfo, byte[] byArray, int n, int n2) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(229);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.writeInt(n2);
                    this.dataOut.write(byArray, n, n2);
                    this.dataOut.flush();
                }
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream;
                        LogStream logStream2 = logStream = LogStream.log("multiplex");
                        synchronized (logStream2) {
                            logStream.println("ConnectionMultiplexer.sendTransmit: exception: ");
                            iOException.printStackTrace(logStream);
                        }
                    }
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    void sendClose(MultiplexConnectionInfo multiplexConnectionInfo) throws IOException {
        multiplexConnectionInfo.out.disconnect();
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(226);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.flush();
                    multiplexConnectionInfo.closed = true;
                }
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream;
                        LogStream logStream2 = logStream = LogStream.log("multiplex");
                        synchronized (logStream2) {
                            logStream.println("ConnectionMultiplexer.sendClose: exception: ");
                            iOException.printStackTrace(logStream);
                        }
                    }
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    void sendCloseAck(MultiplexConnectionInfo multiplexConnectionInfo) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(227);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.flush();
                    multiplexConnectionInfo.closed = true;
                }
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream;
                        LogStream logStream2 = logStream = LogStream.log("multiplex");
                        synchronized (logStream2) {
                            logStream.println("ConnectionMultiplexer.sendCloseAck: exception: ");
                            iOException.printStackTrace(logStream);
                        }
                    }
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutDown();
    }
}

