/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.spi.InputMethodDescriptor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import sun.awt.SunToolkit;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.misc.Service;

class ExecutableInputMethodManager
extends InputMethodManager
implements Runnable,
ActionListener {
    private InputContext currentInputContext;
    private String triggerMenuString;
    private PopupMenu selectionMenu;
    private static String selectInputMethodMenuTitle;
    private InputMethodLocator hostAdapterLocator;
    private String hostAdapterLabel;
    private String hostAdapterCommand;
    private int javaInputMethodCount;
    private Vector javaInputMethodLocatorList;
    private Component requestComponent;
    private InputContext requestInputContext;
    private Hashtable preferredInputMethods;

    ExecutableInputMethodManager() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            InputMethodDescriptor inputMethodDescriptor = ((SunToolkit)toolkit).getInputMethodAdapterDescriptor();
            if (inputMethodDescriptor != null) {
                this.hostAdapterLocator = new InputMethodLocator(inputMethodDescriptor, null, null);
                this.hostAdapterLabel = inputMethodDescriptor.getInputMethodDisplayName(null, Locale.getDefault());
                this.hostAdapterCommand = this.hostAdapterLocator.getActionCommandString();
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.javaInputMethodLocatorList = new Vector();
        this.initializeInputMethodLocatorList();
    }

    synchronized void initialize() {
        this.triggerMenuString = selectInputMethodMenuTitle = Toolkit.getProperty("AWT.InputMethodSelectionMenu", "Select Input Method");
    }

    public void run() {
        while (!this.hasMultipleInputMethods()) {
            try {
                ExecutableInputMethodManager executableInputMethodManager = this;
                synchronized (executableInputMethodManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.selectionMenu = new PopupMenu(selectInputMethodMenuTitle);
        while (true) {
            this.waitForChangeRequest();
            this.initializeInputMethodLocatorList();
            this.showInputMethodMenu();
        }
    }

    void setInputContext(InputContext inputContext) {
        if (this.currentInputContext == null || inputContext != null) {
            // empty if block
        }
        this.currentInputContext = inputContext;
    }

    public synchronized void notifyChangeRequest(Component component) {
        if (!(component instanceof Frame) && !(component instanceof Dialog)) {
            return;
        }
        if (this.requestComponent != null) {
            return;
        }
        this.requestComponent = component;
        this.notify();
    }

    public synchronized void notifyChangeRequestByHotKey(Component component) {
        while (!(component instanceof Frame) && !(component instanceof Dialog)) {
            if (component == null) {
                return;
            }
            component = component.getParent();
        }
        this.notifyChangeRequest(component);
    }

    public String getTriggerMenuString() {
        return this.triggerMenuString;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.changeInputMethod(string);
    }

    boolean hasMultipleInputMethods() {
        return this.hostAdapterLocator != null && this.javaInputMethodCount > 0 || this.javaInputMethodCount > 1;
    }

    private synchronized void waitForChangeRequest() {
        try {
            while (this.requestComponent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeInputMethodLocatorList() {
        Vector vector = this.javaInputMethodLocatorList;
        synchronized (vector) {
            this.javaInputMethodLocatorList.clear();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){
                    static /* synthetic */ Class class$java$awt$im$spi$InputMethodDescriptor;

                    public Object run() {
                        Iterator iterator = Service.installedProviders(class$java$awt$im$spi$InputMethodDescriptor == null ? (class$java$awt$im$spi$InputMethodDescriptor = 1.class$("java.awt.im.spi.InputMethodDescriptor")) : class$java$awt$im$spi$InputMethodDescriptor);
                        while (iterator.hasNext()) {
                            InputMethodDescriptor inputMethodDescriptor = (InputMethodDescriptor)iterator.next();
                            ClassLoader classLoader = inputMethodDescriptor.getClass().getClassLoader();
                            ExecutableInputMethodManager.this.javaInputMethodLocatorList.add(new InputMethodLocator(inputMethodDescriptor, classLoader, null));
                        }
                        return null;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            this.javaInputMethodCount = this.javaInputMethodLocatorList.size();
        }
        if (!this.hasMultipleInputMethods()) {
            this.triggerMenuString = null;
        }
    }

    private void showInputMethodMenu() {
        Object object;
        if (!this.hasMultipleInputMethods()) {
            this.requestComponent = null;
            return;
        }
        this.selectionMenu.removeAll();
        String string = this.getCurrentSelection();
        if (this.hostAdapterLabel != null) {
            this.addMenuItem(this.selectionMenu, this.hostAdapterLabel, this.hostAdapterCommand, string);
            this.selectionMenu.addSeparator();
        }
        int n = 0;
        while (n < this.javaInputMethodLocatorList.size()) {
            int n2;
            object = (InputMethodLocator)this.javaInputMethodLocatorList.get(n);
            InputMethodDescriptor inputMethodDescriptor = ((InputMethodLocator)object).getDescriptor();
            String string2 = inputMethodDescriptor.getInputMethodDisplayName(null, Locale.getDefault());
            String string3 = ((InputMethodLocator)object).getActionCommandString();
            Locale[] localeArray = null;
            try {
                localeArray = inputMethodDescriptor.getAvailableLocales();
                n2 = localeArray.length;
            }
            catch (AWTException aWTException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.addMenuItem(this.selectionMenu, string2, null, string);
            } else if (n2 == 1) {
                if (inputMethodDescriptor.hasDynamicLocaleList()) {
                    string2 = inputMethodDescriptor.getInputMethodDisplayName(localeArray[0], Locale.getDefault());
                    string3 = ((InputMethodLocator)object).deriveLocator(localeArray[0]).getActionCommandString();
                }
                this.addMenuItem(this.selectionMenu, string2, string3, string);
            } else {
                Menu menu = new Menu(string2);
                this.selectionMenu.add(menu);
                int n3 = 0;
                while (n3 < n2) {
                    Locale locale = localeArray[n3];
                    String string4 = this.getLocaleName(locale);
                    String string5 = ((InputMethodLocator)object).deriveLocator(locale).getActionCommandString();
                    this.addMenuItem(menu, string4, string5, string);
                    ++n3;
                }
            }
            ++n;
        }
        object = this;
        synchronized (object) {
            this.requestComponent.add(this.selectionMenu);
            this.requestInputContext = this.currentInputContext;
            this.selectionMenu.show(this.requestComponent, 60, 80);
            this.requestComponent = null;
        }
    }

    private String getCurrentSelection() {
        InputMethodLocator inputMethodLocator;
        InputContext inputContext = this.currentInputContext;
        if (inputContext != null && (inputMethodLocator = inputContext.getInputMethodLocator()) != null) {
            return inputMethodLocator.getActionCommandString();
        }
        return null;
    }

    private MenuItem addMenuItem(Menu menu, String string, String string2, String string3) {
        MenuItem menuItem = ExecutableInputMethodManager.isSelected(string2, string3) ? new CheckboxMenuItem(string, true) : new MenuItem(string);
        menuItem.setActionCommand(string2);
        menuItem.addActionListener(this);
        menuItem.setEnabled(string2 != null);
        menu.add(menuItem);
        return menuItem;
    }

    private static boolean isSelected(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        int n = string2.indexOf(10);
        return n != -1 && string2.substring(0, n).equals(string);
    }

    private String getLocaleName(Locale locale) {
        String string = locale.toString();
        String string2 = Toolkit.getProperty("AWT.InputMethodLanguage." + string, null);
        if (string2 == null && ((string2 = locale.getDisplayName()) == null || string2.length() == 0)) {
            string2 = string;
        }
        return string2;
    }

    private void changeInputMethod(String string) {
        Object object = null;
        if (this.hostAdapterCommand != null && this.hostAdapterCommand.equals(string)) {
            object = this.hostAdapterLocator;
        } else {
            String string2;
            Object object2;
            String string3 = string;
            String string4 = null;
            int n = string.indexOf(10);
            if (n != -1) {
                string4 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
            int n2 = 0;
            while (n2 < this.javaInputMethodLocatorList.size()) {
                object2 = (InputMethodLocator)this.javaInputMethodLocatorList.get(n2);
                string2 = ((InputMethodLocator)object2).getActionCommandString();
                if (string2.equals(string3)) {
                    object = object2;
                    break;
                }
                ++n2;
            }
            if (object != null && string4 != null) {
                object2 = "";
                string2 = "";
                String string5 = "";
                int n3 = string4.indexOf(95);
                if (n3 == -1) {
                    object2 = string4;
                } else {
                    object2 = string4.substring(0, n3);
                    int n4 = n3 + 1;
                    if ((n3 = string4.indexOf(95, n4)) == -1) {
                        string2 = string4.substring(n4);
                    } else {
                        string2 = string4.substring(n4, n3);
                        string5 = string4.substring(n3 + 1);
                    }
                }
                Locale locale = new Locale((String)object2, string2, string5);
                object = ((InputMethodLocator)object).deriveLocator(locale);
                if (this.preferredInputMethods == null) {
                    this.preferredInputMethods = new Hashtable();
                }
                this.preferredInputMethods.put(string4, object);
            }
        }
        if (object == null) {
            return;
        }
        if (this.requestInputContext != null) {
            this.requestInputContext.changeInputMethod((InputMethodLocator)object);
            this.requestInputContext = null;
        }
    }

    InputMethodLocator findInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator;
        if (locale != null && this.preferredInputMethods != null) {
            String string = locale.toString();
            while (!string.equals("")) {
                inputMethodLocator = (InputMethodLocator)this.preferredInputMethods.get(string);
                if (inputMethodLocator != null) {
                    return inputMethodLocator;
                }
                int n = string.lastIndexOf(95);
                if (n == -1) break;
                string = string.substring(0, n);
            }
        }
        if (this.hostAdapterLocator != null && (locale == null || this.hostAdapterLocator.isLocaleAvailable(locale))) {
            return this.hostAdapterLocator.deriveLocator(locale);
        }
        this.initializeInputMethodLocatorList();
        int n = 0;
        while (n < this.javaInputMethodLocatorList.size()) {
            inputMethodLocator = (InputMethodLocator)this.javaInputMethodLocatorList.get(n);
            if (locale == null || inputMethodLocator.isLocaleAvailable(locale)) {
                return inputMethodLocator.deriveLocator(locale);
            }
            ++n;
        }
        return null;
    }
}

