/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Map;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TextAreaDocument;
import javax.swing.undo.UndoableEdit;

public class HTMLDocument
extends DefaultStyledDocument {
    private boolean frameDocument = false;
    private boolean preservesUnknownTags = true;
    private ButtonGroup radioButtonGroup;
    static final String TokenThreshold = "token threshold";
    public static final String AdditionalComments = "AdditionalComments";
    static final String StyleType = "StyleType";
    URL base;
    private HTMLEditorKit.Parser parser;
    private static AttributeSet contentAttributeSet;
    static String MAP_PROPERTY;
    private static char[] NEWLINE;

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        super(content, styleSheet);
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(n);
        return hTMLReader;
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return this.getReader(n, n2, n3, tag, true);
    }

    HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag, boolean bl) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(n, n2, n3, tag, bl, false, true);
        return hTMLReader;
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL uRL) {
        this.base = uRL;
        this.getStyleSheet().setBase(uRL);
    }

    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n, elementSpecArray);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (attributeSet == null) {
            attributeSet = contentAttributeSet;
        } else if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            ((MutableAttributeSet)attributeSet).addAttributes(contentAttributeSet);
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
        super.create(elementSpecArray);
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            int n3 = Math.min(n + n2, this.getLength());
            Element element = this.getParagraphElement(n);
            n = element.getStartOffset();
            element = this.getParagraphElement(n3);
            n2 = Math.max(0, element.getEndOffset() - n);
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n4 = Integer.MAX_VALUE;
            int n5 = n;
            while (n5 <= n3) {
                Element element2 = this.getParagraphElement(n5);
                n4 = n4 == element2.getEndOffset() ? ++n4 : element2.getEndOffset();
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element2, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n5 = n4;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var14_13 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    public Iterator getIterator(HTML.Tag tag) {
        if (tag.isBlock()) {
            return null;
        }
        return new LeafIterator(tag, this);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new RunElement(element, attributeSet, n, n2);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(element, attributeSet);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        BlockElement blockElement = new BlockElement(null, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        BlockElement blockElement2 = new BlockElement((Element)blockElement, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        BlockElement blockElement3 = new BlockElement((Element)blockElement2, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        RunElement runElement = new RunElement((Element)blockElement3, (AttributeSet)simpleAttributeSet, 0, 1);
        Element[] elementArray = new Element[]{runElement};
        blockElement3.replace(0, 0, elementArray);
        elementArray[0] = blockElement3;
        blockElement2.replace(0, 0, elementArray);
        elementArray[0] = blockElement2;
        blockElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return blockElement;
    }

    public void setTokenThreshold(int n) {
        this.putProperty(TokenThreshold, new Integer(n));
    }

    public int getTokenThreshold() {
        Integer n = (Integer)this.getProperty(TokenThreshold);
        if (n != null) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
        String string = hTMLFrameHyperlinkEvent.getTarget();
        Element element = hTMLFrameHyperlinkEvent.getSourceElement();
        String string2 = hTMLFrameHyperlinkEvent.getURL().toString();
        if (string.equals("_self")) {
            this.updateFrame(element, string2);
        } else if (string.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), string2);
        } else {
            Element element2 = this.findFrame(string);
            if (element2 != null) {
                this.updateFrame(element2, string2);
            }
        }
    }

    private Element findFrame(String string) {
        ElementIterator elementIterator = new ElementIterator(this);
        Element element = null;
        while ((element = elementIterator.next()) != null) {
            String string2;
            AttributeSet attributeSet = element.getAttributes();
            if (this.matchNameAttribute(attributeSet, HTML.Tag.FRAME) && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME)) != null && string2.equals(string)) break;
        }
        return element;
    }

    boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    private void updateFrameSet(Element element, String string) {
        try {
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            this.remove(n, n2 - n);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.FRAME);
            this.insertString(n, " ", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void updateFrame(Element element, String string) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes().copyAttributes();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet, false));
            mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
            mutableAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var7_6 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    void setFrameDocumentState(boolean bl) {
        this.frameDocument = bl;
    }

    void addMap(Map map) {
        String string = map.getName();
        if (string != null) {
            Object object = this.getProperty(MAP_PROPERTY);
            if (object == null) {
                object = new Hashtable(11);
                this.putProperty(MAP_PROPERTY, object);
            }
            if (object instanceof Hashtable) {
                ((Hashtable)object).put("#" + string, map);
            }
        }
    }

    void removeMap(Map map) {
        Object object;
        String string = map.getName();
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) instanceof Hashtable) {
            ((Hashtable)object).remove("#" + string);
        }
    }

    Map getMap(String string) {
        Object object;
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) != null && object instanceof Hashtable) {
            return (Map)((Hashtable)object).get(string);
        }
        return null;
    }

    Enumeration getMaps() {
        Object object = this.getProperty(MAP_PROPERTY);
        if (object instanceof Hashtable) {
            return ((Hashtable)object).elements();
        }
        return null;
    }

    void setDefaultStyleSheetType(String string) {
        this.putProperty(StyleType, string);
    }

    String getDefaultStyleSheetType() {
        String string = (String)this.getProperty(StyleType);
        if (string == null) {
            return "text/css";
        }
        return string;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
        this.putProperty("__PARSER__", null);
    }

    public HTMLEditorKit.Parser getParser() {
        Object object = this.getProperty("__PARSER__");
        if (object instanceof HTMLEditorKit.Parser) {
            return (HTMLEditorKit.Parser)object;
        }
        return this.parser;
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML of a leaf");
        }
        if (element != null && string != null) {
            int n = element.getElementCount();
            int n2 = element.getStartOffset();
            this.insertHTML(element, element.getStartOffset(), string, true);
            if (element.getElementCount() > n) {
                this.removeElements(element, element.getElementCount() - n, n);
            }
        }
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.getParentElement() != null && string != null) {
            boolean bl;
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = this.getLength();
            boolean bl2 = bl = !element.isLeaf();
            if (!(bl || n2 <= n3 && this.getText(n2 - 1, 1).charAt(0) != NEWLINE[0])) {
                bl = true;
            }
            Element element2 = element.getParentElement();
            int n4 = element2.getElementCount();
            this.insertHTML(element2, n, string, bl);
            int n5 = this.getLength();
            if (n4 != element2.getElementCount()) {
                int n6 = element2.getElementIndex(n + n5 - n3);
                this.removeElements(element2, n6, 1);
            }
        }
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not insert HTML after start of a leaf");
        }
        this.insertHTML(element, element.getStartOffset(), string, false);
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML before end of leaf");
        }
        int n = element.getEndOffset();
        if (element.getElement(element.getElementIndex(n - 1)).isLeaf() && this.getText(n - 1, 1).charAt(0) == NEWLINE[0]) {
            --n;
        }
        this.insertHTML(element, n, string, false);
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            this.insertHTML(element2, element.getStartOffset(), string, false);
        }
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            int n = element.getEndOffset();
            if (element.isLeaf() && this.getText(n - 1, 1).charAt(0) == NEWLINE[0]) {
                --n;
            }
            this.insertHTML(element2, n, string, false);
        }
    }

    public Element getElement(String string) {
        if (string == null) {
            return null;
        }
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, string, true);
    }

    public Element getElement(Element element, Object object, Object object2) {
        return this.getElement(element, object, object2, false);
    }

    private Element getElement(Element element, Object object, Object object2, boolean bl) {
        block5: {
            Enumeration enumeration;
            AttributeSet attributeSet;
            block4: {
                attributeSet = element.getAttributes();
                if (attributeSet != null && attributeSet.isDefined(object) && object2.equals(attributeSet.getAttribute(object))) {
                    return element;
                }
                if (element.isLeaf()) break block4;
                int n = 0;
                int n2 = element.getElementCount();
                while (n < n2) {
                    Element element2 = this.getElement(element.getElement(n), object, object2, bl);
                    if (element2 != null) {
                        return element2;
                    }
                    ++n;
                }
                break block5;
            }
            if (!bl || attributeSet == null || (enumeration = attributeSet.getAttributeNames()) == null) break block5;
            while (enumeration.hasMoreElements()) {
                AttributeSet attributeSet2;
                Object object3 = enumeration.nextElement();
                if (!(object3 instanceof HTML.Tag) || !(attributeSet.getAttribute(object3) instanceof AttributeSet) || !(attributeSet2 = (AttributeSet)attributeSet.getAttribute(object3)).isDefined(object) || !object2.equals(attributeSet2.getAttribute(object))) continue;
                return element;
            }
        }
        return null;
    }

    private void verifyParser() {
        if (this.getParser() == null) {
            throw new IllegalStateException("No HTMLEditorKit.Parser");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertHTML(Element var1_1, int var2_2, String var3_3, boolean var4_4) throws BadLocationException, IOException {
        block3: {
            if (var1_1 == null || var3_3 == null || (var5_5 = this.getParser()) == null) break block3;
            var6_6 = Math.max(0, var2_2 - 1);
            var7_7 = this.getCharacterElement(var6_6);
            var8_8 = var1_1;
            var9_9 = 0;
            var10_10 = 0;
            if (var1_1.getStartOffset() <= var6_6) ** GOTO lbl16
            while (var8_8 != null && var8_8.getStartOffset() > var6_6) {
                var8_8 = var8_8.getParentElement();
                ++var10_10;
            }
            if (var8_8 != null) ** GOTO lbl16
            throw new BadLocationException("No common parent", var2_2);
lbl-1000:
            // 1 sources

            {
                ++var9_9;
                var7_7 = var7_7.getParentElement();
lbl16:
                // 3 sources

                ** while (var7_7 != null && var7_7 != var8_8)
            }
lbl17:
            // 1 sources

            if (var7_7 != null) {
                var11_11 = new HTMLReader(var2_2, var9_9 - 1, var10_10, null, false, true, var4_4);
                var5_5.parse(new StringReader(var3_3), var11_11, true);
                var11_11.flush();
            }
        }
    }

    private void removeElements(Element element, int n, int n2) throws BadLocationException {
        this.writeLock();
        try {
            int n3 = element.getElement(n).getStartOffset();
            int n4 = element.getElement(n + n2 - 1).getEndOffset();
            if (n4 > this.getLength()) {
                this.removeElementsAtEnd(element, n, n2, n3, n4);
            } else {
                this.removeElements(element, n, n2, n3, n4);
            }
            Object var7_6 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    private void removeElementsAtEnd(Element element, int n, int n2, int n3, int n4) throws BadLocationException {
        UndoableEdit undoableEdit;
        Element[] elementArray = new Element[]{};
        boolean bl = element.getElement(n - 1).isLeaf();
        if (bl) {
            --n;
        }
        Element[] elementArray2 = new Element[n2];
        int n5 = 0;
        while (n5 < n2) {
            elementArray2[n5] = element.getElement(n5 + n);
            ++n5;
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n3 - 1, n4 - n3 + 1, DocumentEvent.EventType.REMOVE);
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n, elementArray2, elementArray));
        ((AbstractDocument.BranchElement)element).replace(n, elementArray2.length, elementArray);
        if (bl) {
            undoableEdit = this.getContent().remove(n3 - 1, n4 - n3);
        } else {
            Element element2 = element.getElement(n - 1);
            while (!element2.isLeaf()) {
                element2 = element2.getElement(element2.getElementCount() - 1);
            }
            Element[] elementArray3 = new Element[1];
            Element[] elementArray4 = new Element[1];
            elementArray3[0] = element2;
            AttributeSet attributeSet = element2.getAttributes();
            element2 = element2.getParentElement();
            undoableEdit = this.getContent().remove(n3 - 1, n4 - n3);
            elementArray4[0] = this.createLeafElement(element2, attributeSet, n3 - 1, n3);
            ((AbstractDocument.BranchElement)element2).replace(element2.getElementCount() - 1, 1, elementArray4);
            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element2, element2.getElementCount() - 1, elementArray3, elementArray4));
        }
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    private void removeElements(Element element, int n, int n2, int n3, int n4) throws BadLocationException {
        Element[] elementArray = new Element[n2];
        Element[] elementArray2 = new Element[]{};
        int n5 = 0;
        while (n5 < n2) {
            elementArray[n5] = element.getElement(n5 + n);
            ++n5;
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n3, n4 - n3, DocumentEvent.EventType.REMOVE);
        ((AbstractDocument.BranchElement)element).replace(n, elementArray.length, elementArray2);
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n, elementArray, elementArray2));
        UndoableEdit undoableEdit = this.getContent().remove(n3, n4 - n3);
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    void obtainLock() {
        this.writeLock();
    }

    void releaseLock() {
        this.writeUnlock();
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        super.fireUndoableEditUpdate(undoableEditEvent);
    }

    AttributeSet getFormAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            HTML.Tag tag;
            Object object2 = enumeration.nextElement();
            if (!(object2 instanceof HTML.Tag) || (tag = (HTML.Tag)object2) != HTML.Tag.FORM || (object = attributeSet.getAttribute(tag)) == null || !(object instanceof AttributeSet)) continue;
            return (AttributeSet)object;
        }
        return null;
    }

    private boolean formMatchesSubmissionRequest(AttributeSet attributeSet, AttributeSet attributeSet2) {
        AttributeSet attributeSet3 = this.getFormAttributes(attributeSet);
        if (attributeSet3 != null) {
            return attributeSet2.isEqual(attributeSet3);
        }
        return false;
    }

    void getFormData(StringBuffer stringBuffer, Element element) {
        Element element2;
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = this.getFormAttributes(attributeSet);
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        if (attributeSet2 == null) {
            return;
        }
        boolean bl = false;
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet3 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet3, attributeSet2)) {
                bl = true;
                String string = (String)attributeSet3.getAttribute(HTML.Attribute.TYPE);
                if (string != null && string.equals("submit") && element2 != element || string != null && string.equals("image")) continue;
                this.loadElementDataIntoBuffer(element2, stringBuffer);
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
    }

    private void loadElementDataIntoBuffer(Element element, StringBuffer stringBuffer) {
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        String string2 = null;
        HTML.Tag tag = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            string2 = this.getInputElementData(attributeSet);
        } else if (tag == HTML.Tag.TEXTAREA) {
            string2 = this.getTextAreaData(attributeSet);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attributeSet, stringBuffer);
        }
        if (string != null && string2 != null) {
            this.appendBuffer(stringBuffer, string, string2);
        }
    }

    private String getInputElementData(AttributeSet attributeSet) {
        ButtonModel buttonModel;
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        String string2 = null;
        if (string.equals("text") || string.equals("password")) {
            Document document = (Document)object;
            try {
                string2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                string2 = null;
            }
        } else if (string.equals("submit") || string.equals("hidden")) {
            string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string2 == null) {
                string2 = "";
            }
        } else if ((string.equals("radio") || string.equals("checkbox")) && (buttonModel = (ButtonModel)object).isSelected() && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) == null) {
            string2 = "on";
        }
        return string2;
    }

    private String getTextAreaData(AttributeSet attributeSet) {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void loadSelectData(AttributeSet attributeSet, StringBuffer stringBuffer) {
        ComboBoxModel comboBoxModel;
        Option option;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n = 0;
            while (n < optionListModel.getSize()) {
                if (optionListModel.isSelectedIndex(n)) {
                    Option option2 = (Option)optionListModel.getElementAt(n);
                    this.appendBuffer(stringBuffer, string, option2.getValue());
                }
                ++n;
            }
        } else if (object instanceof ComboBoxModel && (option = (Option)(comboBoxModel = (ComboBoxModel)object).getSelectedItem()) != null) {
            this.appendBuffer(stringBuffer, string, option.getValue());
        }
    }

    private void appendBuffer(StringBuffer stringBuffer, String string, String string2) {
        this.ampersand(stringBuffer);
        String string3 = URLEncoder.encode(string);
        stringBuffer.append(string3);
        stringBuffer.append('=');
        String string4 = URLEncoder.encode(string2);
        stringBuffer.append(string4);
    }

    private void ampersand(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
    }

    boolean isLastTextOrPasswordField(Element element) {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        boolean bl = false;
        AttributeSet attributeSet = this.getFormAttributes(element.getAttributes());
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet2 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet2, attributeSet)) {
                String string;
                if (bl && this.matchNameAttribute(attributeSet2, HTML.Tag.INPUT) && ((string = (String)attributeSet2.getAttribute(HTML.Attribute.TYPE)).equals("text") || string.equals("password"))) {
                    return false;
                }
                if (element2 != element) continue;
                bl = true;
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
        return true;
    }

    void resetForm(Element element) {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        boolean bl = false;
        AttributeSet attributeSet = this.getFormAttributes(element.getAttributes());
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet2 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet2, attributeSet)) {
                Object object;
                Object object2 = attributeSet2.getAttribute(StyleConstants.ModelAttribute);
                if (object2 instanceof TextAreaDocument) {
                    TextAreaDocument textAreaDocument = (TextAreaDocument)object2;
                    textAreaDocument.reset();
                } else if (object2 instanceof PlainDocument) {
                    try {
                        PlainDocument plainDocument = (PlainDocument)object2;
                        plainDocument.remove(0, plainDocument.getLength());
                        if (this.matchNameAttribute(attributeSet2, HTML.Tag.INPUT) && (object = (String)attributeSet2.getAttribute(HTML.Attribute.VALUE)) != null) {
                            plainDocument.insertString(0, (String)object, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (object2 instanceof OptionListModel) {
                    OptionListModel optionListModel = (OptionListModel)object2;
                    int n = optionListModel.getSize();
                    int n2 = 0;
                    while (n2 < n) {
                        optionListModel.removeIndexInterval(n2, n2);
                        ++n2;
                    }
                    BitSet bitSet = optionListModel.getInitialSelection();
                    int n3 = 0;
                    while (n3 < bitSet.size()) {
                        if (bitSet.get(n3)) {
                            optionListModel.addSelectionInterval(n3, n3);
                        }
                        ++n3;
                    }
                } else if (object2 instanceof OptionComboBoxModel) {
                    OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object2;
                    object = optionComboBoxModel.getInitialSelection();
                    if (object != null) {
                        optionComboBoxModel.setSelectedItem(object);
                    }
                } else if (object2 instanceof JToggleButton.ToggleButtonModel) {
                    boolean bl2 = (String)attributeSet2.getAttribute(HTML.Attribute.CHECKED) != null;
                    object = (JToggleButton.ToggleButtonModel)object2;
                    ((JToggleButton.ToggleButtonModel)object).setSelected(bl2);
                }
                bl = true;
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
    }

    static {
        MAP_PROPERTY = "__MAP__";
        contentAttributeSet = new SimpleAttributeSet();
        ((MutableAttributeSet)contentAttributeSet).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        NEWLINE = new char[1];
        HTMLDocument.NEWLINE[0] = 10;
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet, n, n2);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private int flushCount;
        private boolean insertAfterImplied;
        private boolean wantsTrailingNewline;
        int threshold;
        int offset;
        boolean inParagraph = false;
        boolean impliedP = false;
        boolean inPre = false;
        boolean inTextArea = false;
        TextAreaDocument textAreaDocument = null;
        boolean inTitle = false;
        boolean lastWasNewline = true;
        boolean emptyAnchor;
        boolean midInsert;
        boolean inBody;
        HTML.Tag insertTag;
        boolean insertInsertTag;
        boolean foundInsertTag;
        int insertTagDepthDelta;
        int popDepth;
        int pushDepth;
        Map lastMap;
        boolean inStyle = false;
        String defaultStyle;
        Vector styles;
        boolean inHead = false;
        boolean isStyleCSS;
        boolean emptyDocument;
        AttributeSet styleAttributes;
        Option option;
        protected Vector parseBuffer = new Vector();
        protected MutableAttributeSet charAttr = new SimpleAttributeSet();
        Stack charAttrStack = new Stack();
        Hashtable tagMap;
        int inBlock = 0;

        public HTMLReader(int n) {
            this(n, 0, 0, null);
        }

        public HTMLReader(int n, int n2, int n3, HTML.Tag tag) {
            this(n, n2, n3, tag, true, false, true);
        }

        HTMLReader(int n, int n2, int n3, HTML.Tag tag, boolean bl, boolean bl2, boolean bl3) {
            this.emptyDocument = HTMLDocument.this.getLength() == 0;
            this.isStyleCSS = "text/css".equals(HTMLDocument.this.getDefaultStyleSheetType());
            this.offset = n;
            this.threshold = HTMLDocument.this.getTokenThreshold();
            this.tagMap = new Hashtable(57);
            TagAction tagAction = new TagAction();
            BlockAction blockAction = new BlockAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            CharacterAction characterAction = new CharacterAction();
            SpecialAction specialAction = new SpecialAction();
            FormAction formAction = new FormAction();
            HiddenAction hiddenAction = new HiddenAction();
            ConvertAction convertAction = new ConvertAction();
            this.tagMap.put(HTML.Tag.A, new AnchorAction());
            this.tagMap.put(HTML.Tag.ADDRESS, characterAction);
            this.tagMap.put(HTML.Tag.APPLET, hiddenAction);
            this.tagMap.put(HTML.Tag.AREA, new AreaAction());
            this.tagMap.put(HTML.Tag.B, convertAction);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction());
            this.tagMap.put(HTML.Tag.BASEFONT, characterAction);
            this.tagMap.put(HTML.Tag.BIG, characterAction);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagMap.put(HTML.Tag.BODY, blockAction);
            this.tagMap.put(HTML.Tag.BR, specialAction);
            this.tagMap.put(HTML.Tag.CAPTION, blockAction);
            this.tagMap.put(HTML.Tag.CENTER, blockAction);
            this.tagMap.put(HTML.Tag.CITE, characterAction);
            this.tagMap.put(HTML.Tag.CODE, characterAction);
            this.tagMap.put(HTML.Tag.DD, blockAction);
            this.tagMap.put(HTML.Tag.DFN, characterAction);
            this.tagMap.put(HTML.Tag.DIR, blockAction);
            this.tagMap.put(HTML.Tag.DIV, blockAction);
            this.tagMap.put(HTML.Tag.DL, blockAction);
            this.tagMap.put(HTML.Tag.DT, paragraphAction);
            this.tagMap.put(HTML.Tag.EM, characterAction);
            this.tagMap.put(HTML.Tag.FONT, convertAction);
            this.tagMap.put(HTML.Tag.FORM, characterAction);
            this.tagMap.put(HTML.Tag.FRAME, specialAction);
            this.tagMap.put(HTML.Tag.FRAMESET, blockAction);
            this.tagMap.put(HTML.Tag.H1, paragraphAction);
            this.tagMap.put(HTML.Tag.H2, paragraphAction);
            this.tagMap.put(HTML.Tag.H3, paragraphAction);
            this.tagMap.put(HTML.Tag.H4, paragraphAction);
            this.tagMap.put(HTML.Tag.H5, paragraphAction);
            this.tagMap.put(HTML.Tag.H6, paragraphAction);
            this.tagMap.put(HTML.Tag.HEAD, new HeadAction());
            this.tagMap.put(HTML.Tag.HR, specialAction);
            this.tagMap.put(HTML.Tag.HTML, blockAction);
            this.tagMap.put(HTML.Tag.I, convertAction);
            this.tagMap.put(HTML.Tag.IMG, specialAction);
            this.tagMap.put(HTML.Tag.INPUT, formAction);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(HTML.Tag.KBD, characterAction);
            this.tagMap.put(HTML.Tag.LI, blockAction);
            this.tagMap.put(HTML.Tag.LINK, new LinkAction());
            this.tagMap.put(HTML.Tag.MAP, new MapAction());
            this.tagMap.put(HTML.Tag.MENU, blockAction);
            this.tagMap.put(HTML.Tag.META, new MetaAction());
            this.tagMap.put(HTML.Tag.NOBR, characterAction);
            this.tagMap.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagMap.put(HTML.Tag.OBJECT, specialAction);
            this.tagMap.put(HTML.Tag.OL, blockAction);
            this.tagMap.put(HTML.Tag.OPTION, formAction);
            this.tagMap.put(HTML.Tag.P, paragraphAction);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(HTML.Tag.PRE, new PreAction());
            this.tagMap.put(HTML.Tag.SAMP, characterAction);
            this.tagMap.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagMap.put(HTML.Tag.SELECT, formAction);
            this.tagMap.put(HTML.Tag.SMALL, characterAction);
            this.tagMap.put(HTML.Tag.STRIKE, convertAction);
            this.tagMap.put(HTML.Tag.S, characterAction);
            this.tagMap.put(HTML.Tag.STRONG, characterAction);
            this.tagMap.put(HTML.Tag.STYLE, new StyleAction());
            this.tagMap.put(HTML.Tag.SUB, convertAction);
            this.tagMap.put(HTML.Tag.SUP, convertAction);
            this.tagMap.put(HTML.Tag.TABLE, blockAction);
            this.tagMap.put(HTML.Tag.TD, blockAction);
            this.tagMap.put(HTML.Tag.TEXTAREA, formAction);
            this.tagMap.put(HTML.Tag.TH, blockAction);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(HTML.Tag.TR, blockAction);
            this.tagMap.put(HTML.Tag.TT, characterAction);
            this.tagMap.put(HTML.Tag.U, convertAction);
            this.tagMap.put(HTML.Tag.UL, blockAction);
            this.tagMap.put(HTML.Tag.VAR, characterAction);
            HTMLDocument.this.putProperty(HTMLDocument.AdditionalComments, null);
            if (tag != null) {
                this.insertTag = tag;
                this.popDepth = n2;
                this.pushDepth = n3;
                this.insertInsertTag = bl;
                this.foundInsertTag = false;
            } else {
                this.foundInsertTag = true;
            }
            if (bl2) {
                this.popDepth = n2;
                this.pushDepth = n3;
                this.insertAfterImplied = true;
                this.foundInsertTag = false;
                this.midInsert = false;
                this.insertInsertTag = true;
                this.wantsTrailingNewline = bl3;
            } else {
                boolean bl4 = this.midInsert = !this.emptyDocument && tag == null;
                if (this.midInsert) {
                    this.generateEndsSpecsForMidInsert();
                }
            }
        }

        private void generateEndsSpecsForMidInsert() {
            int n = this.heightToElementWithName(HTML.Tag.BODY, Math.max(0, this.offset - 1));
            boolean bl = false;
            if (n == -1 && this.offset > 0 && (n = this.heightToElementWithName(HTML.Tag.BODY, this.offset)) != -1) {
                n = this.depthTo(this.offset - 1) - 1;
                bl = true;
            }
            if (n == -1) {
                throw new RuntimeException("Must insert new content into body element-");
            }
            if (n != -1) {
                Object object;
                try {
                    if (!bl && this.offset > 0 && !HTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        object = new SimpleAttributeSet();
                        ((SimpleAttributeSet)object).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec((AttributeSet)object, 3, NEWLINE, 0, 1);
                        this.parseBuffer.addElement(elementSpec);
                    }
                }
                catch (BadLocationException badLocationException) {}
                while (n-- > 0) {
                    this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                }
                if (bl) {
                    object = new DefaultStyledDocument.ElementSpec(null, 1);
                    ((DefaultStyledDocument.ElementSpec)object).setDirection((short)5);
                    this.parseBuffer.addElement(object);
                }
            }
        }

        private int depthTo(int n) {
            Element element = HTMLDocument.this.getDefaultRootElement();
            int n2 = 0;
            while (!element.isLeaf()) {
                ++n2;
                element = element.getElement(element.getElementIndex(n));
            }
            return n2;
        }

        private int heightToElementWithName(Object object, int n) {
            Element element = HTMLDocument.this.getCharacterElement(n).getParentElement();
            int n2 = 0;
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != object) {
                ++n2;
                element = element.getParentElement();
            }
            return element == null ? -1 : n2;
        }

        private void adjustEndElement() {
            int n = HTMLDocument.this.getLength();
            if (n == 0) {
                return;
            }
            HTMLDocument.this.obtainLock();
            try {
                block9: {
                    try {
                        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent;
                        Element[] elementArray = this.getPathTo(n - 1);
                        if (elementArray.length <= 1 || elementArray[1].getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY || elementArray[1].getEndOffset() != n) break block9;
                        String string = HTMLDocument.this.getText(n - 1, 1);
                        Element[] elementArray2 = new Element[]{};
                        Element[] elementArray3 = new Element[1];
                        int n2 = elementArray[0].getElementIndex(n);
                        elementArray3[0] = elementArray[0].getElement(n2);
                        ((AbstractDocument.BranchElement)elementArray[0]).replace(n2, 1, elementArray2);
                        AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(elementArray[0], n2, elementArray3, elementArray2);
                        if (!(elementArray.length != 3 || elementArray[2].getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.P && elementArray[2].getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED || string.equals("\n"))) {
                            n2 = elementArray[2].getElementIndex(n - 1);
                            AttributeSet attributeSet = elementArray[2].getElement(n2).getAttributes();
                            if (attributeSet.getAttributeCount() == 1 && attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                                elementArray2 = new Element[1];
                                elementArray3 = new Element[]{elementArray[2].getElement(n2)};
                                int n3 = elementArray3[0].getStartOffset();
                                elementArray2[0] = HTMLDocument.this.createLeafElement(elementArray[2], attributeSet, n3, n + 1);
                                ((AbstractDocument.BranchElement)elementArray[2]).replace(n2, 1, elementArray2);
                                defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n3, n - n3 + 1, DocumentEvent.EventType.CHANGE);
                                defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(elementArray[2], n2, elementArray3, elementArray2));
                            } else {
                                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                                simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                                elementArray2 = new Element[]{HTMLDocument.this.createLeafElement(elementArray[2], simpleAttributeSet, n, n + 1)};
                                ((AbstractDocument.BranchElement)elementArray[2]).replace(n2 + 1, 0, elementArray2);
                                defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, 1, DocumentEvent.EventType.CHANGE);
                                elementArray3 = new Element[]{};
                                defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(elementArray[2], n2 + 1, elementArray3, elementArray2));
                            }
                        } else {
                            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
                            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)HTMLDocument.this.createBranchElement(elementArray[1], simpleAttributeSet);
                            elementArray2 = new Element[]{branchElement};
                            elementArray3 = new Element[]{};
                            n2 = elementArray[1].getElementIndex(n - 1) + 1;
                            ((AbstractDocument.BranchElement)elementArray[1]).replace(n2, 0, elementArray2);
                            defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, 1, DocumentEvent.EventType.CHANGE);
                            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(elementArray[1], n2, elementArray3, elementArray2));
                            elementArray2 = new Element[1];
                            simpleAttributeSet = new SimpleAttributeSet();
                            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                            elementArray2[0] = HTMLDocument.this.createLeafElement(branchElement, simpleAttributeSet, n, n + 1);
                            branchElement.replace(0, 0, elementArray2);
                        }
                        defaultDocumentEvent.addEdit(elementEdit);
                        defaultDocumentEvent.end();
                        HTMLDocument.this.fireChangedUpdate(defaultDocumentEvent);
                        HTMLDocument.this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    }
                    catch (BadLocationException badLocationException) {
                        Object var12_16 = null;
                        HTMLDocument.this.releaseLock();
                    }
                }
                Object var12_15 = null;
                HTMLDocument.this.releaseLock();
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                HTMLDocument.this.releaseLock();
                throw throwable;
            }
        }

        private Element[] getPathTo(int n) {
            Stack stack = new Stack();
            Element element = HTMLDocument.this.getDefaultRootElement();
            while (!element.isLeaf()) {
                stack.push(element);
                element = element.getElement(element.getElementIndex(n));
            }
            Object[] objectArray = new Element[stack.size()];
            stack.copyInto(objectArray);
            return objectArray;
        }

        public void flush() throws BadLocationException {
            this.flushBuffer(true);
            if (this.emptyDocument && !this.insertAfterImplied) {
                this.adjustEndElement();
            }
        }

        public void handleText(char[] cArray, int n) {
            if (this.midInsert && !this.inBody) {
                return;
            }
            if (this.inTextArea) {
                this.textAreaContent(cArray);
            } else if (this.inPre) {
                this.preContent(cArray);
            } else if (this.inTitle) {
                HTMLDocument.this.putProperty("title", new String(cArray));
            } else if (this.option != null) {
                this.option.setLabel(new String(cArray));
            } else if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (this.inBlock > 0) {
                if (!this.foundInsertTag && this.insertAfterImplied) {
                    this.foundInsertTag(false);
                    this.foundInsertTag = true;
                    this.impliedP = true;
                    this.inParagraph = true;
                }
                if (cArray.length >= 1) {
                    this.addContent(cArray, 0, cArray.length);
                }
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            Object object;
            if (this.midInsert && !this.inBody) {
                if (tag == HTML.Tag.BODY) {
                    this.inBody = true;
                    ++this.inBlock;
                }
                return;
            }
            if (!this.inBody && tag == HTML.Tag.BODY) {
                this.inBody = true;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = HTMLDocument.this.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = (TagAction)this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
            }
        }

        public void handleComment(char[] cArray, int n) {
            if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (HTMLDocument.this.getPreservesUnknownTags()) {
                if (this.inBlock == 0) {
                    Object object = HTMLDocument.this.getProperty(HTMLDocument.AdditionalComments);
                    if (object != null && !(object instanceof Vector)) {
                        return;
                    }
                    if (object == null) {
                        object = new Vector();
                        HTMLDocument.this.putProperty(HTMLDocument.AdditionalComments, object);
                    }
                    ((Vector)object).addElement(new String(cArray));
                    return;
                }
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, new String(cArray));
                this.addSpecialElement(HTML.Tag.COMMENT, simpleAttributeSet);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            TagAction tagAction;
            if (this.midInsert && !this.inBody) {
                return;
            }
            if (tag == HTML.Tag.BODY) {
                this.inBody = false;
                if (this.midInsert) {
                    --this.inBlock;
                }
            }
            if ((tagAction = (TagAction)this.tagMap.get(tag)) != null) {
                tagAction.end(tag);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            Object object;
            if (this.midInsert && !this.inBody) {
                return;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = HTMLDocument.this.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = (TagAction)this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
                ((TagAction)object).end(tag);
            } else if (HTMLDocument.this.getPreservesUnknownTags()) {
                this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public void handleEndOfLineString(String string) {
            if (this.emptyDocument && string != null) {
                HTMLDocument.this.putProperty("__EndOfLine__", string);
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagMap.put(tag, tagAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.empty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
                this.charAttrStack.pop();
            }
        }

        protected void textAreaContent(char[] cArray) {
            try {
                this.textAreaDocument.insertString(this.textAreaDocument.getLength(), new String(cArray), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected void preContent(char[] cArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '\n') {
                    this.addContent(cArray, n, n2 - n + 1);
                    this.blockClose(HTML.Tag.IMPLIED);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                    n = n2 + 1;
                }
                ++n2;
            }
            if (n < cArray.length) {
                this.addContent(cArray, n, cArray.length - n);
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
            }
            this.lastWasNewline = false;
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 1);
            this.parseBuffer.addElement(elementSpec);
        }

        protected void blockClose(HTML.Tag tag) {
            Object object;
            DefaultStyledDocument.ElementSpec elementSpec;
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                this.addContent(NEWLINE, 0, 1, false);
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                this.blockClose(HTML.Tag.IMPLIED);
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = elementSpec = this.parseBuffer.size() > 0 ? (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement() : null;
            if (elementSpec != null && elementSpec.getType() == 1) {
                object = new char[1];
                object[0] = 32;
                this.addContent((char[])object, 0, 1);
            }
            object = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(object);
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            if (!this.foundInsertTag) {
                return;
            }
            if (bl && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            this.charAttr.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            AttributeSet attributeSet = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.parseBuffer.addElement(elementSpec);
            if (this.parseBuffer.size() > this.threshold) {
                try {
                    this.flushBuffer(false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (n2 > 0) {
                this.lastWasNewline = cArray[n + n2 - 1] == '\n';
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag != HTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
            }
            this.emptyAnchor = false;
            mutableAttributeSet.addAttributes(this.charAttr);
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            char[] cArray = new char[]{' '};
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 3, cArray, 0, 1);
            this.parseBuffer.addElement(elementSpec);
            if (tag == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        void flushBuffer(boolean bl) throws BadLocationException {
            int n = HTMLDocument.this.getLength();
            int n2 = this.parseBuffer.size();
            if (bl && (this.insertTag != null || this.insertAfterImplied) && n2 > 0) {
                this.adjustEndSpecsForPartialInsert();
                n2 = this.parseBuffer.size();
            }
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[n2];
            this.parseBuffer.copyInto(objectArray);
            if (n == 0 && this.insertTag == null && !this.insertAfterImplied) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.parseBuffer.removeAllElements();
            this.offset += HTMLDocument.this.getLength() - n;
            ++this.flushCount;
        }

        private void adjustEndSpecsForPartialInsert() {
            int n;
            int n2 = this.parseBuffer.size();
            if (this.insertTagDepthDelta < 0) {
                n = this.insertTagDepthDelta;
                while (n < 0 && n2 >= 0 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n2 - 1)).getType() == 2) {
                    this.parseBuffer.removeElementAt(--n2);
                    ++n;
                }
            }
            if (!(this.flushCount != 0 || this.insertAfterImplied && this.wantsTrailingNewline)) {
                n = 0;
                if (this.pushDepth > 0 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(0)).getType() == 3) {
                    ++n;
                }
                int n3 = 0;
                int n4 = n += this.popDepth + this.pushDepth;
                while (n < n2 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n)).getType() == 3) {
                    ++n;
                    ++n3;
                }
                if (n3 > 1) {
                    char[] cArray;
                    while (n < n2 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n)).getType() == 2) {
                        ++n;
                    }
                    if (n == n2 && (cArray = ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n4 + n3 - 1)).getArray()).length == 1 && cArray[0] == NEWLINE[0]) {
                        n = n4 + n3 - 1;
                        while (n2 > n) {
                            this.parseBuffer.removeElementAt(--n2);
                        }
                    }
                }
            }
        }

        void addCSSRules(String string) {
            StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
            styleSheet.addRule(string);
        }

        void linkCSSStyleSheet(String string) {
            URL uRL = null;
            try {
                uRL = new URL(HTMLDocument.this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException2) {
                    uRL = null;
                }
            }
            if (uRL != null) {
                HTMLDocument.this.getStyleSheet().importStyleSheet(uRL);
            }
        }

        private boolean canInsertTag(HTML.Tag tag, AttributeSet attributeSet, boolean bl) {
            if (!this.foundInsertTag) {
                if (this.insertTag != null && !this.isInsertTag(tag) || this.insertAfterImplied && (attributeSet == null || attributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    return false;
                }
                this.foundInsertTag(bl);
                if (!this.insertInsertTag) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return this.insertTag == tag;
        }

        private void foundInsertTag(boolean bl) {
            Object object;
            int n;
            this.foundInsertTag = true;
            if (!(this.insertAfterImplied || this.popDepth <= 0 && this.pushDepth <= 0)) {
                try {
                    if (this.offset == 0 || !HTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        SimpleAttributeSet simpleAttributeSet = null;
                        n = 1;
                        if (this.offset != 0) {
                            object = HTMLDocument.this.getCharacterElement(this.offset - 1);
                            AttributeSet attributeSet = object.getAttributes();
                            if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                                n = 0;
                            } else {
                                HTML.Tag tag;
                                Object object2 = attributeSet.getAttribute(StyleConstants.NameAttribute);
                                if (object2 instanceof HTML.Tag && ((tag = (HTML.Tag)object2) == HTML.Tag.IMG || tag == HTML.Tag.HR || tag == HTML.Tag.COMMENT || tag instanceof HTML.UnknownTag)) {
                                    n = 0;
                                }
                            }
                        }
                        if (n == 0) {
                            simpleAttributeSet = new SimpleAttributeSet();
                            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        }
                        object = new DefaultStyledDocument.ElementSpec(simpleAttributeSet, 3, NEWLINE, 0, NEWLINE.length);
                        if (n != 0) {
                            ((DefaultStyledDocument.ElementSpec)object).setDirection((short)4);
                        }
                        this.parseBuffer.addElement(object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            int n2 = 0;
            while (n2 < this.popDepth) {
                this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                ++n2;
            }
            n = 0;
            while (n < this.pushDepth) {
                object = new DefaultStyledDocument.ElementSpec(null, 1);
                ((DefaultStyledDocument.ElementSpec)object).setDirection((short)5);
                this.parseBuffer.addElement(object);
                ++n;
            }
            this.insertTagDepthDelta = this.depthTo(Math.max(0, this.offset - 1)) - this.popDepth + this.pushDepth - this.inBlock;
            this.insertTagDepthDelta = bl ? ++this.insertTagDepthDelta : --this.insertTagDepthDelta;
        }

        public class FormAction
        extends SpecialAction {
            Object selectModel;
            int optionCount;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.INPUT) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                    if (string == null) {
                        string = "text";
                        mutableAttributeSet.addAttribute(HTML.Attribute.TYPE, "text");
                    }
                    this.setModel(string, mutableAttributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new TextAreaDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (tag == HTML.Tag.SELECT) {
                    boolean bl;
                    int n = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.SIZE, 1);
                    boolean bl2 = bl = (String)mutableAttributeSet.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (n > 1 || bl) {
                        OptionListModel optionListModel = new OptionListModel();
                        if (bl) {
                            optionListModel.setSelectionMode(2);
                        }
                        this.selectModel = optionListModel;
                    } else {
                        this.selectModel = new OptionComboBoxModel();
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, this.selectModel);
                }
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = new Option(mutableAttributeSet);
                    if (this.selectModel instanceof OptionListModel) {
                        OptionListModel optionListModel = (OptionListModel)this.selectModel;
                        optionListModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionListModel.addSelectionInterval(this.optionCount, this.optionCount);
                            optionListModel.setInitialSelection(this.optionCount);
                        }
                    } else if (this.selectModel instanceof OptionComboBoxModel) {
                        OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)this.selectModel;
                        optionComboBoxModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionComboBoxModel.setSelectedItem(HTMLReader.this.option);
                            optionComboBoxModel.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++this.optionCount;
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (tag == HTML.Tag.SELECT) {
                        this.selectModel = null;
                        this.optionCount = 0;
                    } else if (tag == HTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                        HTMLReader.this.textAreaDocument.storeInitialText();
                    }
                    super.end(tag);
                }
            }

            void setModel(String string, MutableAttributeSet mutableAttributeSet) {
                if (string.equals("submit") || string.equals("reset") || string.equals("image")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (string.equals("text") || string.equals("password")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (string.equals("checkbox") || string.equals("radio")) {
                    JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
                    if (string.equals("radio")) {
                        toggleButtonModel.setGroup(HTMLDocument.this.radioButtonGroup);
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, toggleButtonModel);
                }
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.PARAM) {
                    this.addParameter(mutableAttributeSet);
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag != HTML.Tag.PARAM) {
                    super.end(tag);
                }
            }

            void addParameter(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string != null && string2 != null) {
                    DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)HTMLReader.this.parseBuffer.lastElement();
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)elementSpec.getAttributes();
                    mutableAttributeSet.addAttribute(string, string2);
                }
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                if (string != null) {
                    try {
                        URL uRL = new URL(((HTMLReader)HTMLReader.this).HTMLDocument.this.base, string);
                        HTMLDocument.this.setBase(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inTitle = true;
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.inTitle = false;
                super.end(tag);
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }
        }

        class AnchorAction
        extends CharacterAction {
            AnchorAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.emptyAnchor = true;
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                if (HTMLReader.this.emptyAnchor) {
                    char[] cArray = new char[]{' '};
                    HTMLReader.this.addContent(cArray, 0, 1);
                }
                super.end(tag);
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean bl = HTMLReader.this.canInsertTag(tag, mutableAttributeSet, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!bl) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
                if (tag == HTML.Tag.B) {
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_WEIGHT, "bold");
                } else if (tag == HTML.Tag.I) {
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_STYLE, "italic");
                } else if (tag == HTML.Tag.U) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "underline";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.STRIKE) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "line-through";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.SUP) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sup";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.SUB) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sub";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.FONT) {
                    String string;
                    String string2;
                    String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.COLOR);
                    if (string3 != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.COLOR, string3);
                    }
                    if ((string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.FACE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, string2);
                    }
                    if ((string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.SIZE)) != null) {
                        styleSheet.addCSSAttributeFromHTML(HTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, string);
                    }
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean bl = HTMLReader.this.canInsertTag(tag, mutableAttributeSet, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!bl) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
                if (tag == HTML.Tag.FORM) {
                    HTMLDocument.this.radioButtonGroup = new ButtonGroup();
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
                if (tag == HTML.Tag.FORM) {
                    HTMLDocument.this.radioButtonGroup = null;
                }
            }
        }

        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inPre = true;
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
                HTMLReader.this.inPre = false;
                HTMLReader.this.blockClose(tag);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLReader.this.inHead) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(tag);
                    HTMLReader.this.styles.addElement(mutableAttributeSet.getAttribute(HTML.Attribute.TYPE));
                    HTMLReader.this.inStyle = true;
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.inStyle = false;
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLReader.this.lastMap != null) {
                    HTMLReader.this.lastMap.addArea(mutableAttributeSet.copyAttributes());
                }
            }

            public void end(HTML.Tag tag) {
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.lastMap = new Map((String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME));
                HTMLDocument.this.addMap(HTMLReader.this.lastMap);
            }

            public void end(HTML.Tag tag) {
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.REL);
                if (string != null && ((string = string.toLowerCase()).equals("stylesheet") || string.equals("alternate stylesheet"))) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(tag);
                    HTMLReader.this.styles.addElement(mutableAttributeSet.copyAttributes());
                }
                super.start(tag, mutableAttributeSet);
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inHead = true;
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && (HTMLReader.this.foundInsertTag || !mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.inStyle = false;
                HTMLReader.this.inHead = false;
                if (HTMLReader.this.styles != null) {
                    boolean bl = HTMLReader.this.isStyleCSS;
                    int n = 0;
                    int n2 = HTMLReader.this.styles.size();
                    while (n < n2) {
                        String string;
                        Object object = HTMLReader.this.styles.elementAt(n);
                        if (object == HTML.Tag.LINK) {
                            this.handleLink((AttributeSet)HTMLReader.this.styles.elementAt(++n));
                            ++n;
                            continue;
                        }
                        boolean bl2 = (string = (String)HTMLReader.this.styles.elementAt(++n)) == null ? bl : string.equals("text/css");
                        while (++n < n2 && HTMLReader.this.styles.elementAt(n) instanceof String) {
                            if (!bl2) continue;
                            HTMLReader.this.addCSSRules((String)HTMLReader.this.styles.elementAt(n));
                        }
                    }
                }
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && HTMLReader.this.foundInsertTag) {
                    super.end(tag);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }

            private void handleLink(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
                if (string == null) {
                    string = HTMLDocument.this.getDefaultStyleSheetType();
                }
                if (string.equals("text/css")) {
                    String string2 = (String)attributeSet.getAttribute(HTML.Attribute.REL);
                    String string3 = (String)attributeSet.getAttribute(HTML.Attribute.TITLE);
                    String string4 = (String)attributeSet.getAttribute(HTML.Attribute.MEDIA);
                    string4 = string4 == null ? "all" : string4.toLowerCase();
                    if (string2 != null) {
                        string2 = string2.toLowerCase();
                        if ((string4.indexOf("all") != -1 || string4.indexOf("screen") != -1) && (string2.equals("stylesheet") || string2.equals("alternate stylesheet") && string3.equals(HTMLReader.this.defaultStyle))) {
                            HTMLReader.this.linkCSSStyleSheet((String)attributeSet.getAttribute(HTML.Attribute.HREF));
                        }
                    }
                }
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                Object object = mutableAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV);
                if (object != null) {
                    if ((object = ((String)object).toLowerCase()).equals("content-style-type")) {
                        String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                        HTMLDocument.this.setDefaultStyleSheetType(string);
                        HTMLReader.this.isStyleCSS = "text/css".equals(HTMLDocument.this.getDefaultStyleSheetType());
                    } else if (object.equals("default-style")) {
                        HTMLReader.this.defaultStyle = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                    }
                }
                super.start(tag, mutableAttributeSet);
            }

            boolean isEmpty(HTML.Tag tag) {
                return true;
            }
        }

        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                if (!this.isEmpty(tag)) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(HTML.Attribute.ENDTAG, "true");
                    HTMLReader.this.addSpecialElement(tag, simpleAttributeSet);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return tag != HTML.Tag.APPLET && tag != HTML.Tag.SCRIPT;
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                HTMLReader.this.inParagraph = true;
            }

            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLReader.this.inParagraph = false;
            }
        }

        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        public class TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private HTML.Tag tag;
        private ElementIterator pos;

        LeafIterator(HTML.Tag tag, Document document) {
            this.tag = tag;
            this.pos = new ElementIterator(document);
            this.endOffset = 0;
            this.next();
        }

        public AttributeSet getAttributes() {
            Element element = this.pos.current();
            if (element != null) {
                AttributeSet attributeSet = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                return attributeSet;
            }
            return null;
        }

        public int getStartOffset() {
            Element element = this.pos.current();
            if (element != null) {
                return element.getStartOffset();
            }
            return -1;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet attributeSet;
                Element element = this.pos.current();
                if (element.getStartOffset() >= this.endOffset && (attributeSet = this.pos.current().getAttributes()).isDefined(this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public boolean isValid() {
            return this.pos.current() != null;
        }

        void nextLeaf(ElementIterator elementIterator) {
            elementIterator.next();
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                if (element.isLeaf()) break;
                elementIterator.next();
            }
        }

        void setEndOffset() {
            AttributeSet attributeSet = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator elementIterator = (ElementIterator)this.pos.clone();
            this.nextLeaf(elementIterator);
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                AttributeSet attributeSet2 = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                if (attributeSet2 == null || !attributeSet2.equals(attributeSet)) break;
                this.endOffset = element.getEndOffset();
                this.nextLeaf(elementIterator);
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }
}

