/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import com.sun.media.sound.SunMidiFileWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class StandardMidiFileWriter
extends SunMidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    private InputStream stream;
    private DataInputStream dis;
    private Sequence sequence;
    private short type;
    private short tracks;
    private long tick;
    private int status;
    private int bytesRemaining = 0;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    public static final int[] types = new int[]{0, 1};

    public int[] getMidiFileTypes() {
        int[] nArray = new int[types.length];
        System.arraycopy(types, 0, nArray, 0, types.length);
        return nArray;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] trackArray = sequence.getTracks();
        int[] nArray = trackArray.length == 1 ? new int[]{0, 1} : new int[]{1};
        return nArray;
    }

    public boolean isFileTypeSupported(int n) {
        int n2 = 0;
        while (n2 < types.length) {
            if (n == types[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        long l = 0L;
        long l2 = 0L;
        if (!this.isFileTypeSupported(n, sequence)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream inputStream = this.getFileStream(n, sequence);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        byArray = new byte[16384];
        while ((l = (long)inputStream.read(byArray)) >= 0L) {
            outputStream.write(byArray, 0, (int)l);
            l2 += l;
        }
        return (int)l2;
    }

    public int write(Sequence sequence, int n, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        Object var5_5 = null;
        int n2 = 0;
        fileOutputStream = new FileOutputStream(file);
        n2 = this.write(sequence, n, fileOutputStream);
        fileOutputStream.close();
        return n2;
    }

    private InputStream getFileStream(int n, Sequence sequence) throws IOException {
        int n2;
        Track[] trackArray = sequence.getTracks();
        int n3 = 0;
        int n4 = 14;
        int n5 = 0;
        PipedOutputStream pipedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        PipedInputStream pipedInputStream = null;
        InputStream[] inputStreamArray = null;
        InputStream inputStream = null;
        SequenceInputStream sequenceInputStream = null;
        if (n == 0) {
            if (trackArray.length != 1) {
                return null;
            }
        } else if (n == 1) {
            if (trackArray.length < 1) {
                return null;
            }
        } else if (trackArray.length == 1) {
            n = 0;
        } else if (trackArray.length > 1) {
            n = 1;
        } else {
            return null;
        }
        inputStreamArray = new InputStream[trackArray.length];
        int n6 = 0;
        while (n6 < trackArray.length) {
            block29: {
                try {
                    inputStreamArray[n6] = this.writeTrack(trackArray[n6], n);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    if (!Printer.err) break block29;
                    Printer.err("Exception in write: " + invalidMidiDataException.getMessage());
                }
            }
            ++n6;
        }
        if (trackArray.length == 1) {
            inputStream = inputStreamArray[0];
        } else if (trackArray.length > 1) {
            inputStream = inputStreamArray[0];
            int n7 = 1;
            while (n7 < trackArray.length) {
                inputStream = new SequenceInputStream(inputStream, inputStreamArray[n7]);
                ++n7;
            }
        }
        pipedOutputStream = new PipedOutputStream();
        dataOutputStream = new DataOutputStream(pipedOutputStream);
        pipedInputStream = new PipedInputStream(pipedOutputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(n4 - 8);
        if (n == 0) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(1);
        }
        dataOutputStream.writeShort((short)trackArray.length);
        float f = sequence.getDivisionType();
        if (f == 0.0f) {
            n2 = sequence.getResolution();
        } else if (f == 24.0f) {
            n2 = -6144;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 25.0f) {
            n2 = -6400;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 29.97f) {
            n2 = -7424;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 30.0f) {
            n2 = -7680;
            n2 += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        dataOutputStream.writeShort(n2);
        sequenceInputStream = new SequenceInputStream(pipedInputStream, inputStream);
        dataOutputStream.close();
        n5 = n3 + n4;
        return sequenceInputStream;
    }

    private int getType(int n) throws InvalidMidiDataException {
        if ((n & 0xF0) == 240) {
            switch (n) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + n);
        }
        switch (n & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n);
    }

    private int writeVarInt(int n) throws IOException, InvalidMidiDataException {
        int n2 = 6;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = 0;
            ++n4;
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            byArray[n5] = (byte)(n & 0x7F);
            n >>>= 7;
            if (++n3 > 1) {
                int n6 = n5;
                byArray[n6] = (byte)(byArray[n6] | 0x80);
            }
            if (n == 0) break;
            --n5;
        }
        if ((byArray[n2 - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        this.tddos.write(byArray, n2 - n3, n3);
        return n3;
    }

    private InputStream writeTrack(Track track, int n) throws IOException, InvalidMidiDataException {
        int n2 = 0;
        boolean bl = false;
        int n3 = track.size();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(pipedOutputStream);
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        SequenceInputStream sequenceInputStream = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        n4 = 0;
        int n8 = 0;
        while (n8 < n3) {
            MidiEvent midiEvent = track.get(n8);
            byte[] byArray = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            n6 = (int)midiEvent.getTick();
            n5 = (int)midiEvent.getTick() - n4;
            n4 = (int)midiEvent.getTick();
            int n9 = midiEvent.getMessage().getStatus();
            int n10 = this.getType(n9);
            switch (n10) {
                case 1: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n11 = shortMessage.getData1();
                    n2 += this.writeVarInt(n5);
                    if (n9 != n7) {
                        n7 = n9;
                        this.tddos.writeByte(n9);
                        ++n2;
                    }
                    this.tddos.writeByte(n11);
                    ++n2;
                    break;
                }
                case 2: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n11 = shortMessage.getData1();
                    int n12 = shortMessage.getData2();
                    n2 += this.writeVarInt(n5);
                    if (n9 != n7) {
                        n7 = n9;
                        this.tddos.writeByte(n9);
                        ++n2;
                    }
                    this.tddos.writeByte(n11);
                    ++n2;
                    this.tddos.writeByte(n12);
                    ++n2;
                    break;
                }
                case 3: {
                    sysexMessage = (SysexMessage)midiEvent.getMessage();
                    int n13 = sysexMessage.getLength();
                    byArray = sysexMessage.getMessage();
                    n2 += this.writeVarInt(n5);
                    n7 = n9;
                    this.tddos.writeByte(byArray[0]);
                    ++n2;
                    n2 += this.writeVarInt(byArray.length - 1);
                    this.tddos.write(byArray, 1, byArray.length - 1);
                    n2 += byArray.length - 1;
                    break;
                }
                case 4: {
                    metaMessage = (MetaMessage)midiEvent.getMessage();
                    int n13 = metaMessage.getLength();
                    byArray = metaMessage.getMessage();
                    n2 += this.writeVarInt(n5);
                    n7 = n9;
                    this.tddos.write(byArray, 0, byArray.length);
                    n2 += byArray.length;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid midi event");
                }
            }
            ++n8;
        }
        dataOutputStream.writeInt(1297379947);
        dataOutputStream.writeInt(n2);
        n2 += 8;
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        sequenceInputStream = new SequenceInputStream(pipedInputStream, byteArrayInputStream);
        dataOutputStream.close();
        this.tddos.close();
        return sequenceInputStream;
    }
}

