/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Xml;

namespace LocaleInpector
{

internal sealed class MarkupTest : PhraseTest
{

private static readonly XmlDocument m_xml = new XmlDocument();

/*
public override string Compare(Dictionary<string, string>.Enumerator originalEntry, string translated)
{
    string original = originalEntry.Current.Value;
    //m_xml.XmlResolver = new XmlUrlResolver();

    try {
        m_xml.LoadXml("<?xml version='1.0'?><root>" + original.Replace("&", "") + "<text/></root>");
    } catch {
        return null;
    }

    try {
        m_xml.LoadXml("<?xml version='1.0'?><root>" + translated.Replace("&", "") + "<text/></root>");
    } catch (System.Xml.XmlException ex) {
        m_stat.Errors++;
        return "xml error" + ex.Message;
    }

    return null;
}
*/


public override string Compare(Dictionary<string, string>.Enumerator originalEntry, string translated)
{
    System.IO.StringReader buf;
    XmlTextReader xml;


    string original = originalEntry.Current.Value;
    buf = new System.IO.StringReader(@"<?xml version=""1.0""?><root xmlns:html=""http://www.w3.org/1999/xhtml"">" + original + "</root>");
    xml = new XmlTextReader(buf);

    try {
        while (xml.Read()) {
        }
    } catch {
        xml.Close();
        return null;
    }
    xml.Close();


    buf = new System.IO.StringReader(@"<?xml version='1.0'?><root xmlns:html=""http://www.w3.org/1999/xhtml"">" + translated + "</root>");
    xml = new XmlTextReader(buf);

    try {
        while (xml.Read()) {
        }
    } catch (System.Xml.XmlException ex) {
        string msg = ex.Message;
        xml.Close();
        m_stat.Errors++;
        return msg;
    }

    xml.Close();
    return null;
}

protected override string Style
{
    get {
        return "markup";
    }
}

}//class
}//ns
