/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class CStyleFormatTest : PhraseTest
{

//%S Downloading message flag %lu of %lu[lu]
//Received %ld of %ld messages[ld]
//The %c character is reserved on this imap server. Please choose another name. [c]
//private static Regex m_regex = new Regex(@"%(\d+\$)?(?:\.\d+)?([hlL]?[a-zA-Z])");
private static Regex m_regex = new Regex(@"%(\d+\$)?(?:\.\d+)?([hlL]?[Ssudc])");

public override string Compare(Dictionary<string, string>.Enumerator originalEntry, string translated)
{
    // %[width][.precision][modifiers]type

    // search?ie\=UTF-8&oe\=UTF-8&hl\=pt-BR&meta\=lr%3Dlang_pt&q\=
    string original = originalEntry.Current.Value;

    if (MatchRegex2(original, translated) == false) {
        m_stat.Errors++;
        return "different expression(s)";
    }
    return null;
}

public static bool IsCFormat(string exp)
{
    MatchCollection matches = m_regex.Matches(exp);
    return matches.Count > 0;
}

private static bool MatchRegex2(string originalPhrase, string translatedPhrase)
{
    MatchCollection originalMatches = m_regex.Matches(originalPhrase);
    MatchCollection translatedMatches = m_regex.Matches(translatedPhrase);

    string[] original = ParamsTemplate(originalMatches);
    string[] translated = ParamsTemplate(translatedMatches);

    if (original.Length != translated.Length) {
        return false;
    }

    for (int idx = 0; idx < original.Length; idx++) {
        if (original[idx] != translated[idx]) {
            return false;
        }
    }

    return true;
}

//     0         1       2     3     4   5
// [%7$s,     %1$s, %.200s, %4$d, %1$s, %d]
// [%1$s, %3$.200s,   %2$s,   %d]
/*
tpl
[0] s
[1] ?
[2] s
[3] d
[4] null
[5] null
[6] s
*/
//
// Connected to %1$S...
// %1$s %2$s ID #%3$d
// %.200s.

/*
groups[0].Value "%S"
groups[1].Value ""
groups[2].Value "S"

groups[0].Value "%1$S"
groups[1].Value "1$"
groups[2].Value "S"
*/
private static string[] ParamsTemplate(MatchCollection matches)
{
    string[] tpl = new string[matches.Count];
    for (int idx = 0; idx < matches.Count; idx++) {
        GroupCollection groups = matches[idx].Groups;
        string ent = groups[groups.Count - 1].Value;
        string pos = groups[1].Value;
        int a = idx;
        if (pos.Length > 0) {
            a = int.Parse(pos.Substring(0, pos.Length - 1));
            if (a > tpl.Length) {
                // %777$%
                string[] tpl2 = new string[a];
                System.Array.Copy(tpl, tpl2, tpl.Length);
                tpl = tpl2;
            }
            a--;
            if (a < 0) {
                throw(new System.ArgumentOutOfRangeException("Invalid format parameter index: " + groups[0].Value));
            }
        }
        tpl[a] = groups[2].Value;
    }

    return tpl;
}

}//class
}//ns