/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class Contributors
{

private string[] m_contributors;

public Contributors(string pref)
{
    if (pref.Length == 0) {
        m_contributors = new string[0];
    } else {
        m_contributors = pref.Split(';');
        for (int idx = 0; idx < m_contributors.Length; idx++) {
            m_contributors[idx] = m_contributors[idx].Trim();
        }
    }
}

public string Append(string sourceFile)
{
    MatchEvaluator myDelegate = new MatchEvaluator(this.AddContributorCallback);
    return Regex.Replace(sourceFile,
                         "/*/*/*/*/* BEGIN LICENSE BLOCK /*/*/*/*/*.*?/*/*/*/*/* END LICENSE BLOCK /*/*/*/*/*",
                         myDelegate,
                         RegexOptions.Singleline);
}

private string AddContributorCallback(Match match)
{
    string licenseBlock = match.Groups[0].Value;
    List<string> lines = Strings.SplitLines(licenseBlock);

    int insertAt = -1;
    string head = null;
    for (int idx = 0; idx < lines.Count; idx++) {
        if (lines[idx].StartsWith("# Contributor")) {
            insertAt = idx;
            head = "#";
            break;
        } else if (lines[idx].StartsWith("   - Contributor")) {
            insertAt = idx;
            head = "   -";
            break;
        }
    }

    if (head == null) {
        return licenseBlock;
    }

    // skip other contributors
    insertAt++;
    for (int idx = insertAt; idx < lines.Count; idx++) {
        string bbb = lines[idx].Substring(head.Length).Trim();
        if (bbb.Length == 0) {
            insertAt = idx;
            break;
        }
    }

    for (int idx = 0; idx < m_contributors.Length; idx++) {
        lines.Insert(insertAt + idx, head + "   " + m_contributors[idx]);
    }

    string[] parsedLines = new string[lines.Count];
    lines.CopyTo(parsedLines, 0);
    return string.Join(Strings.FindEol(licenseBlock), parsedLines);
}

}//class
}//ns
