/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */



using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class Inspector
{

public static int Main()
{
    int ret = MainCore();
    return ret;
}

public static Inspector Current;


private static int MainCore()
{
    string title = "Locale Inspector " + Config2.GetVersion();
    //System.Console.OutputEncoding = BPIO.UTF8;
    System.Console.Title = title;
    //System.Console.BackgroundColor = System.ConsoleColor.Blue;
    //System.Console.ForegroundColor = System.ConsoleColor.Gray;
    //System.Console.ResetColor();

    Inspector theApp = new Inspector();
    return theApp.Parse();
}

private          string           m_originalModule;
private          string           m_translatedModule;
private          ConfigTest       m_config;

private Inspector()
{
    Current = this;
    m_config = new ConfigTest();
}


private int Parse()
{
    if (m_config.InitIni() == false) {
        return Config2.WriteHeader();
    }

    bool ret;

    string fileLog = Config2.Current.GetPref("out");
    if (fileLog.Length > 0) {
        fileLog = System.IO.Path.GetFullPath(fileLog);
        using (System.IO.StringWriter log = new System.IO.StringWriter()) {
            System.IO.TextWriter screen = Console.Out;
            Console.Write("Saving output to " + fileLog);
            Console.SetOut(log);
            ret = this.ParseCore();
            BPIO.Save(log.ToString(), fileLog, BPIO.UTF8);
            Console.SetOut(screen);
        }
        Console.WriteLine(" OK");

    } else {
        ret = this.ParseCore();
    }

    //Console.WriteLine();
    return ret ? 0 : 1;
}


private bool ParseCore()
{
    Output.WriteLine(Environment.CommandLine);
    //m_config.Start();

    Status allStat = new Status();
    Status mergeStat = new Status();


    Status stat = new Status();
    //Status mergeStat2 = new Status();

    Output.OpenH1("Config");
    Output.Write("Original:  ");
    m_originalModule = m_config.ValidateDir("original");
    Output.WriteLine(string.Empty);
    Output.Write("Localized: ");
    m_translatedModule = m_config.ValidateDir("translated");

    Output.WriteLine(string.Empty);
    Output.WriteLine(string.Empty);
    List<string> a = m_config.GetOptions();
    foreach (string h in a) {
        Output.WriteLine(h);
    }

    Output.Close();
    
    if (m_originalModule == null || m_translatedModule == null) {
        stat.Errors++;
    } else {
        stat.Add(this.ParseModule());
    }

    allStat.Add(stat);
/*
    if (stat.Empty) { // && mergeStat2.Empty) {
        if (mergeStat2.Comparisons == 0) {
            //Output.WriteLine("------------Clear");
            Output.Clear();
        }
    }
*/

    //m_config.End(allStat, 1);
    Output.OpenH1("Done. " +
                    ((allStat.Errors > 0)
                        ? ("Failed, " + allStat.Errors.ToString() + " errors")
                        : "No errors")
                    +  ". (" + m_config.Elapsed+ ")");
    Output.Close();

    return true;
}


private Status ParseModule()
{
    Status stat = new Status();
    stat.Add(this.MakeTests(m_translatedModule));
/*
    if (this.DoTest("directories")) {
        stat.Add(Typos.Check(m_translatedModule));
    }
*/
    return stat;
}


private bool DoTest(string test)
{
    //if (m_config.GetPref("general", "tests") != "true") {
    //    return false;
    //}
    //if (m_config.GetPref(test, "enabled") != "true") {
    if (m_config.GetPref(test) != "true") {
        return false;
    }
    return true;
}

private Status MakeTests(string translatedModule)
{
    Status stat = new Status();

    if (this.DoTest("directories")) {
        stat.Add(Directories.Check(m_originalModule, translatedModule));
    }

    if (this.DoTest("files")) {
        stat.Add(Files.Check(m_originalModule, translatedModule));
    }

    if (this.DoTest("bom")) {
        stat.Add(Bom.Check(translatedModule));
    }

    if (this.DoTest("keys")) {
        stat.Add(Keys.Check(m_originalModule, translatedModule));
    }

    if (this.DoTest("escapes")) {
        stat.Add(EscapeTest.Check(m_originalModule, translatedModule));
    }

    if (this.DoTest("keybinding")) {
        stat.Add(Phrases.CheckKeyBinding(m_originalModule, translatedModule));
    }

    if (this.DoTest("accesskey")) {
        stat.Add(AccessKey.Check(m_originalModule, translatedModule));
    }

    if (this.DoTest("c-format")) {
        stat.Add(Phrases.CheckCFormat(m_originalModule, translatedModule));
    }

    if (this.DoTest("entities")) {
        stat.Add(Phrases.CheckEntities(m_originalModule, translatedModule));
    }

    if (this.DoTest("placeholders")) {
        stat.Add(Phrases.CheckPlaceholders(m_originalModule, translatedModule));
    }

    if (this.DoTest("markup")) {
        stat.Add(Phrases.CheckMarkup(m_originalModule, translatedModule));
    }

    if (this.DoTest("untranslated")) {
        stat.Add(Phrases.CheckUntranslated(m_originalModule, translatedModule));
    }

    return stat;
}


}//class
}//ns