/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class MergeDirective : Merge
{

private string m_value;


public MergeDirective(DirectiveFile dic) : base(dic)
{
}


protected override string MergeFile(string translatedDir, string path)
{
    DirectiveFile prop = new DirectiveFile(translatedDir + path);
    Dictionary<string, string> translation = prop.LoadHashtable();
    return this.MergeFileEx(translation, path);
}


protected override string MergeFileEx(Dictionary<string, string> translation, string path)
{
    List<string> linesOriginal = Strings.SplitLines(m_dic.Content);
    string[] linesTranslated = new string[linesOriginal.Count];
    Dictionary<string, string> keysSource = m_dic.LoadHashtable(); // h:wtf
    MatchEvaluator myDelegate = new MatchEvaluator(this.MergeItemCallback);

    for (int idx = 0; idx < linesOriginal.Count; idx++) {
        string myLine = linesOriginal[idx];
        string[] originalLine = DirectiveFile.ParseDirectiveLine(myLine);
        if (originalLine == null) {
            linesTranslated[idx] = myLine; // comentario
            continue;
        }


        //if (l10nValue == null) {
        if (translation.ContainsKey(originalLine[0]) == false) {
            // l10nValue = null ==> no existe na localization
            this.WriteWarning("missing " + path + " => " + originalLine[0] + ". Using the original value.");
            linesTranslated[idx] = myLine;
        } else {
            string l10nValue = translation[originalLine[0]];
            // replace
            m_value = l10nValue;
            linesTranslated[idx] = Regex.Replace(myLine, @"(#define\s+\w+\s*)(.*)", myDelegate);

            string err = MergeIni.TestIniString(myLine, linesTranslated[idx]); // bug: test includes full line
            if (err != null) {
                linesTranslated[idx] = myLine;
                this.WriteWarning(err + ": " + path + " => " + originalLine[0] + ". Using the original value.");
            }
        }
    }

    return string.Join(m_dic.Eol, linesTranslated);
}


/*
# Installer keys (don't translate strings in $$)
#define   SETUP_TITLE       $ProductShortName$ Setup
*/
private string MergeItemCallback(Match match)
{
    GroupCollection groups = match.Groups;
    return groups[1].Value + m_value;
}


}//class
}//ns
