/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code Clippings.
 *
 * The Initial Developer of the Original Code is 
 * Alex Eng <ateng@users.sourceforge.net>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */



function aeClippingsUtils() {}

aeClippingsUtils.prototype = {
  // Debugging flag - set to false to suppress extraneous JS console messages
  DEBUG:   false,

  // Host app GUIDs
  HOSTAPP_FX_GUID: "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}",
  HOSTAPP_TB_GUID: "{3550f703-e582-4d05-9a08-453d09bdfdc6}",

  // Clippings-specific constants
  CLIPDAT_FILE_NAME: "clipdat2.rdf",
  CLIPDAT_1X_FILE_NAME: "clipdat.rdf",
  BACKUP_DIR_NAME:   ".clipbak"
};


aeClippingsUtils.prototype.alertEx = function (aTitle, aMessage)
{
  var prmpt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
  prmpt.alert(null, aTitle, aMessage);
};


aeClippingsUtils.prototype.confirmEx = function (aTitle, aMessage)
{
  var rv;
  var prmpt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
  rv = prmpt.confirm(null, aTitle, aMessage);
  return rv;
};


aeClippingsUtils.prototype.getTextFromClipboard = function () 
{
  var rv;
  var clipbd = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
  var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
  trans.addDataFlavor("text/unicode");
  clipbd.getData(trans, clipbd.kGlobalClipboard);

  var str = {};
  var strLen = {};
  try {
    trans.getTransferData("text/unicode", str, strLen);
  } 
  catch (e) {
    // Failed because there's nothing on the clipboard or the clipboard
    // contents isn't textual data
    return rv;
  }

  if (str) {
    str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
  }
  if (str) {
    rv = str.data.substring(0, strLen.value / 2);
  }

  return rv;
};


aeClippingsUtils.prototype.copyTextToClipboard = function (aText) 
{
  var clipbd = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
  clipbd.copyString(aText);
};


aeClippingsUtils.prototype.getPref = function (aPrefName, aDefaultValue)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  try {
    var prefType = pref.getPrefType(aPrefName);
  } catch (e) {
    this.log(e);
  }
  var rv;
  switch (prefType) {
  case pref.PREF_STRING:
    rv = pref.getCharPref(aPrefName);
    break;

  case pref.PREF_INT:
    rv = pref.getIntPref(aPrefName);
    break;

  case pref.PREF_BOOL:
    rv = pref.getBoolPref(aPrefName);
    break;

  default:
    break;
  }

  if (rv === undefined) {
    rv = aDefaultValue;
  }

  return rv;
};

  
aeClippingsUtils.prototype.setPref = function (aPrefName, aPrefValue)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  try {
    var prefType = pref.getPrefType(aPrefName);
  } catch (e) {
    this.log(e);
  }

  switch (prefType) {
    case pref.PREF_STRING:
    pref.setCharPref(aPrefName, aPrefValue);
    break;

    case pref.PREF_INT:
    pref.setIntPref(aPrefName, aPrefValue);
    break;

    case pref.PREF_BOOL:
    pref.setBoolPref(aPrefName, aPrefValue);
    break;

    default:
    break;
  }
};


aeClippingsUtils.prototype.resetPref = function (aPrefName)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  pref.clearUserPref(aPrefName);
};


aeClippingsUtils.prototype.isCommonDataSourceEnabled = function ()
{
  return false;
};


aeClippingsUtils.prototype.getDataSourcePathURL = function ()
{
  var rv;

  if (this.getPref("clippings.datasource.url")) {
    // TO DO: User can specify a custom URL of a datasource folder.
    // If this pref is set, get that URL and return its path
    // (in file:// URL format)
  }
  else if (this.getPref("clippings.datasource.common")) {
    var homeDir = this.getHomeDir();
    var fph = Components.classes["@mozilla.org/network/protocol;1?name=file"]
                        .createInstance(Components.interfaces
					          .nsIFileProtocolHandler);
    var homeDirURL = fph.getURLSpecFromFile(homeDir);
    rv = homeDirURL;
  }
  else {
    rv = this.getCurrentProfileURL();
  }

  return rv;
};


aeClippingsUtils.prototype.getCurrentProfileURL = function ()  
{
  var profileDir = this.getCurrentProfileDir();
  var fph = Components.classes["@mozilla.org/network/protocol;1?name=file"]
                      .createInstance(Components.interfaces
				                .nsIFileProtocolHandler);
  return fph.getURLSpecFromFile(profileDir);
};


// Throws an exception if profile directory retrieval failed.
aeClippingsUtils.prototype.getCurrentProfileDir = function ()
{
  var dirProp = Components.classes["@mozilla.org/file/directory_service;1"]
                          .getService(Components.interfaces.nsIProperties);
  var profileDir = dirProp.get("ProfD", Components.interfaces.nsIFile);
  if (! profileDir) {
    throw "Failed to retrieve current profile directory";
  }

  return profileDir;
};


// Throws an exception if user home directory retrieval failed.
aeClippingsUtils.prototype.getHomeDir = function ()
{
  var dirProp = Components.classes["@mozilla.org/file/directory_service;1"]
                          .getService(Components.interfaces.nsIProperties);
  var homeDir = dirProp.get("Home", Components.interfaces.nsIFile);
  if (! homeDir) {
    throw "Failed to retrieve user's home directory";
  }

  return homeDir;
};


aeClippingsUtils.prototype.getHostAppID = function ()
{
  var rv;
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                          .createInstance(Components.interfaces.nsIXULAppInfo);
  rv = appInfo.ID;
  return rv;
};


aeClippingsUtils.prototype.getHostAppName = function ()
{
  var rv;
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                          .createInstance(Components.interfaces.nsIXULAppInfo);
  rv = appInfo.name;

  return rv;
}


aeClippingsUtils.prototype.getHostAppVersionStr = function ()
{
  var rv;
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                          .createInstance(Components.interfaces.nsIXULAppInfo);
  rv = appInfo.version;
  
  return rv;
};


aeClippingsUtils.prototype.getRecentHostAppWindow = function ()
{
  const WNDTYPE_FX_BROWSER    = "navigator:browser";
  const WNDTYPE_TB_MSGCOMPOSE = "msgcompose";

  var rv;
  var wndType;
  var hostAppID = this.getHostAppID();
  
  if (hostAppID == this.HOSTAPP_FX_GUID) {
    wndType = WNDTYPE_FX_BROWSER;
  }
  else if (hostAppID == this.HOSTAPP_TB_GUID) {
    wndType = WNDTYPE_TB_MSGCOMPOSE;
  }

  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1']
                     .getService(Components.interfaces.nsIWindowMediator);
  rv = wm.getMostRecentWindow(wndType);

  return rv;
};


aeClippingsUtils.prototype.beep = function () 
{
  var sound = Components.classes["@mozilla.org/sound;1"]
                        .createInstance(Components.interfaces.nsISound);
  sound.beep();
};


aeClippingsUtils.prototype.log = function (aMessage) 
{
  if (this.DEBUG) {
    var consoleSvc = Components.classes["@mozilla.org/consoleservice;1"]
                               .getService(Components.interfaces
					             .nsIConsoleService);
    consoleSvc.logStringMessage(aMessage);
  }
};
