/*
** Session Saver 0.2d : Pike + rue
*/ 

var SessionSaverSettings = {

	onLoad: function() {
		// Setup object properties
		this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		this.prefBranch = "sessionsaver.";
		this.prefBranchSettings = "settings.";
		this.settingsBranch = this.prefService.getBranch(this.prefBranch+this.prefBranchSettings);
		
		this.radioAutoMode = document.getElementById('radio-mode-auto');
		this.radioManualMode = document.getElementById('radio-mode-manual');
		
		this.radioAutoLoad = document.getElementById('autoload');
		this.radioCrashLoad = document.getElementById('crashload');
		this.checkboxShutdownSave = document.getElementById('shutdownsave');
		this.checkboxOverwriteTabs = document.getElementById('overwritetabs');
		
		// primary mode-selection
		var selectedMode = !this.settingsBranch.prefHasUserValue('mode') || this.settingsBranch.getBoolPref('mode'); // true: 'auto' -- false: 'manual'
		this.radioAutoMode.setAttribute("selected", selectedMode);
		this.radioManualMode.setAttribute("selected", !selectedMode);
		
		// sub-selections
		var autoLoad = !this.settingsBranch.prefHasUserValue('autoload') || this.settingsBranch.getBoolPref('autoload'); // default:true
		var shutdownSave = !this.settingsBranch.prefHasUserValue('shutdownsave') || this.settingsBranch.getBoolPref('shutdownsave'); // default:true
		var overwriteTabs = this.settingsBranch.prefHasUserValue('overwritetabs') && this.settingsBranch.getBoolPref('overwritetabs'); // default:false
		this.radioAutoLoad.setAttribute("selected", autoLoad); // load every time
		this.radioCrashLoad.setAttribute("selected", !autoLoad); // opposite - only crash-recover
		this.checkboxShutdownSave.setAttribute("checked", shutdownSave);
		this.checkboxOverwriteTabs.setAttribute("checked", overwriteTabs);
		
		// disable appropriate sub-selection(s)
		this.radioAutoLoad.disabled = !selectedMode;
		this.checkboxShutdownSave.disabled = selectedMode;
		
		// reveal any hidden-prefs that have been set
		if (this.settingsBranch.prefHasUserValue('overwritetabs')) this.checkboxOverwriteTabs.hidden = false; // setAttribute("style", "visibility: visible;");
		
		// save original values of hidden-prefs
		this.overwriteTabs_orig = overwriteTabs;
		
		// set mouse-move listener for hidden-prefs
		document.getElementById("parentBox").addEventListener("mousemove", this.onMouseMove, true);
	},
	
	// "OK" button was clicked
	onAccept: function() {
		this.settingsBranch.setBoolPref("mode", (this.radioAutoMode.getAttribute("selected") == "true") ? true:false);
		this.settingsBranch.setBoolPref("autoload", (this.radioAutoLoad.getAttribute("selected") == "true") ? true:false);
		this.settingsBranch.setBoolPref("shutdownsave", (this.checkboxShutdownSave.getAttribute("checked") == "true") ? true:false);
		// only save hidden-prefs if they've changed
		if (this.overwriteTabs_orig != ((this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("overwritetabs", (this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false);
		this.prefService.savePrefFile(null); // save the prefs to disk
	},
	
	// mouse-move detected - handle hidden-prefs
	onMouseMove: function(evt) {
		if(evt.shiftKey) {
			document.getElementById('overwritetabs').hidden = false;
			sizeToContent(); }
		// onmousemove="if(event.shiftKey) document.getElementById('overwritetabs').hidden=false; sizeToContent(); /*.setAttribute('style', 'visibility: visible;');*/"	
	}
};