/*
** Session Saver 0.2d : rue
*/ 

// enable xpconnect -- anywhere!
netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
const DATASOURCE_CONTRACTID = '@mozilla.org/rdf/datasource;1?name=in-memory-datasource';
const RDFSERVICE_CONTRACTID = '@mozilla.org/rdf/rdf-service;1';
const CONTAINERUTILS_CONTRACTID = '@mozilla.org/rdf/container-utils;1';
const CONTENTPOLICY_CONTRACTID = "@mozilla.org/layout/content-policy;1";

var rdf =  Components.classes[RDFSERVICE_CONTRACTID].getService(Components.interfaces.nsIRDFService);
var utils = Components.classes[CONTAINERUTILS_CONTRACTID].getService(Components.interfaces.nsIRDFContainerUtils);
var policy = Components.classes[CONTENTPOLICY_CONTRACTID].getService(Components.interfaces.nsIContentPolicy);
var datasource, sequence;

const prefix = 'http://sessionsaver.mozilla.org/rdf#';

var SessionSaverManager = {

	onLoad: function() {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
		// Setup object properties
		this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		this.prefBranch = "sessionsaver.";
		this.prefBranchWindows = "windows.";  // the "live" capture of the current session
		this.prefBranchStatic = "static."; // all manually captured sessions
		this.staticBranchDefault = "default."; // the default manual-session
		this.prefBranchSettings = "settings.";
		this.Branch = this.prefService.getBranch(this.prefBranch);
		this.settingsBranch = this.prefService.getBranch(this.prefBranch+this.prefBranchSettings);
		
		this.list = document.getElementById('list');
		
		this.list.addEventListener("dblclick", function(evt){SessionSaverManager.onListClick(evt);}, true);
		
		this.initList();
	},
		
	initList: function(autoLoadBranch, shutdownSaveBranch) {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
		// popup-menus' datasource
		datasource = Components.classes[DATASOURCE_CONTRACTID].createInstance(Components.interfaces.nsIRDFDataSource);
		//this.parentBox.database.AddDataSource(datasource);
		this.list.database.AddDataSource(datasource);
		
		sequence = utils.MakeSeq(datasource, rdf.GetResource('urn:root:sessions'));
		
		// don't list duplicates (branches have multiple prefs)
		var sessionArray = this.Branch.getChildList(this.prefBranchStatic, {}); // array of pref-names holding custom-sessions
		sessionArray.sort(); // the ordering is initially skewed / random
		sessionArray.unshift(this.prefBranchStatic+this.staticBranchDefault+"zorder"); // always include the default branch
		var sessionString = "";
		while (sessionArray.length > 0) {
			var branch = sessionArray[0].match(/(.*\.)[^\.]+$/)[1];
			if (sessionString.indexOf(branch) == -1) 
				sessionString += (sessionString.length>0 ? " ":"")+branch;
			sessionArray.shift();
		}
		sessionArray = sessionString.split(" ");
		for (var n = 0; n < sessionArray.length; n++) {
			var resource = rdf.GetResource(sessionArray[n]);
			var sessionDescription = sessionArray[n].match(/^[^.]+\.(.*)\.$/)[1].replace(/[_]/g, " ").split(" ");
			for (var x in sessionDescription) sessionDescription[x] = sessionDescription[x].replace(/^./, sessionDescription[x].charAt(0).toUpperCase())
			sessionDescription = sessionDescription.join(" ");
			var sessionLocation = sessionArray[n];
			//if (sessionLocation == autoLoadBranch) var autoLoadIndex = n+1; // +1 because we have a hardcoded menuitem, here
			datasource.Assert(resource, rdf.GetResource(prefix + 'label'), rdf.GetLiteral(sessionDescription), true);
			datasource.Assert(resource, rdf.GetResource(prefix + 'value'), rdf.GetLiteral(sessionLocation), true);
			//datasource.Assert(resource, rdf.GetResource(prefix + 'autoloadSelected'), rdf.GetLiteral(autoLoadSelected), true);
			//datasource.Assert(resource, rdf.GetResource(prefix + 'shutdownsaveSelected'), rdf.GetLiteral(shutdownSaveSelected), true);
			sequence.AppendElement(resource);
		}
		this.list.builder.rebuild();
		
		//this.menuAutoLoadFrom.selectedIndex = (autoLoadIndex > 0) ? autoLoadIndex : 0;
	},
	
	onListClick: function(evt) {
		var selected = evt.target;
		var list = selected.parentNode.listBoxObject;
		var cell = document.getAnonymousNodes(selected)[0];
		var field = document.getAnonymousNodes(selected)[1];
		var filter = cell.getAttribute("label");
		var selectedIndex = list.selectedIndex;
		var scrollView = list.getIndexOfFirstVisibleRow();
		var visibleRows = list.getNumberOfVisibleRows();
		
		// if the selected item isn't visible, show it
		if (selectedIndex < scrollView ||
				selectedIndex > (scrollView + visibleRows-1))
			list.scrollToIndex(selectedIndex - (visibleRows/2) + ((visibleRows%2)?1:0)); // set it mid-screen, rounding up
	
		if (!selected.modifying) {
			list.modifying = selected;
			selected.modifying = true;	
			cell.hidden = true;
			field.value = filter;
			field.hidden = false;
			
			list.blur()
			field.focus();
			//this.field.setAttribute("onblur", "deactivateModify(event.target);");
		}
	
	},
	
	// "OK" button was clicked
	onAccept: function() {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesWrite');
		this.settingsBranch.setBoolPref("autoload", (this.checkboxAutoLoad.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("crashload", (this.checkboxCrashLoad.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("concatenate", (this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("overwritewindows", (this.checkboxOverwriteWindows.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("overwritetabs", (this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("shutdownsave", (this.checkboxShutdownSave.getAttribute("checked") == "true") ? true:false);

		// only save hidden-prefs if they've changed
		if (this.autoLoadBranch_orig != this.menuAutoLoadFrom.value)
			this.settingsBranch.setCharPref("autoload.branch", this.menuAutoLoadFrom.value);
		if (this.shutdownSaveBranch_orig != this.menuShutdownSaveTo.value)
			this.settingsBranch.setCharPref("shutdownsave.branch", this.menuShutdownSaveTo.value);
		if (this.fileMenu_orig != ((this.checkboxFileMenu.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("filemenu", !this.fileMenu_orig);
		/*
		if (this.overwriteTabs_orig != ((this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("overwritetabs", (this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false);
		if (this.concatenate_orig != ((this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("concatenate", (this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false);
		*/
		
		this.prefService.savePrefFile(null); // save the prefs to disk
	},
	
	// mouse-move detected - handle hidden-prefs
	onMouseMove: function(evt) {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		if(evt.shiftKey) {
			SessionSaverSettings.labelAutoLoadFrom.hidden = false;
			SessionSaverSettings.menuAutoLoadFrom.hidden = false;
			SessionSaverSettings.labelCrashLoadWarning.hidden = false;
			SessionSaverSettings.labelShutdownSaveTo.hidden = false;
			SessionSaverSettings.menuShutdownSaveTo.hidden = false;
			SessionSaverSettings.checkboxFileMenu.hidden = false;
			sizeToContent(); }
	}
};