/*
    getOption() and setOption(sel) are required to get around the reverse selection bug in Firefox.
*/
function getOption()
{
    var TOTAL = 4;
    
    for(var i = 0; i < TOTAL; i++)
        if(document.getElementById("radio"+i).selected)
            return i;
            
    return -1;
}

function setOption(sel)
{
    var rg = document.getElementById("frame-rg");
    
    rg.selectedItem = document.getElementById("radio"+sel);
}

function onInit()
{
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var dsource = RDF.GetDataSource("rdf:local-store");
    var nameRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    var node;
    var tempVar;
    
    tempVar = dsource.GetTarget(RDF.GetResource("http://www.3dbuzz.com/settings/browseWithFrames"), nameRDF, true);
    if(tempVar)
        tempVar = parseInt(tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral).Value)-1;
    else
        tempVar = 0;
        
    setOption(tempVar);
}

function save()
{
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var dsource = RDF.GetDataSource("rdf:local-store");
    var nameRDF = RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    var node;
    var tempVar;

    // Save the option of browsing with frames
    node = RDF.GetResource("http://www.3dbuzz.com/settings/browseWithFrames");
    tempVar = dsource.GetTarget(node, nameRDF, true);
    if(tempVar)
    {
        tempVar = tempVar.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(node, nameRDF, tempVar, true);
    }
    tempVar = RDF.GetLiteral(getOption()+1);
    dsource.Assert(node, nameRDF, tempVar, true);
}

function onOK()
{
    save();
    return true;
}