/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal.notification;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.xmind.core.IAccount;
import net.xmind.signin.ILicenseInfo;
import net.xmind.signin.ILicenseKeyHeader;
import net.xmind.signin.ILicenseListener;
import net.xmind.signin.XMindNet;
import net.xmind.workbench.internal.Messages;
import net.xmind.workbench.internal.XMindNetWorkbench;
import net.xmind.workbench.internal.notification.DataStoreSiteEvent;
import net.xmind.workbench.internal.notification.ISiteEvent;
import net.xmind.workbench.internal.notification.SiteEventStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.dialogs.Promotion;
import org.xmind.ui.io.WebImageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteEventNotificationService
implements ILicenseListener,
IPartListener {
    private static final String LOCAL_STORE_FILE_NAME = "site-events.xml";
    private static boolean DEBUGGING = XMindNetWorkbench.isDebugging("/debug/events");
    private static String HABIT_PROP_FILE = "habit.properties";
    private static String FIRST_START_TIMESTAMP = "firstStartTimestamp";
    private static String START_TIMESTAMP_1 = "startTimestamp1";
    private static String START_TIMESTAMP_2 = "startTimestamp2";
    private static String START_TIMESTAMP_3 = "startTimestamp3";
    private static int POPUP_DURATION = 60000;
    private IWorkbench workbench;
    private IAccount account;
    private CheckSiteEventJob job;
    private SiteEventStore localEventStore;
    private String licenseType = "free";
    private ILicenseKeyHeader licenseKeyHeader = null;
    private boolean startup = true;
    private IPreferenceStore prefStore;
    private String productVersion;
    private Properties habitData;
    private File habitFile;

    public SiteEventNotificationService(IWorkbench workbench, IAccount account) {
        Assert.isNotNull((Object)workbench);
        this.workbench = workbench;
        this.account = account;
        this.prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.xmind.cathy");
        this.productVersion = System.getProperty("org.xmind.product.version");
        this.habitData = this.loadHabitData();
    }

    private SiteEventStore getLocalEventStore() {
        if (this.localEventStore == null) {
            File file = SiteEventNotificationService.getLocalStoreFile();
            if (file.isFile()) {
                try {
                    this.localEventStore = new SiteEventStore(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                }
                catch (IOException iOException) {
                    this.localEventStore = new SiteEventStore();
                }
            } else {
                this.localEventStore = new SiteEventStore();
            }
        }
        return this.localEventStore;
    }

    private void setLocalEventStore(SiteEventStore store) {
        this.localEventStore = store;
    }

    private void saveLocalEventStore() throws IOException {
        if (this.localEventStore == null) {
            return;
        }
        File file = SiteEventNotificationService.getLocalStoreFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        this.localEventStore.save(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    private static File getLocalStoreFile() {
        return new File(XMindNetWorkbench.getStatePath(LOCAL_STORE_FILE_NAME));
    }

    private synchronized void checkEvent() {
        if (this.isNotificationAllowed()) {
            if (this.job != null && this.job.isRunning()) {
                return;
            }
            this.job = new CheckSiteEventJob(this.startup);
            this.job.start();
            this.startup = false;
        } else {
            this.stop();
        }
    }

    private synchronized void requestPromotion(Properties toAppendParametes) {
        if (this.isNotificationAllowed()) {
            CheckSiteEventJob job = new CheckSiteEventJob(this.startup);
            if (toAppendParametes != null) {
                Set<Object> keys = toAppendParametes.keySet();
                for (Object key : keys) {
                    job.appendParameter((String)key, toAppendParametes.getProperty((String)key));
                }
            }
            job.start();
            this.startup = false;
        }
    }

    private boolean isNotificationAllowed() {
        return this.prefStore.getBoolean("checkUpdatesOnStartup");
    }

    private void showNotifications(final List<ISiteEvent> events) {
        if (this.workbench == null) {
            return;
        }
        if (this.canShowNotifications()) {
            this.doShowNotifications(events);
        } else {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (!SiteEventNotificationService.this.canShowNotifications()) {
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    SiteEventNotificationService.this.doShowNotifications(events);
                }
            });
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.setName("WaitToShowNotifications");
            thread.start();
        }
    }

    private boolean canShowNotifications() {
        if (this.workbench == null) {
            return false;
        }
        final IWorkbench wb = this.workbench;
        final Display display = wb.getDisplay();
        final boolean[] active = new boolean[1];
        display.syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                active[0] = window != null && display.getActiveShell() == window.getShell();
            }
        });
        return active[0];
    }

    private void doShowNotifications(final List<ISiteEvent> events) {
        if (this.workbench == null) {
            return;
        }
        final IWorkbench wb = this.workbench;
        Display display = wb.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                for (ISiteEvent event : events) {
                    String style;
                    if (DEBUGGING) {
                        System.out.println("Showing event: " + event);
                    }
                    if (!SiteEventNotificationService.this.isShowTime(event)) continue;
                    String text = event.getHTML();
                    if (text == null || "".equals(text)) {
                        text = event.getText();
                    }
                    if (text == null) continue;
                    String url = event.getInternalUrl();
                    if (url == null) {
                        url = event.getEventUrl();
                    }
                    if ((style = event.getStyle()) != null && "go".equals(style.toLowerCase())) {
                        XMindNet.gotoURL((String)url, (Object[])new Object[0]);
                        long time = System.currentTimeMillis();
                        String sessionId = UUID.randomUUID().toString();
                        XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/ShowTime/%s/%s", event.getId(), sessionId), time);
                        XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/DismissTime/%s/%s", event.getId(), sessionId), time);
                        XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/ClickTime/%s/%s", event.getId(), sessionId), time);
                        continue;
                    }
                    this.doShowNotification(event, shell, text, url);
                }
            }

            private void doShowNotification(final ISiteEvent event, final Shell shell, final String text, final String url) {
                final String imageUrl = event.getImageUrl();
                if (imageUrl == null) {
                    SiteEventNotificationService.this.workbench.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            SiteEventNotificationService.this.internalShowNotification(shell, event, text, url, null);
                        }
                    });
                    return;
                }
                WebImageManager.getInstance().requestWebImage(imageUrl, null, new WebImageManager.WebImageCallback(){

                    public void handleWith(String imagePath) {
                        if (imagePath == null || !new File(imagePath).exists()) {
                            SiteEventNotificationService.this.workbench.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    SiteEventNotificationService.this.internalShowNotification(shell, event, text, url, null);
                                }
                            });
                            return;
                        }
                        final String image1xPath = imagePath;
                        String image2xUrl = SiteEventNotificationService.this.getImage2xUrl(imageUrl);
                        WebImageManager.getInstance().requestWebImage(image2xUrl, null, new WebImageManager.WebImageCallback(){

                            public void handleWith(String imagePath) {
                                String image2xPath = null;
                                if (imagePath != null && new File(imagePath).exists()) {
                                    image2xPath = SiteEventNotificationService.this.getImage2xPath(image1xPath);
                                    new File(imagePath).renameTo(new File(image2xPath));
                                }
                                ImageDescriptor image = null;
                                try {
                                    image = ImageDescriptor.createFromURL((URL)new File(image1xPath).toURI().toURL());
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                final ImageDescriptor image_0 = image;
                                final String image2xPath_0 = image2xPath;
                                SiteEventNotificationService.this.workbench.getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        SiteEventNotificationService.this.internalShowNotification(shell, event, text, url, image_0);
                                        new File(image1xPath).delete();
                                        if (image2xPath_0 != null) {
                                            new File(image2xPath_0).delete();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private String getImage2xUrl(String imageUrl) {
        int index = imageUrl.lastIndexOf(".");
        if (index == -1) {
            return String.valueOf(imageUrl) + "@2x";
        }
        return String.valueOf(imageUrl.substring(0, index)) + "@2x" + imageUrl.substring(index);
    }

    private String getImage2xPath(String imagePath) {
        int index = imagePath.lastIndexOf(".");
        if (index == -1) {
            return String.valueOf(imagePath) + "@2x";
        }
        return String.valueOf(imagePath.substring(0, index)) + "@2x" + imagePath.substring(index);
    }

    private void internalShowNotification(Shell shell, ISiteEvent event, String text, String url, ImageDescriptor image) {
        int duration = event.getDuration();
        if (duration >= 0 && duration == 0) {
            duration = POPUP_DURATION;
        }
        final String eventId = event.getId();
        final String sessionId = UUID.randomUUID().toString();
        String actionText = event.getActionText();
        URLAction action = new URLAction(actionText, url, event.isOpenExternal()){

            public void run() {
                super.run();
                XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/ClickTime/%s/%s", eventId, sessionId), System.currentTimeMillis());
            }
        };
        action.setImageDescriptor(image);
        Promotion popup = new Promotion(shell, text, (IAction)action, false);
        popup.setDuration(duration);
        popup.open();
        XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/ShowTime/%s/%s", eventId, sessionId), System.currentTimeMillis());
        popup.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("Notifications/DismissTime/%s/%s", eventId, sessionId), System.currentTimeMillis());
            }
        });
        this.recordShowEventTimestamp(event);
    }

    private synchronized void stop() {
        if (this.job != null) {
            this.job.stop();
            this.job = null;
        }
    }

    protected void parseLicenseInfo(ILicenseInfo info) {
        int type = info.getType();
        if ((type & 2) != 0) {
            this.licenseType = "pro_license";
            this.licenseKeyHeader = info.getLicenseKeyHeader();
        } else if ((type & 4) != 0) {
            this.licenseType = "plus_license";
            this.licenseKeyHeader = info.getLicenseKeyHeader();
        } else if ((type & 1) != 0) {
            this.licenseType = "pro";
            this.licenseKeyHeader = null;
        } else {
            this.licenseType = "free";
            this.licenseKeyHeader = null;
        }
    }

    public void start() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.registerPartListener();
        this.recordFirstTimeStartXMindTimestamp();
        this.recordStartXMindTimestamp();
        if (this.productVersion != null && !"".equals(this.productVersion)) {
            ILicenseInfo licenseInfo = XMindNet.getLicenseInfo();
            int type = licenseInfo.getType();
            if (type == Integer.MIN_VALUE) {
                XMindNet.addLicenseListener((ILicenseListener)this);
            } else {
                this.parseLicenseInfo(licenseInfo);
                this.checkEvent();
            }
        }
    }

    public void shutdown() {
        this.stop();
        XMindNet.removeLicenseListener((ILicenseListener)this);
        this.workbench.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = SiteEventNotificationService.this.workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    window.getPartService().removePartListener((IPartListener)SiteEventNotificationService.this);
                }
            }
        });
        this.saveHabitData();
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        this.stop();
        return true;
    }

    private static final String getDistributionId() {
        String distribId = System.getProperty("org.xmind.product.distribution.id");
        if (distribId == null || "".equals(distribId)) {
            distribId = "cathy_portable";
        }
        return distribId;
    }

    private String getAccountType() {
        return this.licenseType;
    }

    public void licenseVerified(ILicenseInfo info) {
        XMindNet.removeLicenseListener((ILicenseListener)this);
        this.parseLicenseInfo(info);
        this.checkEvent();
    }

    private Properties loadHabitData() {
        Properties prop = new Properties();
        File file = this.getHabitFile();
        if (file == null || !file.exists()) {
            return prop;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                prop.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (IOException iOException) {}
        return prop;
    }

    private void saveHabitData() {
        File file = this.getHabitFile();
        file.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                this.habitData.store(fos, "Record user habit data.");
            }
            finally {
                fos.close();
            }
        }
        catch (IOException iOException) {}
    }

    private File getHabitFile() {
        Bundle bundle;
        if (this.habitFile == null && (bundle = XMindNetWorkbench.getDefault().getBundle()) != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            this.habitFile = new File(root, HABIT_PROP_FILE);
        }
        return this.habitFile;
    }

    private void recordFirstTimeStartXMindTimestamp() {
        String timestamp = this.habitData.getProperty(FIRST_START_TIMESTAMP);
        if (timestamp == null) {
            this.habitData.setProperty(FIRST_START_TIMESTAMP, String.valueOf(System.currentTimeMillis()));
        }
    }

    private void recordStartXMindTimestamp() {
        String[] timestamps = this.loadStartXMindTimestamp();
        long currentTimestamp = System.currentTimeMillis();
        timestamps[0] = timestamps[1];
        timestamps[1] = timestamps[2];
        timestamps[2] = String.valueOf(currentTimestamp);
        this.habitData.setProperty(START_TIMESTAMP_1, timestamps[0]);
        this.habitData.setProperty(START_TIMESTAMP_2, timestamps[1]);
        this.habitData.setProperty(START_TIMESTAMP_3, timestamps[2]);
    }

    private String[] loadStartXMindTimestamp() {
        String[] timestamps = new String[]{this.habitData.getProperty(START_TIMESTAMP_1, ""), this.habitData.getProperty(START_TIMESTAMP_2, ""), this.habitData.getProperty(START_TIMESTAMP_3, "")};
        return timestamps;
    }

    private void recordShowEventTimestamp(ISiteEvent event) {
        String id = event.getId();
        if (id == null || "".equals(id)) {
            return;
        }
        long currentTimestamp = System.currentTimeMillis();
        this.habitData.setProperty(id, Long.toString(currentTimestamp));
    }

    private String getXMindID() {
        return this.account == null ? null : (String)this.account.getProperty("user");
    }

    private boolean isShowTime(ISiteEvent event) {
        String prompt = event.getPrompt();
        if (prompt == null || !prompt.contains("every")) {
            return true;
        }
        String id = event.getId();
        if (id == null || "".equals(id)) {
            return true;
        }
        String lastShowTime = this.habitData.getProperty(id, "");
        if ("".equals(lastShowTime)) {
            return true;
        }
        try {
            long interval = this.getShowInterval(prompt);
            long current = System.currentTimeMillis();
            long lastTime = Long.valueOf(lastShowTime);
            return current - lastTime > interval;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private long getShowInterval(String prompt) {
        try {
            int day = Integer.valueOf(prompt.replaceAll("every", ""));
            return day > 0 ? day * 1000 * 3600 * 24 : 0;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static void migrateLocalStoreFile() {
        File newLocalStoreFile = SiteEventNotificationService.getLocalStoreFile();
        if (newLocalStoreFile.exists()) {
            return;
        }
        Location instanceLocation = Platform.getInstanceLocation();
        if (instanceLocation == null) {
            return;
        }
        URL instanceURL = instanceLocation.getURL();
        if (instanceURL == null) {
            return;
        }
        try {
            instanceURL = FileLocator.toFileURL((URL)instanceURL);
        }
        catch (IOException iOException) {}
        File instanceDir = new File(instanceURL.getFile());
        if (!instanceDir.exists()) {
            return;
        }
        File oldLocalStoreFile = new File(new File(instanceDir, ".xmind"), LOCAL_STORE_FILE_NAME);
        if (oldLocalStoreFile.exists()) {
            SiteEventNotificationService.moveLocalStoreFile(oldLocalStoreFile, newLocalStoreFile);
            return;
        }
        oldLocalStoreFile = new File(instanceDir, LOCAL_STORE_FILE_NAME);
        if (oldLocalStoreFile.exists()) {
            SiteEventNotificationService.moveLocalStoreFile(oldLocalStoreFile, newLocalStoreFile);
            return;
        }
    }

    private static void moveLocalStoreFile(File oldFile, File newFile) {
        boolean moved;
        if (newFile.getParentFile() != null) {
            newFile.getParentFile().mkdirs();
        }
        if (!(moved = oldFile.renameTo(newFile))) {
            XMindNetWorkbench.getDefault().getLog().log((IStatus)new Status(2, "net.xmind.workbench", "Failed to migrate old site event local store file: " + oldFile.getAbsolutePath()));
        }
    }

    private void registerPartListener() {
        Display display = this.workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = SiteEventNotificationService.this.workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    SiteEventNotificationService.this.workbench.addWindowListener(new IWindowListener(){

                        public void windowOpened(IWorkbenchWindow window) {
                            SiteEventNotificationService.this.registerListenerWithWindow(window);
                        }

                        public void windowDeactivated(IWorkbenchWindow window) {
                        }

                        public void windowClosed(IWorkbenchWindow window) {
                            SiteEventNotificationService.this.unregisterListenerWithWindow(window);
                        }

                        public void windowActivated(IWorkbenchWindow window) {
                        }
                    });
                } else {
                    SiteEventNotificationService.this.registerListenerWithWindow(window);
                }
            }
        });
    }

    private void unregisterListenerWithWindow(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    private void registerListenerWithWindow(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.freeCreateOrOpenWorkbookCount();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    private void freeCreateOrOpenWorkbookCount() {
        boolean notification = false;
        ILicenseInfo licenseInfo = XMindNet.getLicenseInfo();
        this.parseLicenseInfo(licenseInfo);
        if ("free".equals(this.getAccountType())) {
            String path = XMindNetWorkbench.getStatePath(".freeCreateOrOpenWorkbookCount");
            File file = new File(path);
            Properties properties = null;
            if (file.exists()) {
                properties = SiteEventNotificationService.load(file);
                try {
                    Integer count = Integer.valueOf(properties.getProperty("count"));
                    Integer max = Integer.valueOf(properties.getProperty("max"));
                    count = count + 1;
                    if (count >= max) {
                        count = count - max;
                        max = max + 10;
                        notification = true;
                    }
                    properties.put("count", String.valueOf(count));
                    properties.put("max", String.valueOf(max));
                    SiteEventNotificationService.save(properties, file);
                }
                catch (NumberFormatException numberFormatException) {
                    properties = null;
                    file.delete();
                }
            }
            if (properties == null) {
                properties = new Properties();
                properties.put("count", "1");
                properties.put("max", "20");
                SiteEventNotificationService.save(properties, file);
            }
        }
        if (notification) {
            Properties props = new Properties();
            props.put("fur", "true");
            this.requestPromotion(props);
        }
    }

    private static Properties load(File file) {
        Properties repository = new Properties();
        if (file != null && file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                try {
                    repository.load(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return repository;
    }

    private static void save(Properties props, File file) {
        if (file != null) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                FileWriter writer = new FileWriter(file);
                try {
                    props.store(writer, "Generated by 'create or open workbook count'");
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class CheckSiteEventJob
    implements Runnable {
        private boolean startup;
        private Thread thread = null;
        private XMindNetRequest request = null;
        private Map<String, Object> toAppendParametes = new HashMap<String, Object>();

        public CheckSiteEventJob(boolean startup) {
            this.startup = startup;
        }

        public synchronized void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "CheckXMindSiteEvents");
            this.thread.setDaemon(true);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.request != null) {
                this.request.abort();
                this.request = null;
            }
        }

        public boolean isRunning() {
            return this.thread != null;
        }

        public void appendParameter(String key, Object value) {
            this.toAppendParametes.put(key, value);
        }

        public void run() {
            block15: {
                try {
                    this.request = new XMindNetRequest();
                    if (DEBUGGING) {
                        this.request.debug();
                    }
                    this.request.uri(LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/_api/events"));
                    this.request.addParameter("version", (Object)SiteEventNotificationService.this.productVersion);
                    String buildId = System.getProperty("org.xmind.product.buildid");
                    if (buildId != null && !"".equals(buildId)) {
                        this.request.addParameter("buildid", (Object)buildId);
                    }
                    this.request.addParameter("os", (Object)Platform.getOS());
                    this.request.addParameter("arch", (Object)Platform.getOSArch());
                    this.request.addParameter("nl", (Object)Platform.getNL());
                    this.request.addParameter("distrib", (Object)SiteEventNotificationService.getDistributionId());
                    this.request.addParameter("account_type", (Object)SiteEventNotificationService.this.getAccountType());
                    this.request.addParameter("license_info", (Object)(SiteEventNotificationService.this.licenseKeyHeader == null ? "" : SiteEventNotificationService.this.licenseKeyHeader.toEncoded()));
                    this.request.addParameter(FIRST_START_TIMESTAMP, (Object)SiteEventNotificationService.this.habitData.getProperty(FIRST_START_TIMESTAMP));
                    this.request.addParameter(START_TIMESTAMP_1, (Object)SiteEventNotificationService.this.habitData.getProperty(START_TIMESTAMP_1));
                    this.request.addParameter(START_TIMESTAMP_2, (Object)SiteEventNotificationService.this.habitData.getProperty(START_TIMESTAMP_2));
                    this.request.addParameter(START_TIMESTAMP_3, (Object)SiteEventNotificationService.this.habitData.getProperty(START_TIMESTAMP_3));
                    String xmindID = SiteEventNotificationService.this.getXMindID();
                    if (xmindID != null && !"".equals(xmindID)) {
                        this.request.addParameter("xmind_id", (Object)xmindID);
                    }
                    Set<String> keys = this.toAppendParametes.keySet();
                    for (String key : keys) {
                        this.request.addParameter(key, this.toAppendParametes.get(key));
                    }
                    this.request.get();
                    if (!this.isRunning() || this.request.isAborted()) {
                        return;
                    }
                    try {
                        int code = this.request.getStatusCode();
                        IDataStore data = this.request.getData();
                        if (code == 200) {
                            if (data != null) {
                                this.handleSiteEvents(data);
                            } else {
                                XMindNetWorkbench.log(this.request.getError(), "Failed to parse response of site events.");
                            }
                            break block15;
                        }
                        if (code == 999) {
                            XMindNetWorkbench.log(this.request.getError(), "Failed to connect to xmind.net for site events.");
                            break block15;
                        }
                        XMindNetWorkbench.log(this.request.getError(), "Failed to retrieve site events: " + code);
                    }
                    catch (Throwable e) {
                        XMindNetWorkbench.log(e, "Failed to retrieve XMind site events.");
                    }
                }
                finally {
                    this.request = null;
                }
            }
        }

        protected void handleSiteEvents(IDataStore data) {
            ArrayList<ISiteEvent> siteEvents = new ArrayList<ISiteEvent>();
            for (IDataStore siteData : data.getChildren("events")) {
                siteEvents.add(new DataStoreSiteEvent(siteData));
            }
            if (!this.isRunning()) {
                return;
            }
            SiteEventStore localStore = SiteEventNotificationService.this.getLocalEventStore();
            if (!this.isRunning()) {
                return;
            }
            List<ISiteEvent> newEvents = localStore.calcNewEvents(siteEvents, this.startup);
            if (!this.isRunning()) {
                return;
            }
            if (!newEvents.isEmpty()) {
                SiteEventNotificationService.this.showNotifications(newEvents);
            }
            if (!this.isRunning()) {
                return;
            }
            SiteEventNotificationService.this.setLocalEventStore(new SiteEventStore(siteEvents));
            if (!this.isRunning()) {
                return;
            }
            try {
                SiteEventNotificationService.this.saveLocalEventStore();
            }
            catch (IOException e) {
                XMindNetWorkbench.log(e, "Failed to save site events.");
            }
        }
    }

    private static class URLAction
    extends Action {
        private String url;
        private boolean openExternal;

        public URLAction(String text, String url, boolean openExternal) {
            super(text == null ? Messages.SiteEventNotificationService_View_text : text);
            this.url = url;
            this.openExternal = openExternal;
        }

        public void run() {
            XMindNet.gotoURL((boolean)this.openExternal, (String)this.url, (Object[])new Object[0]);
        }
    }
}

