/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.core.internal.AbstractWorkbookComponent;
import org.xmind.core.internal.dom.InternalHyperlinkUtils;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefImpl
extends AbstractWorkbookComponent
implements IResourceRef {
    private Element source;
    private Element implementation;
    private WorkbookImpl ownedWorkbook;

    public ResourceRefImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.source = implementation;
        this.implementation = implementation;
        this.ownedWorkbook = ownedWorkbook;
    }

    protected void setImplementation(Element implementation) {
        this.implementation = implementation;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public WorkbookImpl getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceRefImpl)) {
            return false;
        }
        ResourceRefImpl that = (ResourceRefImpl)obj;
        return this.source == that.source;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return "ResRef#" + this.getResourceId();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.implementation);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public Object getResource() {
        String type = this.getType();
        if ("file-entry".equals(type)) {
            return this.getFileEntry();
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook) {
        String type;
        if (workbook != null && "file-entry".equals(type = this.getType())) {
            InternalHyperlinkUtils.increaseFileEntryRef(workbook, this.getResourceId());
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        String type;
        if (workbook != null && "file-entry".equals(type = this.getType())) {
            InternalHyperlinkUtils.decreaseFileEntryRef(workbook, this.getResourceId());
        }
    }

    protected IFileEntry getFileEntry() {
        String entryPath = this.getResourceId();
        return this.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
    }

    protected IMarker getMarker() {
        String markerId = this.getResourceId();
        return this.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
    }

    protected IStyle getStyle() {
        String styleId = this.getResourceId();
        return this.getOwnedWorkbook().getStyleSheet().findStyle(styleId);
    }

    @Override
    public String getResourceId() {
        return DOMUtils.getAttribute(this.implementation, "resource-id");
    }

    @Override
    public String getType() {
        return DOMUtils.getAttribute(this.implementation, "type");
    }
}

