/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderEvent;
import org.xmind.ui.internal.iconfinder.IconfinderListener;
import org.xmind.ui.internal.iconfinder.Messages;

public class LoadingDialog
extends PopupDialog {
    private Rectangle aroundBounds = null;
    private IconfinderListener iconfinderListener;
    private String sessionId;

    public LoadingDialog(Shell parent, String sessionId) {
        super(parent, 8, true, false, false, false, false, null, null);
        this.sessionId = sessionId;
        this.iconfinderListener = new IconfinderListener(){

            @Override
            public void handlerIconfinderEvent(IconfinderEvent event) {
                LoadingDialog.this.handleIconfinderEvent(event);
            }
        };
        IconfinderCore.getInstance().addIconfinderListener(sessionId, this.iconfinderListener);
    }

    protected void handleIconfinderEvent(IconfinderEvent event) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label loadingStateLabel = new Label(composite, 0);
        loadingStateLabel.setText(Messages.Iconfinder_LoadingState_label);
        loadingStateLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    public int open(Rectangle aroundBounds) {
        this.aroundBounds = aroundBounds;
        return super.open();
    }

    public int open(Point location) {
        if (location != null) {
            this.aroundBounds = new Rectangle(location.x, location.y, 1, 1);
        }
        return super.open();
    }

    private Point calcLocation(Rectangle aroundBounds, Point shellSize) {
        Point loc = new Point(aroundBounds.x, aroundBounds.y);
        Rectangle area = this.getShell().getDisplay().getClientArea();
        if (aroundBounds.x + shellSize.x > area.x + area.width) {
            loc.x = aroundBounds.x + aroundBounds.width - shellSize.x;
        }
        loc.y = aroundBounds.y + aroundBounds.height + shellSize.y > area.y + area.height ? aroundBounds.y - shellSize.y : aroundBounds.y + aroundBounds.height;
        return loc;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.aroundBounds != null) {
            return this.calcLocation(this.aroundBounds, initialSize);
        }
        return super.getInitialLocation(initialSize);
    }

    public boolean close() {
        IconfinderCore.getInstance().removeIconfinderListener(this.sessionId, this.iconfinderListener);
        return super.close();
    }

    protected Color getBackground() {
        return Display.getCurrent().getSystemColor(1);
    }
}

