/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.brainstorm.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyboardListenerService
extends GraphicalViewerService
implements Listener {
    private static final String CMD_SAVE = "org.eclipse.ui.file.save";
    private static final String CMD_UNDO = "org.eclipse.ui.edit.undo";
    private static final String CMD_REDO = "org.eclipse.ui.edit.redo";
    private static final String CMD_CUT = "org.eclipse.ui.edit.cut";
    private static final String CMD_COPY = "org.eclipse.ui.edit.copy";
    private static final String CMD_PASTE = "org.eclipse.ui.edit.paste";
    private static final String CMD_DELETE = "org.eclipse.ui.edit.delete";
    private static final String CMD_SELLECT_ALL = "org.eclipse.ui.edit.selectAll";
    private static final String CMD_EDIT_TITLE = "org.xmind.ui.command.editTitle";
    private static final String CMD_EDIT_LABEL = "org.xmind.ui.command.editLabel";
    private static final String CMD_EDIT_NOTES = "org.xmind.ui.command.editNotes";
    private static final String CMD_INSERT_TOPIC = "org.xmind.ui.command.insertTopic";
    private static final String CMD_INSERT_SUBTOPIC = "org.xmind.ui.command.insertSubtopic";
    private static final String CMD_INSERT_BEFORE = "org.xmind.ui.command.insertTopicBefore";
    private static final String CMD_INSERT_PARENT = "org.xmind.ui.command.insertParentTopic";
    private static final String CMD_INSERT_IMAGE = "org.xmind.ui.command.insertImage";
    private static final String CMD_INSERT_RELATIONSHIP = "org.xmind.ui.command.createRelationship";
    private static final String CMD_INSERT_BOUNDARY = "org.xmind.ui.command.createBoundary";
    private static final String CMD_INSERT_SUMMARY = "org.xmind.ui.command.createSummary";
    private static final String CMD_INSERT_HREF = "org.xmind.ui.command.hyperlink";
    private static final String CMD_DRILL_DOWN = "org.xmind.ui.command.drillDown";
    private static final String CMD_DRILL_UP = "org.xmind.ui.command.drillUp";
    private static final String CMD_ZOOM_IN = "org.xmind.ui.command.zoomIn";
    private static final String CMD_ZOOM_OUT = "org.xmind.ui.command.zoomOut";
    private static final String CMD_ACTUAL_SIZE = "org.xmind.ui.command.actualSize";
    private static final String CMD_COLLAPSE_ALL = "org.xmind.ui.command.collapseAll";
    private static final String CMD_EXTEND_ALL = "org.xmind.ui.command.extendAll";
    private static final String CMD_SELECT_BROTHERS = "org.xmind.ui.command.selectBrothers";
    private static final String CMD_SELECT_CHILDREN = "org.xmind.ui.command.selectChildren";
    private static final String CMD_GO_HOME = "org.xmind.ui.command.goHome";
    private IGraphicalViewer viewer;
    private Display display;
    private Map<TriggerSequence, String> keyBindings;
    private Map<String, IAction> actionHandlers = new HashMap<String, IAction>(33);
    private List<TriggerSequence> currentSequences = null;
    private IActionRegistry actionRegistry;
    private int nextKeyIndex = -1;
    private boolean keysActive = false;

    public KeyboardListenerService(IGraphicalViewer viewer, Map<TriggerSequence, String> keyBindins) {
        super(viewer);
        this.viewer = viewer;
        this.keyBindings = keyBindins;
    }

    protected void activate() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.addListener(15, (Listener)this);
            control.addListener(16, (Listener)this);
        }
        this.display = this.viewer.getControl().getDisplay();
        this.display.addFilter(1, (Listener)this);
        this.keysActive = control != null && !control.isDisposed() && control.isFocusControl();
        this.registerCommands();
    }

    protected void deactivate() {
        Control control;
        if (this.display != null) {
            this.display.removeFilter(1, (Listener)this);
            this.display = null;
        }
        if ((control = this.viewer.getControl()) != null && !control.isDisposed()) {
            control.removeListener(15, (Listener)this);
            control.removeListener(16, (Listener)this);
        }
    }

    public void dispose() {
        this.actionHandlers.clear();
        super.dispose();
    }

    private void registerCommands() {
        this.actionRegistry = (IActionRegistry)this.getViewer().getAdapter(IActionRegistry.class);
        this.activateHandler(ActionFactory.SAVE.getId(), CMD_SAVE);
        this.activateHandler(ActionFactory.UNDO.getId(), CMD_UNDO);
        this.activateHandler(ActionFactory.REDO.getId(), CMD_REDO);
        this.activateHandler(ActionFactory.CUT.getId(), CMD_CUT);
        this.activateHandler(ActionFactory.COPY.getId(), CMD_COPY);
        this.activateHandler(ActionFactory.PASTE.getId(), CMD_PASTE);
        this.activateHandler(ActionFactory.DELETE.getId(), CMD_DELETE);
        this.activateHandler(ActionFactory.SELECT_ALL.getId(), CMD_SELLECT_ALL);
        this.activateHandler(MindMapActionFactory.EDIT_TITLE.getId(), CMD_EDIT_TITLE);
        this.activateHandler(MindMapActionFactory.EDIT_LABEL.getId(), CMD_EDIT_LABEL);
        this.activateHandler(MindMapActionFactory.EDIT_NOTES.getId(), CMD_EDIT_NOTES);
        this.activateHandler(MindMapActionFactory.INSERT_TOPIC.getId(), CMD_INSERT_TOPIC);
        this.activateHandler(MindMapActionFactory.INSERT_SUBTOPIC.getId(), CMD_INSERT_SUBTOPIC);
        this.activateHandler(MindMapActionFactory.INSERT_TOPIC_BEFORE.getId(), CMD_INSERT_BEFORE);
        this.activateHandler(MindMapActionFactory.INSERT_PARENT_TOPIC.getId(), CMD_INSERT_PARENT);
        this.activateHandler(MindMapActionFactory.INSERT_IMAGE.getId(), CMD_INSERT_IMAGE);
        this.activateHandler(MindMapActionFactory.CREATE_RELATIONSHIP.getId(), CMD_INSERT_RELATIONSHIP);
        this.activateHandler(MindMapActionFactory.CREATE_BOUNDARY.getId(), CMD_INSERT_BOUNDARY);
        this.activateHandler(MindMapActionFactory.CREATE_SUMMARY.getId(), CMD_INSERT_SUMMARY);
        this.activateHandler(MindMapActionFactory.MODIFY_HYPERLINK.getId(), CMD_INSERT_HREF);
        this.activateHandler(MindMapActionFactory.DRILL_DOWN.getId(), CMD_DRILL_DOWN);
        this.activateHandler(MindMapActionFactory.DRILL_UP.getId(), CMD_DRILL_UP);
        this.activateHandler(MindMapActionFactory.ZOOM_IN.getId(), CMD_ZOOM_IN);
        this.activateHandler(MindMapActionFactory.ZOOM_OUT.getId(), CMD_ZOOM_OUT);
        this.activateHandler(MindMapActionFactory.ACTUAL_SIZE.getId(), CMD_ACTUAL_SIZE);
        this.activateHandler(MindMapActionFactory.COLLAPSE_ALL.getId(), CMD_COLLAPSE_ALL);
        this.activateHandler(MindMapActionFactory.EXTEND_ALL.getId(), CMD_EXTEND_ALL);
        this.activateHandler(MindMapActionFactory.SELECT_BROTHERS.getId(), CMD_SELECT_BROTHERS);
        this.activateHandler(MindMapActionFactory.SELECT_CHILDREN.getId(), CMD_SELECT_CHILDREN);
        this.activateHandler(MindMapActionFactory.GO_HOME.getId(), CMD_GO_HOME);
    }

    private void activateHandler(String actionId, String commandId) {
        IAction action = this.actionRegistry.getAction(actionId);
        if (action == null) {
            Activator.log(2, "Action not found: " + actionId);
            return;
        }
        action.setActionDefinitionId(commandId);
        this.actionHandlers.put(commandId, action);
    }

    public void handleEvent(Event event) {
        if (event.type == 1) {
            this.handleKeyDown(event);
        } else if (event.type == 15) {
            this.keysActive = true;
        } else if (event.type == 16) {
            this.keysActive = false;
        }
    }

    private void handleKeyDown(Event event) {
        if (!this.keysActive) {
            return;
        }
        if (this.keyBindings.isEmpty()) {
            return;
        }
        List<KeyStroke> keys = this.generateKeyStrokes(event);
        if (this.currentSequences == null) {
            this.nextKeyIndex = -1;
            for (TriggerSequence ts : this.keyBindings.keySet()) {
                if (!this.matches(keys, ts.getTriggers()[0])) continue;
                if (this.currentSequences == null) {
                    this.currentSequences = new ArrayList<TriggerSequence>(this.keyBindings.size());
                }
                this.currentSequences.add(ts);
            }
            if (this.currentSequences == null) {
                return;
            }
        }
        if (this.nextKeyIndex < 0) {
            this.nextKeyIndex = 0;
        }
        Iterator<TriggerSequence> it = this.currentSequences.iterator();
        while (it.hasNext()) {
            TriggerSequence ts = it.next();
            Trigger[] triggers = ts.getTriggers();
            if (this.nextKeyIndex >= triggers.length) {
                it.remove();
                continue;
            }
            if (this.matches(keys, triggers[this.nextKeyIndex])) {
                if (this.nextKeyIndex != triggers.length - 1) continue;
                if (this.triggerFound(ts)) {
                    event.doit = false;
                    event.type = 0;
                }
                return;
            }
            it.remove();
        }
        if (this.currentSequences != null && this.currentSequences.isEmpty()) {
            ++this.nextKeyIndex;
        } else {
            this.currentSequences = null;
            this.nextKeyIndex = -1;
        }
    }

    private boolean triggerFound(TriggerSequence triggerSequence) {
        this.currentSequences = null;
        this.nextKeyIndex = -1;
        String commandId = this.keyBindings.get(triggerSequence);
        if (commandId != null) {
            return this.handleCommand(commandId);
        }
        return false;
    }

    private boolean handleCommand(String commandId) {
        if (this.actionHandlers == null) {
            return false;
        }
        IAction action = this.actionHandlers.get(commandId);
        if (action != null && action.isEnabled()) {
            action.run();
            return true;
        }
        return false;
    }

    private boolean matches(List<KeyStroke> keys, Trigger expected) {
        for (KeyStroke key : keys) {
            if (!key.equals((Object)expected)) continue;
            return true;
        }
        return false;
    }

    private List<KeyStroke> generateKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
        }
        return keyStrokes;
    }

    public static Map<TriggerSequence, String> collectKeyBindings(IBindingService bs) {
        HashMap<TriggerSequence, String> map = new HashMap<TriggerSequence, String>(33);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_SAVE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_UNDO);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_REDO);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_CUT);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_COPY);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_PASTE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_DELETE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_SELLECT_ALL);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_EDIT_TITLE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_EDIT_LABEL);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_EDIT_NOTES);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_TOPIC);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_SUBTOPIC);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_BEFORE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_PARENT);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_IMAGE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_RELATIONSHIP);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_BOUNDARY);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_SUMMARY);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_INSERT_HREF);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_DRILL_DOWN);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_DRILL_UP);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_ZOOM_IN);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_ZOOM_OUT);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_ACTUAL_SIZE);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_EXTEND_ALL);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_COLLAPSE_ALL);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_SELECT_BROTHERS);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_SELECT_CHILDREN);
        KeyboardListenerService.addKeyBinding(bs, map, CMD_GO_HOME);
        return map;
    }

    private static void addKeyBinding(IBindingService bs, Map<TriggerSequence, String> map, String command) {
        TriggerSequence key = bs.getBestActiveBindingFor(command);
        if (key != null) {
            map.put(key, command);
        }
    }
}

