/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.notes.NotesPopup;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class EditTopicNotesAction
extends Action
implements ISelectionAction {
    private IGraphicalViewer viewer;

    public EditTopicNotesAction(IGraphicalViewer viewer) {
        this.viewer = viewer;
        this.setId(MindMapActionFactory.EDIT_NOTES.getId());
        this.setText(MindMapMessages.EditNotes_text);
        this.setImageDescriptor(MindMapUI.getImages().get("notes.png", true));
        this.setDisabledImageDescriptor(MindMapUI.getImages().get("notes.png", false));
        this.setActionDefinitionId("org.xmind.ui.command.editNotes");
    }

    public void run() {
        if (this.viewer == null) {
            return;
        }
        ITopicPart topicPart = this.getSelectionTopicPart();
        if (topicPart == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UseNotesCount");
        NotesPopup popup = new NotesPopup(window, topicPart, true, false);
        popup.open();
    }

    private ITopicPart getSelectionTopicPart() {
        Object o;
        IPart part;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (part = this.viewer.findPart(o = ((IStructuredSelection)selection).getFirstElement())) instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic((ISelection)selection));
    }
}

