/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ITopic;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.RelationshipDescription;

public class ExportUtils {
    static final List<RelationshipDescription> EMPTY_RELATIONSHIPS = Collections.emptyList();

    private ExportUtils() {
    }

    public static String getNumberingText(ITopic topic, ITopic centralTopic) {
        return MindMapUtils.getFullNumberingText(topic, null, null);
    }

    public static List<RelationshipDescription> getRelationships(ITopic topic, List<IRelationship> relationships) {
        String topicId = topic.getId();
        ArrayList<RelationshipDescription> list = null;
        for (IRelationship r : relationships) {
            IRelationshipEnd otherEnd;
            boolean isEnd1 = topicId.equals(r.getEnd1Id());
            if (!isEnd1 && !topicId.equals(r.getEnd2Id())) continue;
            IRelationshipEnd iRelationshipEnd = otherEnd = isEnd1 ? r.getEnd2() : r.getEnd1();
            if (!(otherEnd instanceof ITopic)) continue;
            String title = ((ITopic)otherEnd).getTitleText();
            if (r.hasTitle()) {
                title = NLS.bind((String)"{0} ({1})", (Object)title, (Object)r.getTitleText());
            }
            if (list == null) {
                list = new ArrayList<RelationshipDescription>();
            }
            list.add(new RelationshipDescription(r, (IRelationshipEnd)topic, otherEnd, title));
        }
        return list == null ? EMPTY_RELATIONSHIPS : list;
    }
}

