/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.util.ImageFormat;

public class ThemeFigure
extends Figure {
    private static final Rectangle RECT = new Rectangle();
    private IStyle theme = null;
    private Image defaultImage = null;

    public IStyle getTheme() {
        return this.theme;
    }

    public void setTheme(IStyle theme) {
        if (theme == this.theme) {
            return;
        }
        this.theme = theme;
        this.repaint();
    }

    public Image getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(Image defaultImage) {
        if (defaultImage == this.defaultImage) {
            return;
        }
        this.defaultImage = defaultImage;
        this.repaint();
    }

    public Image getPreviewImage(IStyle theme) {
        return this.getImageFromSource(theme, new Rectangle(0, 0, 200, 100));
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawTheme(graphics);
    }

    protected void drawTheme(Graphics graphics) {
        if (this.theme == null) {
            return;
        }
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        Rectangle r = this.getClientArea(RECT);
        this.drawTheme(graphics, this.theme, r);
    }

    protected void drawTheme(Graphics graphics, IStyle theme, Rectangle r) {
        Image image = this.getImageFromSource(theme, r);
        if (image != null) {
            graphics.drawImage(image, r.x, r.y);
        }
        if (this.defaultImage != null) {
            graphics.drawImage(this.defaultImage, r.x + 1, r.y + 1);
        }
    }

    private Image getImageFromSource(IStyle theme, Rectangle r) {
        if (this.theme != theme) {
            this.theme = theme;
        }
        File root = MindMapUIPlugin.getDefault().getStateLocation().toFile();
        root = new File(root, ".themePreview");
        String id = theme.getId();
        File dir = new File(root, id);
        String previewName = "preview" + r.width + ".bmp";
        String[] list = dir.list();
        if (list == null || !Arrays.asList(list).contains(previewName)) {
            ThemePreview themePreview = new ThemePreview(theme);
            themePreview.createPreviewImage(r.width, r.height, previewName);
        }
        File preview = new File(dir, previewName);
        return new Image((Device)Display.getCurrent(), preview.getAbsolutePath());
    }

    private class ThemePreview {
        private IWorkbook previewWorkbook;
        private IStorage previewStorage;
        private File previewFile;

        public ThemePreview(IStyle theme) {
            this.initPreviewStorage();
            this.initPreview();
        }

        private void initPreviewStorage() {
            File root = MindMapUIPlugin.getDefault().getStateLocation().toFile();
            this.previewFile = new File(root, ".themePreview");
            File dir = new File(this.previewFile, UUID.randomUUID().toString());
            dir.mkdirs();
            this.previewStorage = new DirectoryStorage(dir);
            this.previewWorkbook = Core.getWorkbookBuilder().createWorkbook(this.previewStorage);
        }

        private void initPreview() {
            ISheet sheet = this.previewWorkbook.getPrimarySheet();
            this.createPreviewContents(this.previewWorkbook, sheet);
        }

        private void createPreviewContents(IWorkbook workbook, ISheet sheet) {
            IStyleSheet styleSheet = workbook.getStyleSheet();
            IStyle importStyle = styleSheet.importStyle(ThemeFigure.this.theme);
            if (importStyle != null) {
                sheet.setThemeId(importStyle.getId());
            }
            ITopic rootTopic = sheet.getRootTopic();
            rootTopic.setTitleText(MindMapMessages.TitleText_CentralTopic);
            rootTopic.setStructureClass("org.xmind.ui.map.clockwise");
            ITopic mainTopic1 = workbook.createTopic();
            mainTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)1));
            rootTopic.add(mainTopic1);
            ITopic subTopic1 = workbook.createTopic();
            subTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)1));
            mainTopic1.add(subTopic1);
            ITopic subTopic2 = workbook.createTopic();
            subTopic2.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)2));
            mainTopic1.add(subTopic2);
            ITopic subTopic3 = workbook.createTopic();
            subTopic3.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)3));
            mainTopic1.add(subTopic3);
            ITopic floatingTopic = workbook.createTopic();
            floatingTopic.setTitleText(MindMapMessages.TitleText_FloatingTopic);
            floatingTopic.setPosition(0, -120);
            rootTopic.add(floatingTopic, "detached");
            IBoundary boundary = workbook.createBoundary();
            boundary.setTitleText(MindMapMessages.TitleText_Boundary);
            boundary.setStartIndex(0);
            boundary.setEndIndex(0);
            rootTopic.addBoundary(boundary);
            IRelationship relationship = workbook.createRelationship();
            relationship.setTitleText(MindMapMessages.TitleText_Relationship);
            relationship.setEnd1Id(mainTopic1.getId());
            relationship.setEnd2Id(floatingTopic.getId());
            IControlPoint cp1 = relationship.getControlPoint(0);
            cp1.setPosition(50, -100);
            IControlPoint cp2 = relationship.getControlPoint(1);
            cp2.setPosition(100, 0);
            sheet.addRelationship(relationship);
        }

        public void createPreviewImage(int wHint, int hHint, String fileName) {
            block17: {
                MindMapImageExporter exporter = new MindMapImageExporter(Display.getCurrent());
                exporter.setSource(new MindMap(this.previewWorkbook.getPrimarySheet()), null, null);
                exporter.setTargetWorkbook(this.previewWorkbook);
                Image image = exporter.createImage();
                int width = image.getBounds().width;
                int height = image.getBounds().height;
                float scale = (float)height * 1.0f / (float)width * 1.0f / ((float)hHint * 1.0f / (float)wHint * 1.0f);
                if ((double)scale > 1.0) {
                    hHint = (int)(scale * (float)hHint);
                } else {
                    wHint = (int)((float)wHint / scale);
                }
                if (image != null) {
                    image.dispose();
                    image = null;
                }
                MindMapImageExporter exp = new MindMapImageExporter(Display.getCurrent());
                exp.setSource(new MindMap(this.previewWorkbook.getPrimarySheet()), null, null);
                exp.setTargetWorkbook(this.previewWorkbook);
                exp.setResize(4, wHint, hHint);
                image = exp.createImage();
                String id = ThemeFigure.this.theme.getId();
                File dir = new File(this.previewFile, id);
                dir.mkdirs();
                File preview = new File(dir, fileName);
                FileOutputStream output = null;
                try {
                    try {
                        output = new FileOutputStream(preview);
                        ImageExportUtils.saveImage((Image)image, (OutputStream)output, (int)ImageFormat.BMP.getSWTFormat());
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        if (image != null) {
                            image.dispose();
                            image = null;
                        }
                        try {
                            ((OutputStream)output).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        image.dispose();
                        image = null;
                    }
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                if (image != null) {
                    image.dispose();
                    image = null;
                }
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.clear();
        }

        private void clear() {
            if (this.previewStorage != null) {
                this.previewStorage.clear();
                this.previewStorage = null;
            }
        }
    }
}

