/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.views.AttachmentsInspectorSection;
import org.xmind.ui.internal.views.AuthorInfoInspectorSection;
import org.xmind.ui.internal.views.ExternalFilesInspectorSection;
import org.xmind.ui.internal.views.FileInfoInspectorSection;
import org.xmind.ui.internal.views.HyperlinkInspectorSection;
import org.xmind.ui.internal.views.ImageInspectorSection;
import org.xmind.ui.internal.views.InspectorViewer;

public class InspectorView
extends ViewPart
implements IContributedContentsView,
IPartListener,
IPageChangedListener {
    private IGraphicalEditor contributingPart;
    private Composite container;
    private Composite contentsPage;
    private InspectorViewer viewer;

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.container.setLayout((Layout)layout);
        this.createContentsPage(this.container);
        this.showPage(this.contentsPage);
        if (this.getSite().getPage() != null && this.getSite().getPage().getActivePart() == this) {
            this.setFocus();
        }
    }

    private void createContentsPage(Composite parent) {
        this.contentsPage = new Composite(parent, 0);
        this.contentsPage.setLayout((Layout)new FillLayout());
        this.doCreatePartControl(this.contentsPage);
    }

    private void showPage(Composite page) {
        if (page == null || page.isDisposed()) {
            return;
        }
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        ((StackLayout)this.container.getLayout()).topControl = page;
        this.container.layout();
    }

    private void doCreatePartControl(Composite parent) {
        this.viewer = new InspectorViewer();
        this.viewer.addSection(new AuthorInfoInspectorSection());
        this.viewer.addSection(new AttachmentsInspectorSection());
        this.viewer.addSection(new ExternalFilesInspectorSection());
        this.viewer.addSection(new HyperlinkInspectorSection());
        this.viewer.addSection(new ImageInspectorSection());
        this.viewer.addSection(new FileInfoInspectorSection());
        this.viewer.createControl(parent);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.partActivated(this.getSite().getPage().getActivePart());
    }

    public void dispose() {
        this.setContributingPart(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingPart;
    }

    private void setContributingPart(IGraphicalEditor part) {
        if (this.contributingPart != null) {
            this.contributingPart.removePageChangedListener((IPageChangedListener)this);
        }
        this.contributingPart = part;
        if (this.viewer != null) {
            this.viewer.setContributingViewer(this.getContributingViewer(part));
        }
        if (part != null) {
            part.addPageChangedListener((IPageChangedListener)this);
        }
    }

    private IGraphicalViewer getContributingViewer(IGraphicalEditor editor) {
        IGraphicalEditorPage page;
        if (editor != null && (page = editor.getActivePageInstance()) != null) {
            return page.getViewer();
        }
        return null;
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IGraphicalEditor) {
            this.setContributingPart((IGraphicalEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingPart) {
            this.setContributingPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        if (this.viewer != null) {
            this.viewer.setContributingViewer(this.getContributingViewer(this.contributingPart));
        }
    }
}

