/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.actions.assistant.AbstractAssistantPage;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.util.grid.GridAlignmentHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.DimensionsProperty;
import org.eclipse.wb.internal.swing.MigLayout.model.IPreferenceConstants;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutConverter;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.MigLayout.model.SelectionActionsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.CellConstraintsAssistantPage;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ColumnsDialog;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.RowsDialog;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutAssistantSupport;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayoutInfo
extends LayoutInfo
implements IPreferenceConstants {
    private final List<MigColumnInfo> m_columns = Lists.newArrayList();
    private final List<MigRowInfo> m_rows = Lists.newArrayList();
    private final Map<ComponentInfo, CellConstraintsSupport> m_constraints = Maps.newHashMap();
    private IGridInfo m_gridInfo;
    private final int m_defaultColumnSize = 25;
    private final int m_gapColumnSize = 4;
    private final int m_defaultRowSize = 25;
    private final int m_gapRowSize = 4;
    public static final BiMap<GeneralLayoutData.HorizontalAlignment, MigColumnInfo.Alignment> m_horizontalAlignmentMap = ImmutableBiMap.of((Object)GeneralLayoutData.HorizontalAlignment.LEFT, (Object)((Object)MigColumnInfo.Alignment.LEFT), (Object)GeneralLayoutData.HorizontalAlignment.CENTER, (Object)((Object)MigColumnInfo.Alignment.CENTER), (Object)GeneralLayoutData.HorizontalAlignment.RIGHT, (Object)((Object)MigColumnInfo.Alignment.RIGHT), (Object)GeneralLayoutData.HorizontalAlignment.FILL, (Object)((Object)MigColumnInfo.Alignment.FILL), (Object)GeneralLayoutData.HorizontalAlignment.NONE, (Object)((Object)MigColumnInfo.Alignment.UNKNOWN));
    public static final BiMap<GeneralLayoutData.VerticalAlignment, MigRowInfo.Alignment> m_verticalAlignmentMap = ImmutableBiMap.of((Object)GeneralLayoutData.VerticalAlignment.TOP, (Object)((Object)MigRowInfo.Alignment.TOP), (Object)GeneralLayoutData.VerticalAlignment.CENTER, (Object)((Object)MigRowInfo.Alignment.CENTER), (Object)GeneralLayoutData.VerticalAlignment.BOTTOM, (Object)((Object)MigRowInfo.Alignment.BOTTOM), (Object)GeneralLayoutData.VerticalAlignment.FILL, (Object)((Object)MigRowInfo.Alignment.FILL), (Object)GeneralLayoutData.VerticalAlignment.NONE, (Object)((Object)MigRowInfo.Alignment.UNKNOWN));
    private static final int DOCK_INDEX = 30000;

    public MigLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        ExecutionUtils.runDesignTime((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                IDEUtil.LEFT.toString();
            }
        });
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.initializeMigLayoutGridAfterParse();
        new SelectionActionsSupport(this);
        new LayoutAssistantSupport(this){

            protected AbstractAssistantPage createConstraintsPage(Composite parent, List<ObjectInfo> objects) {
                return new CellConstraintsAssistantPage(parent, MigLayoutInfo.this, objects);
            }
        };
        this.addContextMenuActions();
        this.addConstraintsProperty();
        this.addSplitFlowDirectionListener();
    }

    private void initializeMigLayoutGridAfterParse() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                MigLayoutInfo.this.removeBroadcastListener(this);
                if (MigLayoutInfo.this.isActive()) {
                    try {
                        MigLayoutInfo.this.getContainer().getContainer().doLayout();
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            }
        });
    }

    private void addContextMenuActions() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                MigLayoutInfo.this.addContextMenuActions(object, manager);
            }
        });
    }

    private void addConstraintsProperty() {
        this.addBroadcastListener(new JavaInfoAddProperties(){

            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                if (MigLayoutInfo.this.isManagedObject(javaInfo)) {
                    ComponentInfo component = (ComponentInfo)javaInfo;
                    CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
                    properties.add((Property)constraints.getCellProperty());
                }
            }
        });
    }

    private void addSplitFlowDirectionListener() {
        this.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (MigLayoutInfo.this.isManagedObject(child)) {
                    ComponentInfo component = (ComponentInfo)child;
                    MigLayoutInfo.this.updateSplitFlowDirection(component);
                }
            }
        });
        this.addBroadcastListener(new JavaEventListener(){

            public void moveBefore(JavaInfo child, ObjectInfo oldParent, JavaInfo newParent) throws Exception {
                if (MigLayoutInfo.this.isManagedObject(child)) {
                    ComponentInfo component = (ComponentInfo)child;
                    MigLayoutInfo.this.updateSplitFlowDirection(component);
                }
            }
        });
    }

    private void updateSplitFlowDirection(ComponentInfo component) throws Exception {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        List<ComponentInfo> cellComponents = this.getCellComponents(component);
        if (cellComponents.size() > 1 && cellComponents.get(0) == component) {
            boolean horizontalSplit = constraints.isHorizontalSplit();
            constraints.setHorizontalSplit(null);
            constraints.write();
            if (cellComponents.size() > 2) {
                ComponentInfo nextComponent = cellComponents.get(1);
                CellConstraintsSupport nextConstraints = MigLayoutInfo.getConstraints(nextComponent);
                nextConstraints.setHorizontalSplit(horizontalSplit);
                nextConstraints.write();
            }
        }
    }

    LC getLC() {
        MigLayout layout = (MigLayout)this.getObject();
        Object layoutConstraints = layout.getLayoutConstraints();
        if (layoutConstraints instanceof LC) {
            return (LC)layoutConstraints;
        }
        return ConstraintParser.parseLayoutConstraint((String)((String)layoutConstraints));
    }

    private void addContextMenuActions(ObjectInfo object, IMenuManager manager) throws Exception {
        if (object == this.getContainer()) {
            manager.appendToGroup("org.eclipse.wb.popup.group.top", (IAction)new EditDimensionsAction(ModelMessages.MigLayoutInfo_editColumns, true));
            manager.appendToGroup("org.eclipse.wb.popup.group.top", (IAction)new EditDimensionsAction(ModelMessages.MigLayoutInfo_editRows, false));
        }
        if (object instanceof ComponentInfo && object.getParent() == this.getContainer()) {
            ComponentInfo component = (ComponentInfo)object;
            CellConstraintsSupport support = MigLayoutInfo.getConstraints(component);
            support.addContextMenu(manager);
        }
    }

    public List<MigColumnInfo> getColumns() {
        return this.m_columns;
    }

    public List<MigRowInfo> getRows() {
        return this.m_rows;
    }

    public void setColumns(List<MigColumnInfo> columns) throws Exception {
        this.m_columns.clear();
        this.m_columns.addAll(columns);
        this.writeDimensions();
    }

    public void setRows(List<MigRowInfo> rows) throws Exception {
        this.m_rows.clear();
        this.m_rows.addAll(rows);
        this.writeDimensions();
    }

    private void updateColumnsRows() throws Exception {
        int columnCount = this.getGridInfo().getColumnCount();
        if (this.m_columns.size() != columnCount) {
            this.m_columns.clear();
            int i = 0;
            while (i < columnCount) {
                this.m_columns.add(new MigColumnInfo(this));
                ++i;
            }
        }
        for (MigColumnInfo column : this.m_columns) {
            column.updateConstraint();
        }
        int rowCount = this.getGridInfo().getRowCount();
        if (this.m_rows.size() != rowCount) {
            this.m_rows.clear();
            int i = 0;
            while (i < rowCount) {
                this.m_rows.add(new MigRowInfo(this));
                ++i;
            }
        }
        for (MigRowInfo row : this.m_rows) {
            row.updateConstraint();
        }
    }

    public void normalizeSpanning() throws Exception {
        boolean columnRowDeleted = true;
        block0: while (columnRowDeleted) {
            columnRowDeleted = false;
            final boolean[] filledColumns = new boolean[this.m_columns.size()];
            final boolean[] filledRows = new boolean[this.m_rows.size()];
            this.visitGridComponents(new MigComponentVisitor(){

                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    filledColumns[constraints.getX()] = true;
                    filledRows[constraints.getY()] = true;
                }
            });
            int column = filledColumns.length - 1;
            while (column >= 0) {
                if (!filledColumns[column]) {
                    this.deleteColumn(column);
                    columnRowDeleted = true;
                    break;
                }
                --column;
            }
            int row = filledRows.length - 1;
            while (row >= 0) {
                if (!filledRows[row]) {
                    this.deleteRow(row);
                    columnRowDeleted = true;
                    continue block0;
                }
                --row;
            }
        }
        this.writeDimensions();
    }

    public boolean canChangeDimensions() {
        return this.getCreationSupport() instanceof ConstructorCreationSupport;
    }

    public void writeDimensions() throws Exception {
        MigLayout layout = (MigLayout)this.getObject();
        Object layoutConstraints = layout.getLayoutConstraints();
        String layoutConstraintsString = layoutConstraints instanceof LC ? IDEUtil.getConstraintString((LC)((LC)layoutConstraints), (boolean)false) : (String)layoutConstraints;
        String layoutConstraintsSource = StringConverter.INSTANCE.toJavaSource((JavaInfo)this, (Object)layoutConstraintsString);
        String columnsSource = MigLayoutInfo.getDimensionsSource(this.m_columns, true);
        String rowsSource = MigLayoutInfo.getDimensionsSource(this.m_rows, false);
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.getCreationSupport();
        ClassInstanceCreation creation = creationSupport.getCreation();
        this.getEditor().replaceCreationArguments(creation, (List)ImmutableList.of((Object)MessageFormat.format("{0}, {1}, {2}", layoutConstraintsSource, columnsSource, rowsSource)));
        this.setCreationSupport((CreationSupport)new ConstructorCreationSupport(creation));
    }

    private static String getDimensionsSource(List<? extends MigDimensionInfo> dimensions, boolean cols) throws Exception {
        DimConstraint[] constraints = new DimConstraint[dimensions.size()];
        int i = 0;
        while (i < dimensions.size()) {
            constraints[i] = dimensions.get((int)i).m_constraint;
            ++i;
        }
        AC ac = new AC();
        ac.setConstaints(constraints);
        String constraintString = IDEUtil.getConstraintString((AC)ac, (boolean)false, (boolean)cols);
        return StringConverter.INSTANCE.toJavaSource(null, (Object)constraintString);
    }

    protected List<Property> getPropertyList() throws Exception {
        List properties = super.getPropertyList();
        properties.add(new DimensionsProperty(this, true));
        properties.add(new DimensionsProperty(this, false));
        return properties;
    }

    public static CellConstraintsSupport getConstraints(ComponentInfo component) {
        ContainerInfo container = (ContainerInfo)component.getParent();
        Assert.isTrue((boolean)container.getChildrenComponents().contains(component));
        Assert.instanceOf(MigLayoutInfo.class, (Object)container.getLayout());
        MigLayoutInfo layout = (MigLayoutInfo)container.getLayout();
        CellConstraintsSupport support = layout.m_constraints.get(component);
        if (support == null) {
            support = new CellConstraintsSupport(layout, component);
            layout.m_constraints.put(component, support);
        }
        return support;
    }

    public void onSet() throws Exception {
        super.onSet();
        MigLayoutConverter.convert(this.getContainer(), this);
    }

    public void insertColumn(int targetIndex) throws Exception {
        this.moveComponentsForInsert(targetIndex, true, -1, false);
        this.m_columns.add(targetIndex, new MigColumnInfo(this));
        this.writeDimensions();
    }

    public void deleteColumn(int index) throws Exception {
        this.moveComponentsForDelete(index, true, -1, false);
        this.m_columns.remove(index);
        this.writeDimensions();
    }

    public void clearColumn(final int index) throws Exception {
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.getX() == index) {
                    component.delete();
                }
            }
        });
    }

    public void splitColumn(final int index) throws Exception {
        MigColumnInfo column = this.m_columns.get(index);
        MigColumnInfo newColumn = new MigColumnInfo(this);
        this.m_columns.add(index, newColumn);
        newColumn.setString(column.getString(false));
        this.writeDimensions();
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.getX() > index) {
                    cell.updateX(1);
                } else if (cell.getX() + cell.getWidth() > index) {
                    cell.updateWidth(1);
                }
                cell.write();
            }
        });
    }

    public void moveColumn(final int index, final int targetIndex) throws Exception {
        MigColumnInfo column = this.m_columns.remove(index);
        if (index < targetIndex) {
            this.m_columns.add(targetIndex - 1, column);
            this.visitGridComponents(new MigComponentVisitor(){

                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int x = constraints.getX();
                    int w = constraints.getWidth();
                    if (x < index) {
                        if (x + w - 1 >= index && x + w - 1 < targetIndex) {
                            constraints.updateWidth(-1);
                        }
                    } else if (x == index) {
                        constraints.setX(targetIndex - 1);
                        constraints.setWidth(1);
                    } else if (x > index && x < targetIndex) {
                        constraints.updateX(-1);
                        if (x + w - 1 >= targetIndex) {
                            constraints.updateWidth(1);
                        }
                    }
                    constraints.write();
                }
            });
        } else {
            this.m_columns.add(targetIndex, column);
            this.visitGridComponents(new MigComponentVisitor(){

                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int x = constraints.getX();
                    int w = constraints.getWidth();
                    if (x < targetIndex) {
                        if (x + w - 1 >= targetIndex && x + w - 1 < index) {
                            constraints.updateWidth(1);
                        }
                    } else if (x < index) {
                        constraints.updateX(1);
                        if (x + w - 1 >= index) {
                            constraints.updateWidth(-1);
                        }
                    } else if (x == index) {
                        constraints.setX(targetIndex);
                        constraints.setWidth(1);
                    }
                    constraints.write();
                }
            });
        }
        this.writeDimensions();
    }

    public void insertRow(int targetIndex) throws Exception {
        this.moveComponentsForInsert(-1, false, targetIndex, true);
        this.m_rows.add(targetIndex, new MigRowInfo(this));
        this.writeDimensions();
    }

    public void deleteRow(int index) throws Exception {
        this.moveComponentsForDelete(-1, false, index, true);
        this.m_rows.remove(index);
        this.writeDimensions();
    }

    public void clearRow(final int index) throws Exception {
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.getY() == index) {
                    component.delete();
                }
            }
        });
    }

    public void splitRow(final int index) throws Exception {
        MigRowInfo row = this.m_rows.get(index);
        MigRowInfo newRow = new MigRowInfo(this);
        this.m_rows.add(index, newRow);
        newRow.setString(row.getString(false));
        this.writeDimensions();
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.getY() > index) {
                    cell.updateY(1);
                } else if (cell.getY() + cell.getHeight() > index) {
                    cell.updateHeight(1);
                }
                cell.write();
            }
        });
    }

    public void moveRow(final int index, final int targetIndex) throws Exception {
        MigRowInfo row = this.m_rows.remove(index);
        if (index < targetIndex) {
            this.m_rows.add(targetIndex - 1, row);
            this.visitGridComponents(new MigComponentVisitor(){

                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int y = constraints.getY();
                    int h = constraints.getHeight();
                    if (y < index) {
                        if (y + h - 1 >= index && y + h - 1 < targetIndex) {
                            constraints.updateHeight(-1);
                        }
                    } else if (y == index) {
                        constraints.setY(targetIndex - 1);
                        constraints.setHeight(1);
                    } else if (y > index && y < targetIndex) {
                        constraints.updateY(-1);
                        if (y + h - 1 >= targetIndex) {
                            constraints.updateHeight(1);
                        }
                    }
                    constraints.write();
                }
            });
        } else {
            this.m_rows.add(targetIndex, row);
            this.visitGridComponents(new MigComponentVisitor(){

                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int y = constraints.getY();
                    int h = constraints.getHeight();
                    if (y < targetIndex) {
                        if (y + h - 1 >= targetIndex && y + h - 1 < index) {
                            constraints.updateHeight(1);
                        }
                    } else if (y < index) {
                        constraints.updateY(1);
                        if (y + h - 1 >= index) {
                            constraints.updateHeight(-1);
                        }
                    } else if (y == index) {
                        constraints.setY(targetIndex);
                        constraints.setHeight(1);
                    }
                    constraints.write();
                }
            });
        }
        this.writeDimensions();
    }

    public void command_setCells(ComponentInfo component, Rectangle cells) throws Exception {
        this.writeDimensions();
        this.makeExplicitCell();
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        constraints.setX(cells.x);
        constraints.setY(cells.y);
        constraints.setWidth(cells.width);
        constraints.setHeight(cells.height);
        constraints.write();
        this.writeAllConstraints();
    }

    public void command_CREATE(ComponentInfo newComponent, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.makeExplicitCell();
        Point cell = this.prepareCell(column, insertColumn, row, insertRow);
        ComponentInfo nextComponent = this.getReference(column, row, null);
        this.add(newComponent, "\"\"", nextComponent);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(newComponent);
        constraints.setX(cell.x);
        constraints.setY(cell.y);
        this.writeAllConstraints();
        this.doAutomaticAlignment(newComponent);
    }

    public void command_MOVE(ComponentInfo component, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.makeExplicitCell();
        Point cell = this.prepareCell(column, insertColumn, row, insertRow);
        ComponentInfo nextComponent = this.getReference(column, row, component);
        this.move(component, "\"\"", nextComponent);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        constraints.setX(cell.x);
        constraints.setY(cell.y);
        constraints.setWidth(1);
        constraints.setHeight(1);
        constraints.setDockSide(null);
        this.writeAllConstraints();
    }

    private void makeExplicitCell() {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            constraints.makeExplicitCell();
        }
    }

    private void writeAllConstraints() throws Exception {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            constraints.write();
        }
    }

    private ComponentInfo getReference(int column, int row, ComponentInfo exclude) throws Exception {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport constraints;
            if (component == exclude || (constraints = MigLayoutInfo.getConstraints(component)).getY() <= row && (constraints.getY() != row || constraints.getX() < column)) continue;
            return component;
        }
        return null;
    }

    private Point prepareCell(int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        boolean writeDimensions = false;
        if (insertColumn || insertRow) {
            this.moveComponentsForInsert(column, insertColumn, row, insertRow);
            if (insertColumn) {
                this.m_columns.add(column, new MigColumnInfo(this));
            }
            if (insertRow) {
                this.m_rows.add(row, new MigRowInfo(this));
            }
            writeDimensions = true;
        }
        while (this.m_columns.size() <= column) {
            this.m_columns.add(new MigColumnInfo(this));
            writeDimensions = true;
        }
        while (this.m_rows.size() <= row) {
            this.m_rows.add(new MigRowInfo(this));
            writeDimensions = true;
        }
        if (writeDimensions) {
            this.writeDimensions();
        }
        return new Point(column, row);
    }

    private void moveComponentsForInsert(final int column, final boolean insertColumn, final int row, final boolean insertRow) throws Exception {
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (insertColumn) {
                    if (cell.getX() >= column) {
                        cell.updateX(1);
                    } else if (cell.getX() + cell.getWidth() > column) {
                        cell.updateWidth(1);
                    }
                }
                if (insertRow) {
                    if (cell.getY() >= row) {
                        cell.updateY(1);
                    } else if (cell.getY() + cell.getHeight() > row) {
                        cell.updateHeight(1);
                    }
                }
                cell.write();
            }
        });
    }

    private void moveComponentsForDelete(final int column, final boolean deleteColumn, final int row, final boolean deleteRow) throws Exception {
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (deleteColumn) {
                    if (cell.getX() == column) {
                        component.delete();
                    } else if (cell.getX() >= column) {
                        cell.updateX(-1);
                    } else if (cell.getX() + cell.getWidth() > column) {
                        cell.updateWidth(-1);
                    }
                }
                if (deleteRow) {
                    if (cell.getY() == row) {
                        component.delete();
                    } else if (cell.getY() >= row) {
                        cell.updateY(-1);
                    } else if (cell.getY() + cell.getHeight() > row) {
                        cell.updateHeight(-1);
                    }
                }
                cell.write();
            }
        });
    }

    public List<ComponentInfo> getCellComponents(ComponentInfo component) {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
        return this.getCellComponents(constraints.getX(), constraints.getY());
    }

    public List<ComponentInfo> getCellComponents(final int column, final int row) {
        final ArrayList components = Lists.newArrayList();
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport constraints) throws Exception {
                int x = constraints.getX();
                int y = constraints.getY();
                int w = constraints.getWidth();
                int h = constraints.getHeight();
                if (x <= column && column < x + w && y <= row && row < y + h) {
                    components.add(component);
                }
            }
        });
        return components;
    }

    public void command_splitCREATE(int column, int row, boolean horizontalFlow, ComponentInfo newComponent, ComponentInfo nextComponent) throws Exception {
        horizontalFlow = this.getUpdatedSplitFlow(column, row, horizontalFlow);
        this.add(newComponent, "\"\"", nextComponent);
        this.split_updateCellFlow(column, row, horizontalFlow, newComponent);
    }

    public void command_splitMOVE(int column, int row, boolean horizontalFlow, ComponentInfo movedComponent, ComponentInfo nextComponent) throws Exception {
        horizontalFlow = this.getUpdatedSplitFlow(column, row, horizontalFlow);
        this.move(movedComponent, "\"\"", nextComponent);
        this.split_updateCellFlow(column, row, horizontalFlow, movedComponent);
    }

    private void split_updateCellFlow(int column, int row, boolean horizontalFlow, ComponentInfo movedComponent) throws Exception {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(movedComponent);
        constraints.setX(column);
        constraints.setY(row);
        List<ComponentInfo> components = this.getCellComponents(column, row);
        boolean isFirst = true;
        for (ComponentInfo component : components) {
            CellConstraintsSupport constraints2 = MigLayoutInfo.getConstraints(component);
            if (isFirst) {
                isFirst = false;
                constraints2.setHorizontalSplit(horizontalFlow);
                continue;
            }
            constraints2.setHorizontalSplit(null);
        }
        this.writeAllConstraints();
    }

    private boolean getUpdatedSplitFlow(int column, int row, boolean horizontalFlow) {
        List<ComponentInfo> components = this.getCellComponents(column, row);
        if (components.size() > 1) {
            horizontalFlow = MigLayoutInfo.getConstraints(components.get(0)).isHorizontalSplit();
        }
        return horizontalFlow;
    }

    private void visitGridComponents(final MigComponentVisitor visitor) {
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                MigLayoutInfo.this.visitAllComponents(new MigComponentVisitor(){

                    public void visit(ComponentInfo component, CellConstraintsSupport constraints) throws Exception {
                        if (constraints.getDockSide() == null) {
                            visitor.visit(component, constraints);
                        }
                    }
                });
            }
        });
    }

    private void visitAllComponents(MigComponentVisitor visitor) throws Exception {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport cell = MigLayoutInfo.getConstraints(component);
            visitor.visit(component, cell);
        }
    }

    private void doAutomaticAlignment(ComponentInfo component) throws Exception {
        final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        GridAlignmentHelper.doAutomaticAlignment((IAbstractComponentInfo)component, (GridAlignmentHelper.IAlignmentProcessor)new GridAlignmentHelper.IAlignmentProcessor<ComponentInfo>(){

            public boolean grabEnabled() {
                return preferences.getBoolean("MigLayout.enableGrab");
            }

            public boolean rightEnabled() {
                return preferences.getBoolean("MigLayout.enableRightAlignment");
            }

            public ComponentInfo getComponentAtLeft(ComponentInfo component) {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
                return MigLayoutInfo.this.getComponentAt(constraints.getX() - 1, constraints.getY());
            }

            public ComponentInfo getComponentAtRight(ComponentInfo component) {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
                return MigLayoutInfo.this.getComponentAt(constraints.getX() + 1, constraints.getY());
            }

            public void setGrabFill(ComponentInfo component, boolean horizontal) throws Exception {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
                if (horizontal) {
                    MigLayoutInfo.this.getColumns().get(constraints.getX()).setGrow(Float.valueOf(100.0f));
                    constraints.setHorizontalAlignment(MigColumnInfo.Alignment.FILL);
                } else {
                    MigLayoutInfo.this.getRows().get(constraints.getY()).setGrow(Float.valueOf(100.0f));
                    constraints.setVerticalAlignment(MigRowInfo.Alignment.FILL);
                }
                MigLayoutInfo.this.writeDimensions();
                constraints.write();
            }

            public void setRightAlignment(ComponentInfo component) throws Exception {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
                constraints.setHorizontalAlignment(MigColumnInfo.Alignment.TRAILING);
                constraints.write();
            }
        });
    }

    private ComponentInfo getComponentAt(int x, int y) {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            if (constraints.getX() != x || constraints.getY() != y) continue;
            return component;
        }
        return null;
    }

    public void refresh_dispose() throws Exception {
        this.m_gridInfo = null;
        super.refresh_dispose();
    }

    protected void refresh_afterCreate2() throws Exception {
        String cons;
        Interval interval;
        super.refresh_afterCreate2();
        Container container = this.getContainer().getContainer();
        Dimension containerSizeOriginal = container.getSize();
        try {
            container.setSize(450, 300);
            container.doLayout();
        }
        finally {
            container.setSize(containerSizeOriginal);
        }
        Interval[] columnIntervals = MigLayoutInfo.getIntervalsForOrigins(IDEUtil.getColumnSizes((Object)container), 0);
        Interval[] rowIntervals = MigLayoutInfo.getIntervalsForOrigins(IDEUtil.getRowSizes((Object)container), 0);
        int i = 0;
        while (i < columnIntervals.length) {
            interval = columnIntervals[i];
            if (interval.length() == 0) {
                cons = "cell " + i + " 0,width " + 25 + "px";
                container.add((Component)new JLabel(), cons);
            }
            ++i;
        }
        i = 0;
        while (i < rowIntervals.length) {
            interval = rowIntervals[i];
            if (interval.length() == 0) {
                cons = "cell 0 " + i + ",height " + 25 + "px";
                container.add((Component)new JLabel(), cons);
            }
            ++i;
        }
        container.doLayout();
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        this.updateColumnsRows();
    }

    public IGridInfo getGridInfo() {
        if (this.m_gridInfo == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    MigLayoutInfo.this.createGridInfo();
                }
            });
        }
        return this.m_gridInfo;
    }

    private void createGridInfo() throws Exception {
        final Insets insets = this.getContainer().getInsets();
        Container container = this.getContainer().getContainer();
        if (IDEUtil.getColumnSizes((Object)container) == null) {
            container.doLayout();
        }
        final Interval[] columnIntervals = MigLayoutInfo.getIntervalsForOrigins(IDEUtil.getColumnSizes((Object)container), insets.left);
        final Interval[] rowIntervals = MigLayoutInfo.getIntervalsForOrigins(IDEUtil.getRowSizes((Object)container), insets.top);
        final HashMap componentToCells = Maps.newHashMap();
        final HashMap occupiedCells = Maps.newHashMap();
        this.visitGridComponents(new MigComponentVisitor(){

            public void visit(ComponentInfo component, CellConstraintsSupport support) throws Exception {
                Rectangle cells = new Rectangle(support.getX(), support.getY(), support.getWidth(), support.getHeight());
                componentToCells.put(component, cells);
                int x = cells.x;
                while (x < cells.right()) {
                    int y = cells.y;
                    while (y < cells.bottom()) {
                        occupiedCells.put(new Point(x, y), component);
                        ++y;
                    }
                    ++x;
                }
            }
        });
        this.m_gridInfo = new IGridInfo(){

            public int getColumnCount() {
                return columnIntervals.length;
            }

            public int getRowCount() {
                return rowIntervals.length;
            }

            public Interval[] getColumnIntervals() {
                return columnIntervals;
            }

            public Interval[] getRowIntervals() {
                return rowIntervals;
            }

            public Rectangle getComponentCells(IAbstractComponentInfo component) {
                Assert.instanceOf(ComponentInfo.class, (Object)component);
                List<ComponentInfo> components = MigLayoutInfo.this.getCellComponents((ComponentInfo)component);
                if (components.size() > 1 && components.get(0) != component) {
                    return this.getComponentCells((IAbstractComponentInfo)components.get(0));
                }
                return (Rectangle)componentToCells.get(component);
            }

            public Rectangle getCellsRectangle(Rectangle cells) {
                if (cells == null) {
                    return new Rectangle(0, 0, 0, 0);
                }
                int x = columnIntervals[cells.x].begin;
                int y = rowIntervals[cells.y].begin;
                if (cells.isEmpty()) {
                    return new Rectangle(x, y, 0, 0);
                }
                int w = columnIntervals[cells.right() - 1].end() - x;
                int h = rowIntervals[cells.bottom() - 1].end() - y;
                return new Rectangle(x, y, w + 1, h + 1);
            }

            public boolean isRTL() {
                return false;
            }

            public Insets getInsets() {
                return insets;
            }

            public boolean hasVirtualColumns() {
                return true;
            }

            public int getVirtualColumnSize() {
                return 25;
            }

            public int getVirtualColumnGap() {
                return 4;
            }

            public boolean hasVirtualRows() {
                return true;
            }

            public int getVirtualRowSize() {
                return 25;
            }

            public int getVirtualRowGap() {
                return 4;
            }

            public IAbstractComponentInfo getOccupied(int column, int row) {
                return (IAbstractComponentInfo)occupiedCells.get(new Point(column, row));
            }
        };
    }

    protected void storeLayoutData(ComponentInfo component) throws Exception {
        CellConstraintsSupport gridData = MigLayoutInfo.getConstraints(component);
        if (gridData != null) {
            GeneralLayoutData generalLayoutData = new GeneralLayoutData();
            generalLayoutData.gridX = gridData.getX();
            generalLayoutData.gridY = gridData.getY();
            generalLayoutData.spanX = gridData.getWidth();
            generalLayoutData.spanY = gridData.getHeight();
            generalLayoutData.horizontalGrab = null;
            generalLayoutData.verticalGrab = null;
            generalLayoutData.horizontalAlignment = (GeneralLayoutData.HorizontalAlignment)GeneralLayoutData.getGeneralValue(m_horizontalAlignmentMap, (Object)((Object)gridData.getHorizontalAlignment()));
            generalLayoutData.verticalAlignment = (GeneralLayoutData.VerticalAlignment)GeneralLayoutData.getGeneralValue(m_verticalAlignmentMap, (Object)((Object)gridData.getVerticalAlignment()));
            generalLayoutData.putToInfo((ObjectInfo)component);
        }
    }

    private static Interval[] getIntervalsForOrigins(int[][] sizes, int startOffset) {
        Assert.isTrue((sizes.length != 0 ? 1 : 0) != 0);
        ArrayList intervals = Lists.newArrayList();
        int begin = startOffset;
        int index = 0;
        while (index < sizes[0].length) {
            int intervalIndex = sizes[0][index];
            int gap = sizes[1][2 * index + 0];
            int size = sizes[1][2 * index + 1];
            begin += gap;
            if (Math.abs(intervalIndex) < 30000) {
                intervals.add(new Interval(begin, size));
            }
            begin += size;
            ++index;
        }
        return intervals.toArray(new Interval[intervals.size()]);
    }

    private final class EditDimensionsAction
    extends Action {
        private final boolean m_horizontal;

        public EditDimensionsAction(String text, boolean horizontal) {
            super(text);
            this.m_horizontal = horizontal;
        }

        public void run() {
            Shell shell = DesignerPlugin.getShell();
            if (this.m_horizontal) {
                new ColumnsDialog(shell, MigLayoutInfo.this).open();
            } else {
                new RowsDialog(shell, MigLayoutInfo.this).open();
            }
        }
    }

    private static interface MigComponentVisitor {
        public void visit(ComponentInfo var1, CellConstraintsSupport var2) throws Exception;
    }
}

