/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EventTable {
    private final Map<Class<?>, List<?>> m_listenerClassToListener = Maps.newHashMap();

    public <T> void addListener(Class<T> listenerClass, T listener) {
        ArrayList listeners = this.getListenersImpl(listenerClass);
        if (listeners == null) {
            listeners = Lists.newArrayList();
            this.m_listenerClassToListener.put(listenerClass, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public <T> void removeListener(Class<T> listenerClass, T listener) {
        List<T> listeners = this.getListenersImpl(listenerClass);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public <T> List<T> getListeners(Class<T> listenerClass) {
        List<T> listeners = this.getListenersImpl(listenerClass);
        return listeners == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(listeners));
    }

    private <T> List<T> getListenersImpl(Class<T> listenerClass) {
        return this.m_listenerClassToListener.get(listenerClass);
    }
}

