/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.dialogs;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.command.ComponentEditCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.ComponentAbstractDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ComponentEntryInfo;
import org.eclipse.wb.internal.core.xml.model.EditorContext;

public final class ComponentEditDialog
extends ComponentAbstractDialog {
    private final ComponentEntryInfo m_component;

    public ComponentEditDialog(Shell parentShell, EditorContext context, ComponentEntryInfo component) {
        super(parentShell, context, Messages.ComponentEditDialog_title, Messages.ComponentEditDialog_message);
        this.m_component = component;
    }

    @Override
    protected void createControls(Composite container) {
        super.createControls(container);
        this.m_idField.setText(this.m_component.getId());
        this.m_nameField.setText(this.m_component.getName());
        this.m_classField.setText(this.m_component.getClassName());
        this.m_descriptionField.setText(this.m_component.getDescription());
        this.m_visibleField.setSelection(this.m_component.isVisible());
    }

    @Override
    protected Command createCommand() {
        String name = this.m_nameField.getText().trim();
        String description = this.getDescriptionText();
        boolean hidden = this.m_visibleField.getSelection();
        String className = this.m_classField.getText();
        return new ComponentEditCommand(this.m_component.getId(), name, description, hidden, className);
    }
}

