/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.structure.property;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;

public final class PropertyListIntersector {
    private List<PropertyGroup> m_intersection;

    public void intersect(Property[] properties) {
        if (this.m_intersection == null) {
            this.m_intersection = Lists.newArrayList();
            int i = 0;
            while (i < properties.length) {
                Property property = properties[i];
                this.m_intersection.add(new PropertyGroup(property));
                ++i;
            }
        } else {
            Iterator<PropertyGroup> I = this.m_intersection.iterator();
            while (I.hasNext()) {
                PropertyGroup propertyGroup = I.next();
                if (propertyGroup.add(properties)) continue;
                I.remove();
            }
        }
    }

    public Property[] getProperties() {
        ArrayList properties = Lists.newArrayList();
        for (PropertyGroup propertyGroup : this.m_intersection) {
            Property compositeProperty = propertyGroup.getCompositeProperty();
            if (compositeProperty == null) continue;
            properties.add(compositeProperty);
        }
        return properties.toArray(new Property[properties.size()]);
    }

    private static final class PropertyGroup {
        private final List<Property> m_properties = Lists.newArrayList();

        public PropertyGroup(Property property) {
            this.m_properties.add(property);
        }

        public boolean add(Property[] properties) {
            Property[] propertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Property property = propertyArray[n2];
                if (this.add(property)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Property getCompositeProperty() {
            Property[] properties = this.m_properties.toArray(new Property[this.m_properties.size()]);
            return properties[0].getComposite(properties);
        }

        private boolean add(Property property) {
            Property example = this.m_properties.get(0);
            if (example.getClass() == property.getClass() && example.getTitle().equals(property.getTitle()) && PropertyManager.getCategory(example) == PropertyManager.getCategory(property)) {
                this.m_properties.add(property);
                return true;
            }
            return false;
        }
    }
}

