/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.edit;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.header.Headers;
import org.eclipse.wb.core.gef.header.IHeaderMenuProvider;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.ParentTargetDragEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

public abstract class DimensionHeaderEditPart<T extends MigDimensionInfo>
extends GraphicalEditPart
implements IHeaderMenuProvider {
    private static final String DEFAULT_FONT_NAME = "Arial";
    protected static final Color COLOR_NORMAL = Headers.COLOR_HEADER;
    protected static final Font DEFAULT_FONT = new Font(null, "Arial", 7, 0);
    protected static final Color[] GROUP_COLORS = new Color[]{new Color(null, 200, 255, 200), new Color(null, 255, 210, 170), new Color(null, 180, 255, 255), new Color(null, 255, 255, 180), new Color(null, 230, 180, 255)};
    protected final MigLayoutInfo m_layout;
    protected final T m_dimension;
    private final Figure m_containerFigure;

    public DimensionHeaderEditPart(MigLayoutInfo layout, T dimension, Figure containerFigure) {
        this.m_layout = layout;
        this.m_dimension = dimension;
        this.m_containerFigure = containerFigure;
        this.setModel(dimension);
    }

    public abstract int getIndex();

    public final MigLayoutInfo getLayout() {
        return this.m_layout;
    }

    public final T getDimension() {
        return this.m_dimension;
    }

    public final Point getOffset() {
        Point offset = new Point(0, 0);
        FigureUtils.translateFigureToAbsolute2((Figure)this.m_containerFigure, (Translatable)offset);
        return offset;
    }

    public final Tool getDragTrackerTool(Request request) {
        return new ParentTargetDragEditPartTracker((EditPart)this);
    }

    protected void refreshVisuals() {
        this.getFigure().setBackground(COLOR_NORMAL);
    }

    protected Image getImage(String name) {
        return Activator.getImage(name);
    }

    protected ImageDescriptor getImageDescriptor(String name) {
        return Activator.getImageDescriptor(name);
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "open") {
            this.editDimension();
        }
    }

    protected abstract void editDimension();
}

