/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import java.util.List;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.ILayoutRequestValidatorHelper;

public abstract class AbstractLayoutRequestValidator
implements ILayoutRequestValidator {
    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        return this.validate(host, request.getNewObject());
    }

    @Override
    public boolean validatePasteRequest(final EditPart host, final PasteRequest request) {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<Boolean>(){

            @Override
            public Boolean runObject() throws Exception {
                ILayoutRequestValidatorHelper validatorHelper = GlobalState.getValidatorHelper();
                List mementos = (List)request.getMemento();
                for (Object memento : mementos) {
                    IComponentDescription description = validatorHelper.getPasteComponentDescription(memento);
                    if (AbstractLayoutRequestValidator.this.validateDescription(host, description)) continue;
                    return false;
                }
                return true;
            }
        }, false);
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        for (EditPart editPart : request.getEditParts()) {
            if (this.validate(host, editPart.getModel())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        return this.validateMoveRequest(host, request);
    }

    protected abstract boolean validate(EditPart var1, Object var2);

    protected abstract boolean validateDescription(EditPart var1, IComponentDescription var2);
}

