/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.clipboard;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.ComponentInfoMemento;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.xml.model.clipboard.PropertiesClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public class XmlObjectMemento
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String KEY_MEMENTO = "KEY_MEMENTO";
    private final String m_componentClassName;
    private final IClipboardCreationSupport m_creationSupport;
    private final List<ClipboardCommand> m_commands = Lists.newArrayList();
    private transient XmlObjectInfo m_javaInfo;
    private transient boolean m_applied;

    public static XmlObjectMemento createMemento(XmlObjectInfo javaInfo) throws Exception {
        if (javaInfo instanceof AbstractComponentInfo) {
            return new ComponentInfoMemento((AbstractComponentInfo)javaInfo);
        }
        return new XmlObjectMemento(javaInfo);
    }

    public static boolean hasMemento(XmlObjectInfo javaInfo) {
        if (javaInfo.isRoot()) {
            return false;
        }
        return javaInfo.getCreationSupport().getClipboard() != null;
    }

    public static void apply(XmlObjectInfo object) throws Exception {
        XmlObjectMemento memento = (XmlObjectMemento)object.getArbitraryValue(KEY_MEMENTO);
        memento.apply();
    }

    public static boolean isApplying(XmlObjectInfo object) {
        return (XmlObjectMemento)object.getArbitraryValue(KEY_MEMENTO) != null;
    }

    protected XmlObjectMemento(XmlObjectInfo javaInfo) throws Exception {
        this.m_componentClassName = javaInfo.getDescription().getComponentClass().getName();
        this.m_creationSupport = javaInfo.getCreationSupport().getClipboard();
        Assert.isNotNull((Object)this.m_creationSupport, (String)"No clipboard CreationSupport for %s", (Object[])new Object[]{javaInfo});
        XmlObjectMemento.cleanUpAnonymous(this.m_creationSupport);
        XmlObjectMemento.addCommands(javaInfo, this.m_commands);
    }

    static void addCommands(XmlObjectInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
        commands.add(new PropertiesClipboardCommand(javaInfo));
        ((XmlObjectClipboardCopy)javaInfo.getBroadcast(XmlObjectClipboardCopy.class)).invoke(javaInfo, commands);
        for (ClipboardCommand command : commands) {
            XmlObjectMemento.cleanUpAnonymous(command);
        }
    }

    static void cleanUpAnonymous(Object o) throws Exception {
        int i = 0;
        while (i < 10) {
            Field field = ReflectionUtils.getFieldByName(o.getClass(), (String)("this$" + i));
            if (field != null) {
                field.set(o, null);
            }
            ++i;
        }
    }

    public String getComponentClassName() {
        return this.m_componentClassName;
    }

    public XmlObjectInfo create(XmlObjectInfo existingHierarchyObject) throws Exception {
        Assert.isLegal((!this.m_applied ? 1 : 0) != 0, (String)"This memento already applied.");
        if (this.m_javaInfo == null) {
            XmlObjectInfo rootObject = existingHierarchyObject.getRootXML();
            EditorContext context = rootObject.getContext();
            CreationSupport creationSupport = this.m_creationSupport.create(rootObject);
            this.m_javaInfo = XmlObjectUtils.createObject(context, this.m_componentClassName, creationSupport);
            this.m_javaInfo.putArbitraryValue(KEY_MEMENTO, this);
        }
        return this.m_javaInfo;
    }

    public void apply() throws Exception {
        Assert.isNotNull((Object)((Object)this.m_javaInfo), (String)"XMLObject_Info should be already created using create().");
        Assert.isLegal((this.m_javaInfo.getParent() != null ? 1 : 0) != 0, (String)"XMLObject_Info should be already bounds to the hierarchy.");
        Assert.isLegal((!this.m_applied ? 1 : 0) != 0, (String)"This memento already applied.");
        this.m_applied = true;
        if (XmlObjectUtils.hasTrueParameter(this.m_javaInfo, "clipboard.lightRefresh")) {
            this.m_javaInfo.getRootXML().refreshLight();
        }
        this.m_creationSupport.apply(this.m_javaInfo);
        this.executeCommands();
        this.m_javaInfo.removeArbitraryValue(KEY_MEMENTO);
    }

    private void executeCommands() throws Exception {
        for (ClipboardCommand command : this.m_commands) {
            command.execute(this.m_javaInfo);
        }
    }
}

