/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.ActionUtils;
import org.eclipse.wb.internal.core.editor.actions.DeleteAction;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.editor.actions.CopyAction;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;

public class CutAction
extends Action {
    private final IEditPartViewer m_viewer;
    private Command m_command;

    public CutAction(IEditPartViewer viewer) {
        this.m_viewer = viewer;
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CutAction.this.firePropertyChange("enabled", null, CutAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
            }
        });
        ActionUtils.copyPresentation((IAction)this, (ActionFactory)ActionFactory.CUT);
    }

    public void run() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                List editParts = CutAction.this.m_viewer.getSelectedEditParts();
                List<XmlObjectMemento> m_mementos = CopyAction.getMementos(editParts);
                CopyAction.doCopy(m_mementos);
                CutAction.this.m_viewer.getEditDomain().executeCommand(CutAction.this.m_command);
            }
        });
    }

    public boolean isEnabled() {
        List editParts = this.m_viewer.getSelectedEditParts();
        this.m_command = DeleteAction.getCommand((List)editParts);
        return CopyAction.hasMementos(editParts) && this.m_command != null;
    }
}

