/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import java.text.MessageFormat;
import java.util.List;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.layout.UnitValue;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;

public final class MigRowInfo
extends MigDimensionInfo {
    public static final Alignment[] ALIGNMENTS_TO_SET = new Alignment[]{Alignment.DEFAULT, Alignment.TOP, Alignment.CENTER, Alignment.BOTTOM, Alignment.FILL, Alignment.BASELINE};

    public MigRowInfo(MigLayoutInfo layout) {
        super(layout, false);
    }

    @Override
    public void delete() throws Exception {
        this.m_layout.deleteRow(this.getIndex());
    }

    @Override
    public List<? extends MigDimensionInfo> getSiblings() {
        return this.m_layout.getRows();
    }

    @Override
    protected DimConstraint fetchConstraint() {
        int index = this.getIndex();
        AC colSpecs = (AC)ReflectionUtils.getFieldObject((Object)this.m_layout.getObject(), (String)"rowSpecs");
        if (index >= 0 && index < colSpecs.getCount()) {
            return colSpecs.getConstaints()[index];
        }
        return this.createDefaultConstraint();
    }

    @Override
    protected DimConstraint createDefaultConstraint() {
        return ConstraintParser.parseRowConstraints((String)"[]").getConstaints()[0];
    }

    public Alignment getAlignment(boolean resolveDefault) {
        return MigRowInfo.getAlignment(this.m_constraint, true, resolveDefault);
    }

    public void setAlignment(Alignment alignment) {
        MigRowInfo.setAlignment(this.m_constraint, alignment, true);
    }

    static Alignment getAlignment(DimConstraint constraint, boolean forRow, boolean resolveDefault) {
        UnitValue alignment;
        if (forRow && constraint.isFill()) {
            return Alignment.FILL;
        }
        if (!forRow && constraint.getGrow() != null) {
            return Alignment.FILL;
        }
        UnitValue unitValue = alignment = resolveDefault ? constraint.getAlignOrDefault(false) : constraint.getAlign();
        if (alignment == null) {
            return Alignment.DEFAULT;
        }
        if (alignment == IDEUtil.TOP) {
            return Alignment.TOP;
        }
        if (alignment == IDEUtil.CENTER) {
            return Alignment.CENTER;
        }
        if (alignment == IDEUtil.BOTTOM) {
            return Alignment.BOTTOM;
        }
        if (alignment == IDEUtil.BASELINE_IDENTITY) {
            return Alignment.BASELINE;
        }
        return Alignment.UNKNOWN;
    }

    static void setAlignment(DimConstraint constraint, Alignment alignment, boolean forRow) {
        UnitValue alignmentValue;
        Assert.isNotNull((Object)((Object)alignment));
        if (alignment == Alignment.DEFAULT) {
            constraint.setAlign(null);
            if (forRow) {
                constraint.setFill(false);
            } else {
                constraint.setGrow(null);
            }
            return;
        }
        if (alignment == Alignment.FILL) {
            if (forRow) {
                constraint.setFill(true);
            } else {
                constraint.setGrow(Float.valueOf(100.0f));
            }
            constraint.setAlign(null);
            return;
        }
        switch (alignment) {
            case TOP: {
                alignmentValue = IDEUtil.TOP;
                break;
            }
            case CENTER: {
                alignmentValue = IDEUtil.CENTER;
                break;
            }
            case BOTTOM: {
                alignmentValue = IDEUtil.BOTTOM;
                break;
            }
            case BASELINE: {
                alignmentValue = IDEUtil.BASELINE_IDENTITY;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(ModelMessages.MigRowInfo_canNotSetAlignment, new Object[]{alignment}));
            }
        }
        constraint.setAlign(alignmentValue);
        if (!forRow) {
            constraint.setGrow(null);
        } else {
            constraint.setFill(false);
        }
    }

    public static enum Alignment {
        UNKNOWN,
        DEFAULT,
        TOP,
        CENTER,
        BOTTOM,
        FILL,
        BASELINE;


        public Image getSmallImage() {
            String pattern = "alignment/v/small/{0}.gif";
            String path = MessageFormat.format(pattern, this.name().toLowerCase());
            return Activator.getImage(path);
        }

        public ImageDescriptor getMenuImage() {
            String pattern = "alignment/v/menu/{0}.gif";
            String path = MessageFormat.format(pattern, this.name().toLowerCase());
            return Activator.getImageDescriptor(path);
        }

        public String getText() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

