"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const SemanticTokensBuilder_1 = require("../utils/SemanticTokensBuilder");
const cancellation_1 = require("../utils/cancellation");
const common_1 = require("../utils/common");
const featureWorkers_1 = require("../utils/featureWorkers");
const language_core_1 = require("@volar/language-core");
function register(context) {
    return async (uri, range, legend, token = cancellation_1.NoneCancellationToken, _reportProgress) => {
        const sourceScript = context.language.scripts.get(uri);
        if (!sourceScript) {
            return;
        }
        const document = context.documents.get(uri, sourceScript.languageId, sourceScript.snapshot);
        if (!range) {
            range = {
                start: { line: 0, character: 0 },
                end: { line: document.lineCount - 1, character: document.getText().length },
            };
        }
        const tokens = await (0, featureWorkers_1.languageFeatureWorker)(context, uri, () => range, function* (map) {
            const mapped = (0, common_1.findOverlapCodeRange)(map.sourceDocument.offsetAt(range.start), map.sourceDocument.offsetAt(range.end), map.map, language_core_1.isSemanticTokensEnabled);
            if (mapped) {
                yield {
                    start: map.embeddedDocument.positionAt(mapped.start),
                    end: map.embeddedDocument.positionAt(mapped.end),
                };
            }
        }, (service, document, range) => {
            if (token?.isCancellationRequested) {
                return;
            }
            return service[1].provideDocumentSemanticTokens?.(document, range, legend, token);
        }, (tokens, map) => {
            if (!map) {
                return tokens;
            }
            return tokens
                .map(_token => {
                const range = map.getSourceRange({
                    start: { line: _token[0], character: _token[1] },
                    end: { line: _token[0], character: _token[1] + _token[2] },
                }, language_core_1.isSemanticTokensEnabled);
                if (range) {
                    return [range.start.line, range.start.character, range.end.character - range.start.character, _token[3], _token[4]];
                }
            })
                .filter(common_1.notEmpty);
        }, tokens => tokens.flat());
        if (tokens) {
            return buildTokens(tokens);
        }
    };
}
exports.register = register;
function buildTokens(tokens) {
    const builder = new SemanticTokensBuilder_1.SemanticTokensBuilder();
    const sortedTokens = tokens.sort((a, b) => a[0] - b[0] === 0 ? a[1] - b[1] : a[0] - b[0]);
    for (const token of sortedTokens) {
        builder.push(...token);
    }
    return builder.build();
}
//# sourceMappingURL=provideDocumentSemanticTokens.js.map