/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Nullable;

public interface IThemeSource {
    private static ContentType guessFileFormat(String fileName) {
        String extension;
        return switch (extension = fileName.substring(fileName.lastIndexOf(46) + 1).trim().toLowerCase()) {
            case "json" -> ContentType.JSON;
            case "yaml-tmtheme", "yml", "yaml" -> ContentType.YAML;
            case "tmtheme", "xml", "plist" -> ContentType.XML;
            default -> throw new IllegalArgumentException("Unsupported file type: " + fileName);
        };
    }

    public static IThemeSource fromFile(Path file) {
        return IThemeSource.fromFile(file, null, null);
    }

    public static IThemeSource fromFile(final Path file, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final String filePath = file.toString();
        final ContentType contentType1 = contentType == null ? IThemeSource.guessFileFormat(filePath) : contentType;
        return new IThemeSource(){

            @Override
            public Reader getReader() throws IOException {
                return Files.newBufferedReader(file, charset == null ? StandardCharsets.UTF_8 : charset);
            }

            @Override
            public String getFilePath() {
                return filePath;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }
        };
    }

    public static IThemeSource fromResource(Class<?> clazz, String resourceName) {
        return IThemeSource.fromResource(clazz, resourceName, null, null);
    }

    public static IThemeSource fromResource(final Class<?> clazz, final String resourceName, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final ContentType contentType1 = contentType == null ? IThemeSource.guessFileFormat(resourceName) : contentType;
        return new IThemeSource(){

            @Override
            public Reader getReader() {
                return new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(resourceName), charset == null ? StandardCharsets.UTF_8 : charset));
            }

            @Override
            public String getFilePath() {
                return resourceName;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }
        };
    }

    public static IThemeSource fromString(final ContentType contentType, final String content) {
        return new IThemeSource(){

            @Override
            public Reader getReader() {
                return new StringReader(content);
            }

            @Override
            public String getFilePath() {
                return "string." + contentType.name().toLowerCase();
            }

            @Override
            public ContentType getContentType() {
                return contentType;
            }
        };
    }

    default public ContentType getContentType() {
        return IThemeSource.guessFileFormat(this.getFilePath());
    }

    public String getFilePath();

    public Reader getReader() throws IOException;

    public static enum ContentType {
        JSON,
        YAML,
        XML;

    }
}

