/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.util.ArrayList;
import org.eclipse.dstore.core.java.RemoteClassLoader;
import org.eclipse.dstore.core.model.IExternalLoader;
import org.eclipse.dstore.core.util.StringCompare;

public class ExternalLoader
implements IExternalLoader {
    private ClassLoader _classLoader;
    private ArrayList _loadScope;

    public ExternalLoader(ClassLoader classLoader, String loadScope) {
        this._classLoader = classLoader;
        this._loadScope = new ArrayList();
        this._loadScope.add(loadScope);
    }

    public ExternalLoader(ClassLoader classLoader, ArrayList loadScope) {
        this._classLoader = classLoader;
        this._loadScope = loadScope;
    }

    public boolean canLoad(String source) {
        if (this._classLoader instanceof RemoteClassLoader) {
            return true;
        }
        boolean result = false;
        if (this._loadScope != null) {
            int i = 0;
            while (i < this._loadScope.size()) {
                String scope = (String)this._loadScope.get(i);
                result = StringCompare.compare(scope, source, true);
                if (result) {
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    public Class loadClass(String source) throws ClassNotFoundException {
        try {
            return this._classLoader.loadClass(source);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(source);
        }
    }
}

