/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.css;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.css.CSSStyle;
import org.eclipse.tm4e.core.internal.theme.css.RGBColorImpl;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

public final class CSSDocumentHandler
implements DocumentHandler {
    private final List<IStyle> list = new ArrayList<IStyle>();
    private @Nullable CSSStyle currentStyle;

    public void comment(@Nullable String arg0) throws CSSException {
    }

    public void endDocument(@Nullable InputSource arg0) throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void endMedia(@Nullable SACMediaList arg0) throws CSSException {
    }

    public void endPage(@Nullable String arg0, @Nullable String arg1) throws CSSException {
    }

    public void endSelector(@Nullable SelectorList selector) throws CSSException {
        this.currentStyle = null;
    }

    public void ignorableAtRule(@Nullable String arg0) throws CSSException {
    }

    public void importStyle(@Nullable String arg0, @Nullable SACMediaList arg1, @Nullable String arg2) throws CSSException {
    }

    public void namespaceDeclaration(@Nullable String arg0, @Nullable String arg1) throws CSSException {
    }

    public void property(@Nullable String name, @Nullable LexicalUnit value, boolean arg2) throws CSSException {
        block20: {
            CSSStyle currentStyle = this.currentStyle;
            if (currentStyle == null || name == null || value == null) break block20;
            switch (name) {
                case "color": {
                    currentStyle.setColor(this.createRGB(value));
                    break;
                }
                case "background-color": {
                    currentStyle.setBackgroundColor(this.createRGB(value));
                    break;
                }
                case "font-weight": {
                    currentStyle.setBold(value.getStringValue().toUpperCase().contains("BOLD"));
                    break;
                }
                case "font-style": {
                    currentStyle.setItalic(value.getStringValue().toUpperCase().contains("ITALIC"));
                    break;
                }
                case "text-decoration": {
                    String decoration = value.getStringValue().toUpperCase();
                    if (decoration.contains("UNDERLINE")) {
                        currentStyle.setUnderline(true);
                    }
                    if (!decoration.contains("LINE-THROUGH")) break;
                    currentStyle.setStrikeThrough(true);
                }
            }
        }
    }

    private RGB createRGB(LexicalUnit value) {
        RGBColorImpl rgbColor = new RGBColorImpl(value);
        int green = (int)rgbColor.getGreen().getFloatValue((short)1);
        int red = (int)rgbColor.getRed().getFloatValue((short)1);
        int blue = (int)rgbColor.getBlue().getFloatValue((short)1);
        return new RGB(red, green, blue);
    }

    public void startDocument(@Nullable InputSource arg0) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void startMedia(@Nullable SACMediaList arg0) throws CSSException {
    }

    public void startPage(@Nullable String arg0, @Nullable String arg1) throws CSSException {
    }

    public void startSelector(@Nullable SelectorList selector) throws CSSException {
        assert (selector != null);
        this.currentStyle = new CSSStyle(selector);
        this.list.add(this.currentStyle);
    }

    public List<IStyle> getList() {
        return this.list;
    }
}

