/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.grammar.TokenTypeMatcher;
import org.eclipse.tm4e.core.internal.grammar.tokenattrs.EncodedTokenAttributes;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;

final class LineTokens {
    private static final System.Logger LOGGER = System.getLogger(LineTokens.class.getName());
    private static final Deque<IToken> EMPTY_DEQUE = new ArrayDeque<IToken>(0);
    private final boolean _emitBinaryTokens;
    private final String _lineText;
    private final Deque<IToken> _tokens;
    private final List<Integer> _binaryTokens;
    private int _lastTokenEndIndex = 0;
    private final List<TokenTypeMatcher> _tokenTypeOverrides;
    private final @Nullable BalancedBracketSelectors balancedBracketSelectors;

    LineTokens(boolean emitBinaryTokens, String lineText, List<TokenTypeMatcher> tokenTypeOverrides, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        this._emitBinaryTokens = emitBinaryTokens;
        this._tokenTypeOverrides = tokenTypeOverrides;
        String string = this._lineText = LOGGER.isLoggable(System.Logger.Level.TRACE) ? lineText : "";
        if (this._emitBinaryTokens) {
            this._tokens = EMPTY_DEQUE;
            this._binaryTokens = new ArrayList<Integer>();
        } else {
            this._tokens = new ArrayDeque<IToken>();
            this._binaryTokens = Collections.emptyList();
        }
        this.balancedBracketSelectors = balancedBracketSelectors;
    }

    void produce(StateStack stack, int endIndex) {
        this.produceFromScopes(stack.contentNameScopesList, endIndex);
    }

    void produceFromScopes(AttributedScopeStack scopesList, final int endIndex) {
        if (this._lastTokenEndIndex >= endIndex) {
            return;
        }
        if (this._emitBinaryTokens) {
            List<String> scopes;
            int metadata = scopesList.tokenAttributes;
            boolean containsBalancedBrackets = false;
            BalancedBracketSelectors balancedBracketSelectors = this.balancedBracketSelectors;
            if (balancedBracketSelectors != null && balancedBracketSelectors.matchesAlways()) {
                containsBalancedBrackets = true;
            }
            if (!this._tokenTypeOverrides.isEmpty() || balancedBracketSelectors != null && !balancedBracketSelectors.matchesAlways() && !balancedBracketSelectors.matchesNever()) {
                scopes = scopesList.getScopeNames();
                for (TokenTypeMatcher tokenType : this._tokenTypeOverrides) {
                    if (!tokenType.matcher.matches(scopes)) continue;
                    metadata = EncodedTokenAttributes.set(metadata, 0, tokenType.type, null, -1, 0, 0);
                }
                if (balancedBracketSelectors != null) {
                    containsBalancedBrackets = balancedBracketSelectors.match(scopes);
                }
            }
            if (containsBalancedBrackets) {
                metadata = EncodedTokenAttributes.set(metadata, 0, 8, containsBalancedBrackets, -1, 0, 0);
            }
            if (!this._binaryTokens.isEmpty() && MoreCollections.getLastElement(this._binaryTokens) == metadata) {
                this._lastTokenEndIndex = endIndex;
                return;
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                scopes = scopesList.getScopeNames();
                LOGGER.log(System.Logger.Level.TRACE, "  token: |" + this._lineText.substring(this._lastTokenEndIndex >= 0 ? this._lastTokenEndIndex : 0, endIndex).replace("\n", "\\n") + '|');
                for (String scope : scopes) {
                    LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
                }
            }
            this._binaryTokens.add(this._lastTokenEndIndex);
            this._binaryTokens.add(metadata);
            this._lastTokenEndIndex = endIndex;
            return;
        }
        final List<String> scopes = scopesList.getScopeNames();
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "  token: |" + this._lineText.substring(this._lastTokenEndIndex, endIndex).replace("\n", "\\n") + '|');
            for (String scope : scopes) {
                LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
            }
        }
        this._tokens.add(new IToken(){
            private int startIndex;
            {
                this.startIndex = LineTokens.this._lastTokenEndIndex;
            }

            @Override
            public int getStartIndex() {
                return this.startIndex;
            }

            @Override
            public void setStartIndex(int startIndex) {
                this.startIndex = startIndex;
            }

            @Override
            public int getEndIndex() {
                return endIndex;
            }

            @Override
            public List<String> getScopes() {
                return scopes;
            }

            public String toString() {
                return "{startIndex: " + this.startIndex + ", endIndex: " + endIndex + ", scopes: " + scopes + "}";
            }
        });
        this._lastTokenEndIndex = endIndex;
    }

    IToken[] getResult(StateStack stack, int lineLength) {
        if (!this._tokens.isEmpty() && this._tokens.getLast().getStartIndex() == lineLength - 1) {
            this._tokens.removeLast();
        }
        if (this._tokens.isEmpty()) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._tokens.getLast().setStartIndex(0);
        }
        return (IToken[])this._tokens.toArray(IToken[]::new);
    }

    int[] getBinaryResult(StateStack stack, int lineLength) {
        if (!this._binaryTokens.isEmpty() && this._binaryTokens.get(this._binaryTokens.size() - 2) == lineLength - 1) {
            MoreCollections.removeLastElement(this._binaryTokens);
            MoreCollections.removeLastElement(this._binaryTokens);
        }
        if (this._binaryTokens.isEmpty()) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._binaryTokens.set(this._binaryTokens.size() - 2, 0);
        }
        return this._binaryTokens.stream().mapToInt(Integer::intValue).toArray();
    }
}

