import { BaseSourceMapTransformer } from './baseSourceMapTransformer';
import { ILaunchRequestArgs, IAttachRequestArgs } from '../debugAdapterInterfaces';
/**
 * Load SourceMaps on launch. Requires reading the file and parsing out the sourceMappingURL, because
 * if you wait until the script is loaded as in LazySMT, you get that info from the runtime.
 */
export declare class EagerSourceMapTransformer extends BaseSourceMapTransformer {
    private static SOURCE_MAPPING_MATCHER;
    protected init(args: ILaunchRequestArgs | IAttachRequestArgs): void;
    private discoverSourceMapForGeneratedScript(generatedScriptPath);
    /**
     * Try to find the 'sourceMappingURL' in content or the file with the given path.
     * Returns null if no source map url is found or if an error occured.
     */
    private findSourceMapUrlInFile(pathToGenerated, content?);
    /**
     * Try to find the 'sourceMappingURL' at the end of the given contents.
     * Relative file paths are converted into absolute paths.
     * Returns null if no source map url is found.
     */
    private findSourceMapUrl(contents);
}
