/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;

public abstract class AbstractDebugAdapterLaunchShortcut
implements ILaunchShortcut2 {
    private final String[] contentTypeIds;
    private final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
    private final ILaunchConfigurationType configType;
    private final boolean autoStartNewlyCreatedConfiguration;

    protected AbstractDebugAdapterLaunchShortcut(String launchConfigTypeId, String contentTypeId, boolean autoStartNewlyCreatedConfiguration) {
        this(launchConfigTypeId, new String[]{contentTypeId}, autoStartNewlyCreatedConfiguration);
    }

    protected AbstractDebugAdapterLaunchShortcut(String launchConfigTypeId, String[] contentTypeIds, boolean autoStartNewlyCreatedConfiguration) {
        this.autoStartNewlyCreatedConfiguration = autoStartNewlyCreatedConfiguration;
        this.contentTypeIds = contentTypeIds;
        this.configType = this.launchManager.getLaunchConfigurationType(launchConfigTypeId);
    }

    public boolean canLaunch(File file) {
        if (file.exists()) {
            if (Arrays.stream(this.contentTypeIds).map(arg_0 -> ((IContentTypeManager)Platform.getContentTypeManager()).getContentType(arg_0)).anyMatch(type -> type.isAssociatedWith(file.getName()))) {
                return true;
            }
        }
        return false;
    }

    public boolean canLaunchResource(IResource resource) {
        int resourceType = resource.getType();
        if (resourceType == 1) {
            File file = resource.getLocation().toFile();
            return this.canLaunch(file);
        }
        return false;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IResource launchableResource = this.getLaunchableResource(selection);
        if (launchableResource != null) {
            return this.getLaunchConfigurations(launchableResource.getLocation().toFile());
        }
        return this.getLaunchConfigurations(SelectionUtils.getFile(selection, this::canLaunch));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        IResource launchableResource = this.getLaunchableResource(editorpart);
        if (launchableResource != null) {
            return this.getLaunchConfigurations(launchableResource.getLocation().toFile());
        }
        return this.getLaunchConfigurations(SelectionUtils.getFile(editorpart.getEditorInput(), this::canLaunch));
    }

    /*
     * WARNING - void declaration
     */
    public IResource getLaunchableResource(ISelection selection) {
        void var3_2;
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection) == (IStructuredSelection)var3_2) {
            void structuredSelection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object firstObject = structuredSelection.getFirstElement();
            IResource resource = (IResource)Adapters.adapt((Object)firstObject, IResource.class);
            int resourceType = resource.getType();
            if (resourceType == 1) {
                if (this.canLaunch(resource.getLocation().toFile())) {
                    return resource;
                }
            } else if (resourceType == 4 || resourceType == 2) {
                return this.getLaunchableResource((IContainer)Adapters.adapt((Object)resource, IContainer.class));
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IFile file;
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput && this.canLaunch((file = ((FileEditorInput)input).getFile()).getLocation().toFile())) {
            return file;
        }
        return null;
    }

    protected abstract IResource getLaunchableResource(IContainer var1);

    public void launch(ISelection selection, String mode) {
        this.launch(mode, this.getLaunchConfigurations(selection), SelectionUtils.getFile(selection, this::canLaunch));
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(mode, this.getLaunchConfigurations(editor), SelectionUtils.getFile(editor.getEditorInput(), this::canLaunch));
    }

    private void launch(String mode, ILaunchConfiguration[] configurations, File launchableFile) {
        LaunchConfigurationSelectionDialog dialog;
        if (configurations == null) {
            return;
        }
        if (configurations.length == 0 && launchableFile != null && launchableFile.exists()) {
            try {
                ILaunchConfigurationWorkingCopy configuration = this.createNewLaunchConfiguration(launchableFile);
                Display.getDefault().asyncExec(() -> this.lambda$6((ILaunchConfiguration)configuration, mode));
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e));
            }
        } else if (configurations.length == 1) {
            Display.getDefault().asyncExec(() -> DebugUITools.launch((ILaunchConfiguration)configurations[0], (String)mode));
        } else if (configurations.length > 1 && (dialog = new LaunchConfigurationSelectionDialog(Display.getDefault().getActiveShell(), (Object)configurations)).open() == 0) {
            this.launch(mode, Arrays.asList(dialog.getResult()).toArray(new ILaunchConfiguration[dialog.getResult().length]), launchableFile);
        }
    }

    private ILaunchConfiguration[] getLaunchConfigurations(File file) {
        if (file == null || !this.canLaunch(file)) {
            return null;
        }
        try {
            ILaunchConfiguration[] existing = (ILaunchConfiguration[])Arrays.stream(this.launchManager.getLaunchConfigurations(this.configType)).filter(launchConfig -> this.match((ILaunchConfiguration)launchConfig, file)).toArray(ILaunchConfiguration[]::new);
            if (existing.length != 0) {
                return existing;
            }
            return new ILaunchConfiguration[0];
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
            Activator.getDefault().getLog().log(e.getStatus());
            return new ILaunchConfiguration[0];
        }
    }

    private ILaunchConfigurationWorkingCopy createNewLaunchConfiguration(File file) throws CoreException {
        String configName = this.launchManager.generateLaunchConfigurationName(file.getAbsolutePath());
        ILaunchConfigurationWorkingCopy wc = this.configType.newInstance(null, configName);
        wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", file.getParentFile().getAbsolutePath());
        wc.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI()));
        this.configureLaunchConfiguration(file, wc);
        return wc;
    }

    protected void configureLaunchConfiguration(File file, ILaunchConfigurationWorkingCopy wc) {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        wc.setAttribute("program", iFile == null ? file.getAbsolutePath() : "${workspace_loc:" + iFile.getFullPath() + "}");
        wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", file.getParentFile().getAbsolutePath());
    }

    private boolean match(ILaunchConfiguration launchConfig, File selectedFile) {
        try {
            String program = launchConfig.getAttribute("program", "");
            HashSet<String> validValues = new HashSet<String>();
            validValues.add(selectedFile.getAbsolutePath());
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(selectedFile.getAbsolutePath()));
            if (iFile != null) {
                validValues.add("${workspace_loc:" + iFile.getFullPath() + '}');
                validValues.add("${workspace_loc:" + iFile.getProject().getName() + "}/" + iFile.getProjectRelativePath());
                validValues.add("${workspace_loc:/" + iFile.getProject().getName() + "}/" + iFile.getProjectRelativePath());
            }
            return validValues.contains(program);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return false;
        }
    }

    private /* synthetic */ void lambda$6(ILaunchConfiguration iLaunchConfiguration, String string) {
        if (this.autoStartNewlyCreatedConfiguration) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        } else if (DebugUIPlugin.openLaunchConfigurationEditDialog((Shell)Display.getCurrent().getActiveShell(), (ILaunchConfiguration)iLaunchConfiguration, (String)DebugUITools.getLaunchGroup((ILaunchConfiguration)iLaunchConfiguration, (String)string).getIdentifier(), null, (boolean)true) == 0) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }
}

