/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.api.violation.PluginVisitor;
import org.eclipse.wtp.releng.tools.component.images.ImagesUtil;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class APIProgressScanner
extends AbstractEmitter {
    private Collection api;
    private Collection src;
    private String timestamp;
    private String progressDir;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private Map pluginId2CompName = new HashMap();

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getProgressDir() {
        return this.progressDir;
    }

    public void setProgressDir(String progressDir) {
        this.progressDir = this.addTrailingSeperator(progressDir);
    }

    public Collection getApi() {
        return this.api;
    }

    public void setApi(Collection api) {
        this.api = api;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(Collection src) {
        this.src = src;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public void execute() {
        this.genAPIInfoSummary();
        if (this.timestamp != null && this.progressDir != null) {
            this.genSVG();
        }
    }

    private void genAPIInfoSummary() {
        final StringBuffer apiProgress = new StringBuffer();
        apiProgress.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        apiProgress.append("<root>");
        if (this.src != null && this.api != null) {
            apiProgress.append(this.validatePlugins());
        }
        ILocation loc = Location.createLocation(new File(this.outputDir));
        loc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith("api-info.xml")) {
                    apiProgress.append("<api-info file=\"./");
                    apiProgress.append(location.getAbsolutePath().substring(APIProgressScanner.this.outputDir.length()));
                    try {
                        OverviewDocLoader loader;
                        String url;
                        String compName;
                        ComponentAPI compAPI = new ComponentAPI();
                        compAPI.setLocation(location);
                        compAPI.load();
                        String id = compAPI.getName();
                        if (id != null && (compName = (String)APIProgressScanner.this.pluginId2CompName.get(id)) != null && (url = (loader = new OverviewDocLoader(compName)).getOverviewDocURL()) != null) {
                            apiProgress.append("\" overviewDoc=\"");
                            apiProgress.append(url);
                        }
                    }
                    catch (Throwable throwable) {}
                    apiProgress.append("\"/>");
                }
                return true;
            }
        });
        apiProgress.append("</root>");
        try {
            ImagesUtil.copyAll(this.outputDir);
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-progress.xsl"), new ByteArrayInputStream(apiProgress.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "api-progress.html")), this.outputDir);
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-progress-summary.xsl"), new ByteArrayInputStream(apiProgress.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "api-info-summary.xml")), this.outputDir);
        }
        catch (Throwable throwable) {
            try {
                XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-progress.xsl").openStream(), new ByteArrayInputStream(apiProgress.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "api-progress.html")), this.outputDir);
                XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-progress-summary.xsl").openStream(), new ByteArrayInputStream(apiProgress.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "api-info-summary.xml")), this.outputDir);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    private String validatePlugins() {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> pluginsWithoutComp = new ArrayList<String>();
        ArrayList<String> pluginsNotFoundInSrc = new ArrayList<String>();
        ArrayList<String> pluginsInMoreThan1Comp = new ArrayList<String>();
        ArrayList<String> pluginIds = new ArrayList<String>();
        Iterator i = this.api.iterator();
        while (i.hasNext()) {
            ILocation apiLocation = Location.createLocation(new File((String)i.next()));
            ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
            apiLocation.accept(compXMLVisitor);
            Iterator it = compXMLVisitor.getCompXMLs().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                String compName = compXML.getName();
                Iterator it2 = compXML.getPlugins().iterator();
                while (it2.hasNext()) {
                    String id = ((Plugin)it2.next()).getId();
                    this.pluginId2CompName.put(id, compName);
                    if (pluginIds.contains(id)) {
                        pluginsInMoreThan1Comp.add(id);
                        continue;
                    }
                    pluginIds.add(id);
                }
            }
        }
        Iterator it = this.src.iterator();
        while (it.hasNext()) {
            ILocation srcLocation = Location.createLocation(new File((String)it.next()));
            PluginVisitor v = new PluginVisitor();
            srcLocation.accept(v);
            Iterator it2 = v.getPluginIds().iterator();
            while (it2.hasNext()) {
                String id = (String)it2.next();
                if (pluginIds.remove(id) || !this.include(id)) continue;
                pluginsWithoutComp.add(id);
            }
        }
        it = pluginIds.iterator();
        while (it.hasNext()) {
            pluginsNotFoundInSrc.add((String)it.next());
        }
        it = pluginsWithoutComp.iterator();
        while (it.hasNext()) {
            sb.append("<plugin-without-comp id=\"");
            sb.append((String)it.next());
            sb.append("\"/>");
        }
        it = pluginsNotFoundInSrc.iterator();
        while (it.hasNext()) {
            sb.append("<missing-plugin id=\"");
            sb.append((String)it.next());
            sb.append("\"/>");
        }
        it = pluginsInMoreThan1Comp.iterator();
        while (it.hasNext()) {
            sb.append("<dup-plugin id=\"");
            sb.append((String)it.next());
            sb.append("\"/>");
        }
        return sb.toString();
    }

    private void genSVG() {
        File src = new File(String.valueOf(this.outputDir) + "api-info-summary.xml");
        File dest = new File(String.valueOf(this.progressDir) + this.timestamp + "/api-info-summary.xml");
        try {
            this.copy(src, dest);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        final StringBuffer content = new StringBuffer();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.append("<root name=\"#name\">");
        ILocation progress = Location.createLocation(new File(this.progressDir));
        ILocationChildrenIterator it = progress.childIterator();
        ILocation child = it.next();
        while (child != null) {
            content.append("<summary timestamp=\"");
            content.append(child.getName());
            content.append("\"/>");
            child = it.next();
        }
        content.append("</root>");
        ILocation loc = Location.createLocation(new File(this.outputDir));
        loc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith("api-info.xml")) {
                    try {
                        ComponentAPI compAPI = new ComponentAPI();
                        compAPI.setLocation(location);
                        compAPI.load();
                        String compName = compAPI.getName();
                        StringBuffer sb = new StringBuffer();
                        sb.append(APIProgressScanner.this.outputDir);
                        sb.append("svg/");
                        new File(sb.toString()).mkdirs();
                        APIProgressScanner.this.genSVG(content.toString(), compName, sb.toString());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return true;
            }
        });
        try {
            this.genSVG(content.toString(), "total", String.valueOf(this.outputDir) + "svg/");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void genSVG(String content, String name, String outDir) throws IOException, TransformerConfigurationException, TransformerException {
        XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-progress-svg.xsl"), new ByteArrayInputStream(content.replaceAll("#name", name).getBytes()), (OutputStream)new FileOutputStream(String.valueOf(outDir) + name + ".svg"), this.progressDir);
    }

    private void copy(File src, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(dest);
        FileInputStream fis = new FileInputStream(src);
        byte[] b = new byte[2048];
        int read = fis.read(b);
        while (read != -1) {
            fos.write(b, 0, read);
            read = fis.read(b);
        }
        fis.close();
        fos.close();
    }

    private boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List api = (List)options.get("api");
        List src = (List)options.get("src");
        List timestamp = (List)options.get("timestamp");
        List progressDir = (List)options.get("progressDir");
        List outputDir = (List)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        if (outputDir == null || outputDir.size() < 1) {
            APIProgressScanner.printUsage();
            System.exit(-1);
        }
        APIProgressScanner scanner = new APIProgressScanner();
        if (api != null && api.size() > 0) {
            scanner.setApi(api);
        }
        if (src != null && src.size() > 0) {
            scanner.setSrc(src);
        }
        if (timestamp != null && timestamp.size() > 0) {
            scanner.setTimestamp((String)timestamp.iterator().next());
        }
        if (progressDir != null && progressDir.size() > 0) {
            scanner.setProgressDir((String)progressDir.iterator().next());
        }
        scanner.setOutputDir((String)outputDir.iterator().next());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.progress.APIProgressScanner -compIndex <compIndex> -eclipseDir <eclipseDir> -compXMLDir <compXMLDir> -outputDir <outputDir>");
        System.out.println("");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-api\t\t<api>\t\tlocation of your component.xml");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product");
        System.out.println("\t-timestamp\t<timestamp>\ttimestamp");
        System.out.println("\t-progressDir\t<progressDir>\tdirectory containing API progress documents");
        System.out.println("\t-includes\t<includes>\tspace seperated plug-ins to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated plug-ins to exclude");
    }

    private class OverviewDocLoader {
        private String componentName;

        public OverviewDocLoader(String componentName) {
            this.componentName = componentName;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getOverviewDocURL() {
            is = null;
            try {
                try {
                    url = new StringBuffer("http://www.eclipse.org/webtools/components/");
                    url.append(this.componentName);
                    url.append("/");
                    overviewDoc = new URL(url.toString());
                    is = overviewDoc.openStream();
                    var6_4 = url.toString();
                    var4_5 = null;
                }
                catch (Throwable v0) {
                    ** GOTO lbl-1000
                }
            }
            catch (Throwable var5_11) {
                var4_6 = null;
                try {
                    if (is == null) throw var5_11;
                    is.close();
                    throw var5_11;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                throw var5_11;
            }
            try {}
            catch (Throwable t) {
                t.printStackTrace();
                return var6_4;
            }
            if (is == null) return var6_4;
            is.close();
            return var6_4;
lbl-1000:
            // 1 sources

            {
                var4_7 = null;
            }
            try {}
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
            if (is == null) return null;
            is.close();
            return null;
        }
    }
}

