/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.EmbeddableAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EmbeddableTests
extends JavaResourceModelTestCase {
    public EmbeddableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEmbeddable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable");
            }
        });
    }

    private ICompilationUnit createTestEmbeddableAndEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable", "javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Embeddable");
            }
        });
    }

    public void testEmbeddable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Annotation mappingAnnotation = typeResource.getMappingAnnotation();
        EmbeddableTests.assertTrue((boolean)(mappingAnnotation instanceof EmbeddableAnnotation));
    }

    public void testEmbeddableAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddableAndEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Annotation mappingAnnotation = typeResource.getMappingAnnotation();
        EmbeddableTests.assertTrue((boolean)(mappingAnnotation instanceof EmbeddableAnnotation));
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation("javax.persistence.Entity");
        EmbeddableTests.assertNotNull((Object)entity);
    }
}

