/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AttributeOverrideTests
extends JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE";

    public AttributeOverrideTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAttributeOverrideOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverrideWithColumnOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"MY_COLUMN\"))");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
    }

    public void testGetNullColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertNull((Object)column);
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName("Foo");
        AttributeOverrideTests.assertEquals((String)"Foo", (String)attributeOverride.getName());
        this.assertSourceContains("@AttributeOverride(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName(null);
        AttributeOverrideTests.assertNull((Object)attributeOverride.getName());
        this.assertSourceDoesNotContain("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE\")", cu);
        this.assertSourceContains("@AttributeOverride", cu);
    }

    public void testColumnGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName("Foo");
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"Foo\"))", cu);
        column.setName(null);
        AttributeOverrideTests.assertNull((Object)attributeOverride.getColumn());
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")", cu);
    }

    public void testAddColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNull((Object)column);
    }

    public void testRemoveColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNull((Object)column);
    }
}

