/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class TestJpaProject
extends TestJavaProject {
    private final JpaProject jpaProject;
    public static final String JPA_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jpa.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        return new TestJpaProject(baseProjectName, autoBuild, jpaConfig);
    }

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild) throws CoreException {
        return TestJpaProject.buildJpaProject(baseProjectName, autoBuild, null);
    }

    public TestJpaProject(String projectName) throws CoreException {
        this(projectName, false);
    }

    public TestJpaProject(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public TestJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        super(projectName, autoBuild);
        this.installFacet("jst.utility", "1.0");
        this.installFacet("jpt.jpa", "1.0", jpaConfig);
        this.addJar(TestJpaProject.jpaJarName());
        if (TestJpaProject.eclipseLinkJarName() != null) {
            this.addJar(TestJpaProject.eclipseLinkJarName());
        }
        this.jpaProject = JptCorePlugin.getJpaProject((IProject)this.getProject());
        this.jpaProject.setDiscoversAnnotatedClasses(true);
        this.jpaProject.setUpdater((JpaProject.Updater)new SynchronousJpaProjectUpdater(this.jpaProject));
    }

    public static String jpaJarName() {
        return TestJpaProject.getSystemProperty(JPA_JAR_NAME_SYSTEM_PROPERTY);
    }

    public static String eclipseLinkJarName() {
        return TestJpaProject.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }
}

