/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceUnitDefaultsTests
extends ContextModelTestCase {
    public PersistenceUnitDefaultsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    protected OrmPersistenceUnitDefaults getPersistenceUnitDefaults() {
        return this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
    }

    public void testIsAllFeaturesUnset() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        XmlPersistenceUnitMetadata persistenceUnitMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
        this.getXmlEntityMappings().setPersistenceUnitMetadata(persistenceUnitMetadata);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitMetadata.isUnset());
        XmlPersistenceUnitDefaults persistenceUnitDefaultsResource = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        persistenceUnitMetadata.setPersistenceUnitDefaults(persistenceUnitDefaultsResource);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setSchema("asdf");
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setSchema(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCatalog("asdf");
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCatalog(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
    }

    public void testUpdateSchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifySchema2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCatalog2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCascadePersist2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setAccess(AccessType.PROPERTY);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyAccess2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setAccess(AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.getPersistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setAccess(AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }
}

