/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.core.tests.internal.context.JptCoreContextModelTests;
import org.eclipse.jpt.core.tests.internal.model.JptCoreModelTests;
import org.eclipse.jpt.core.tests.internal.resource.JptCoreResourceModelTests;
import org.eclipse.jpt.core.tests.internal.utility.jdt.JptCoreUtilityJdtTests;

public class JptCoreTests {
    private static final String JPA_JAR_PROPERTY = "org.eclipse.jpt.jpa.jar";

    public static Test suite() {
        TestSuite suite = new TestSuite(JptCoreTests.class.getPackage().getName());
        if (JptCoreTests.requiredJarsExists()) {
            suite.addTest(JptCoreUtilityJdtTests.suite());
            suite.addTest(JptCoreModelTests.suite());
            suite.addTest(JptCoreResourceModelTests.suite());
            suite.addTest(JptCoreContextModelTests.suite());
        } else {
            suite.addTest(TestSuite.warning((String)JptCoreTests.buildMissingJarErrorMessage()));
        }
        return suite;
    }

    public static boolean requiredJarsExists() {
        return JptCoreTests.jpaJarPropertyExists() && JptCoreTests.jpaJarFileExists();
    }

    public static boolean jpaJarPropertyExists() {
        return JptCoreTests.getSystemProperty(JPA_JAR_PROPERTY) != null;
    }

    public static boolean jpaJarFileExists() {
        return new File(JptCoreTests.getSystemProperty(JPA_JAR_PROPERTY)).exists();
    }

    private static String buildMissingJarErrorMessage() {
        if (!JptCoreTests.jpaJarPropertyExists()) {
            return JptCoreTests.errorMissingProperty(JPA_JAR_PROPERTY);
        }
        return JptCoreTests.errorJarFileDoesNotExist(JptCoreTests.getSystemProperty(JPA_JAR_PROPERTY));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private JptCoreTests() {
        throw new UnsupportedOperationException();
    }
}

