/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2114
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    public Map messages = new HashMap();

    public BP2114(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(Message m, Object parent, WSDLTraversalContext ctx) {
        if (m != null && !this.messages.containsKey(m) && m.getOrderedParts(null) != null) {
            HashSet<String> s = new HashSet<String>();
            Iterator it = m.getOrderedParts(null).iterator();
            while (it.hasNext()) {
                s.add(((Part)it.next()).getName());
            }
            if (s.size() > 0) {
                this.messages.put(m.getQName(), s);
            }
        }
    }

    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("style", style);
    }

    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        String style = operation.getStyle();
        if (style != null) {
            ctx.addParameter("style", style);
        }
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        Operation op = ctx.getBindingOperation().getOperation();
        if (op == null) {
            return;
        }
        Message m = null;
        if (parent instanceof BindingInput) {
            if (op.getInput() == null) {
                return;
            }
            m = op.getInput().getMessage();
        } else if (parent instanceof BindingOutput) {
            if (op.getOutput() == null) {
                return;
            }
            m = op.getOutput().getMessage();
        }
        if (m == null) {
            return;
        }
        List parts = WSDLUtil.getParts(op, m, body, null);
        if (parts == null) {
            return;
        }
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            this.removePart(m.getQName(), ((Part)it.next()).getName());
        }
    }

    public void visit(SOAPHeader header, Object parent, WSDLTraversalContext ctx) {
        this.removePart(header.getMessage(), header.getPart());
    }

    public void visit(SOAPHeaderFault fault, Object parent, WSDLTraversalContext ctx) {
        QName messageName = fault.getMessage();
        if (messageName == null) {
            messageName = ctx.getSOAPHeader().getMessage();
        }
        this.removePart(messageName, fault.getPart());
    }

    public void visit(SOAPFault fault, Object parent, WSDLTraversalContext ctx) {
        Operation op;
        String faultName = fault.getName();
        if (faultName == null) {
            faultName = ctx.getBindingFault().getName();
        }
        if ((op = ctx.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault f = op.getFault(faultName);
        if (f == null || f.getMessage() == null || f.getMessage().getParts().size() != 1) {
            return;
        }
        Part p = (Part)f.getMessage().getOrderedParts(null).get(0);
        this.removePart(f.getMessage().getQName(), p.getName());
    }

    private void removePart(QName messageName, String partName) {
        Set parts = (Set)this.messages.get(messageName);
        if (parts != null) {
            parts.remove(partName);
            if (parts.size() == 0) {
                this.messages.remove(messageName);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "warning";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitMessage(true);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPHeader(true);
        traversal.visitSOAPHeaderFault(true);
        traversal.visitSOAPFault(true);
        traversal.visitSOAPOperation(true);
        Binding b = (Binding)entryContext.getEntry().getEntryDetail();
        traversal.traverse(b);
        if (this.messages.size() > 0) {
            this.errors.add(b.getQName());
        }
        if (!this.errors.isEmpty()) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

